/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.components;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Set;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.core.options.PortSide;

public final class ComponentGroup {
    private static final Multimap<Set<PortSide>, Set<PortSide>> CONSTRAINTS = HashMultimap.create();
    private Multimap<Set<PortSide>, LGraph> components = ArrayListMultimap.create();

    static {
        CONSTRAINTS.put((Object)PortSide.SIDES_NONE, (Object)PortSide.SIDES_NORTH_EAST_SOUTH_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_WEST, (Object)PortSide.SIDES_NORTH_EAST_SOUTH_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_WEST, (Object)PortSide.SIDES_NORTH_SOUTH_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_EAST, (Object)PortSide.SIDES_NORTH_EAST_SOUTH);
        CONSTRAINTS.put((Object)PortSide.SIDES_EAST, (Object)PortSide.SIDES_NORTH_EAST_SOUTH_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH, (Object)PortSide.SIDES_NORTH_EAST_SOUTH_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH, (Object)PortSide.SIDES_NORTH_EAST_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_SOUTH, (Object)PortSide.SIDES_EAST_SOUTH_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_SOUTH, (Object)PortSide.SIDES_NORTH_EAST_SOUTH_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_SOUTH, (Object)PortSide.SIDES_EAST_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_SOUTH, (Object)PortSide.SIDES_NORTH_EAST_SOUTH_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_SOUTH, (Object)PortSide.SIDES_NORTH_EAST_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_SOUTH, (Object)PortSide.SIDES_EAST_SOUTH_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_EAST_WEST, (Object)PortSide.SIDES_NORTH_SOUTH);
        CONSTRAINTS.put((Object)PortSide.SIDES_EAST_WEST, (Object)PortSide.SIDES_NORTH_SOUTH_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_EAST_WEST, (Object)PortSide.SIDES_NORTH_EAST_SOUTH);
        CONSTRAINTS.put((Object)PortSide.SIDES_EAST_WEST, (Object)PortSide.SIDES_NORTH_EAST_SOUTH_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_WEST, (Object)PortSide.SIDES_NORTH_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_WEST, (Object)PortSide.SIDES_NORTH_EAST_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_WEST, (Object)PortSide.SIDES_NORTH_SOUTH_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_EAST, (Object)PortSide.SIDES_NORTH_EAST);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_EAST, (Object)PortSide.SIDES_NORTH_EAST_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_EAST, (Object)PortSide.SIDES_NORTH_EAST_SOUTH);
        CONSTRAINTS.put((Object)PortSide.SIDES_SOUTH_WEST, (Object)PortSide.SIDES_SOUTH_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_SOUTH_WEST, (Object)PortSide.SIDES_EAST_SOUTH_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_SOUTH_WEST, (Object)PortSide.SIDES_NORTH_SOUTH_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_EAST_SOUTH, (Object)PortSide.SIDES_EAST_SOUTH);
        CONSTRAINTS.put((Object)PortSide.SIDES_EAST_SOUTH, (Object)PortSide.SIDES_EAST_SOUTH_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_EAST_SOUTH, (Object)PortSide.SIDES_NORTH_EAST_SOUTH);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_EAST_WEST, (Object)PortSide.SIDES_NORTH);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_EAST_WEST, (Object)PortSide.SIDES_NORTH_SOUTH);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_EAST_WEST, (Object)PortSide.SIDES_NORTH_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_EAST_WEST, (Object)PortSide.SIDES_NORTH_EAST);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_EAST_WEST, (Object)PortSide.SIDES_NORTH_EAST_SOUTH_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_EAST_WEST, (Object)PortSide.SIDES_NORTH_EAST_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_EAST_WEST, (Object)PortSide.SIDES_NORTH_SOUTH_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_EAST_WEST, (Object)PortSide.SIDES_NORTH_EAST_SOUTH);
        CONSTRAINTS.put((Object)PortSide.SIDES_EAST_SOUTH_WEST, (Object)PortSide.SIDES_SOUTH);
        CONSTRAINTS.put((Object)PortSide.SIDES_EAST_SOUTH_WEST, (Object)PortSide.SIDES_NORTH_SOUTH);
        CONSTRAINTS.put((Object)PortSide.SIDES_EAST_SOUTH_WEST, (Object)PortSide.SIDES_SOUTH_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_EAST_SOUTH_WEST, (Object)PortSide.SIDES_EAST_SOUTH);
        CONSTRAINTS.put((Object)PortSide.SIDES_EAST_SOUTH_WEST, (Object)PortSide.SIDES_EAST_SOUTH_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_EAST_SOUTH_WEST, (Object)PortSide.SIDES_NORTH_SOUTH_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_EAST_SOUTH_WEST, (Object)PortSide.SIDES_NORTH_EAST_SOUTH);
        CONSTRAINTS.put((Object)PortSide.SIDES_EAST_SOUTH_WEST, (Object)PortSide.SIDES_NORTH_EAST_SOUTH_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_SOUTH_WEST, (Object)PortSide.SIDES_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_SOUTH_WEST, (Object)PortSide.SIDES_EAST_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_SOUTH_WEST, (Object)PortSide.SIDES_NORTH_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_SOUTH_WEST, (Object)PortSide.SIDES_SOUTH_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_SOUTH_WEST, (Object)PortSide.SIDES_NORTH_EAST_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_SOUTH_WEST, (Object)PortSide.SIDES_EAST_SOUTH_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_SOUTH_WEST, (Object)PortSide.SIDES_NORTH_SOUTH_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_EAST_SOUTH, (Object)PortSide.SIDES_EAST);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_EAST_SOUTH, (Object)PortSide.SIDES_EAST_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_EAST_SOUTH, (Object)PortSide.SIDES_NORTH_EAST);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_EAST_SOUTH, (Object)PortSide.SIDES_EAST_SOUTH);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_EAST_SOUTH, (Object)PortSide.SIDES_NORTH_EAST_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_EAST_SOUTH, (Object)PortSide.SIDES_EAST_SOUTH_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_EAST_SOUTH, (Object)PortSide.SIDES_NORTH_EAST_SOUTH);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_EAST_SOUTH, (Object)PortSide.SIDES_NORTH_EAST_SOUTH_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_EAST_SOUTH_WEST, (Object)PortSide.SIDES_NONE);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_EAST_SOUTH_WEST, (Object)PortSide.SIDES_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_EAST_SOUTH_WEST, (Object)PortSide.SIDES_EAST);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_EAST_SOUTH_WEST, (Object)PortSide.SIDES_NORTH);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_EAST_SOUTH_WEST, (Object)PortSide.SIDES_SOUTH);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_EAST_SOUTH_WEST, (Object)PortSide.SIDES_NORTH_SOUTH);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_EAST_SOUTH_WEST, (Object)PortSide.SIDES_EAST_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_EAST_SOUTH_WEST, (Object)PortSide.SIDES_NORTH_EAST_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_EAST_SOUTH_WEST, (Object)PortSide.SIDES_EAST_SOUTH_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_EAST_SOUTH_WEST, (Object)PortSide.SIDES_NORTH_SOUTH_WEST);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_EAST_SOUTH_WEST, (Object)PortSide.SIDES_NORTH_EAST_SOUTH);
        CONSTRAINTS.put((Object)PortSide.SIDES_NORTH_EAST_SOUTH_WEST, (Object)PortSide.SIDES_NORTH_EAST_SOUTH_WEST);
    }

    public ComponentGroup() {
    }

    public ComponentGroup(LGraph component) {
        this.add(component);
    }

    public boolean add(LGraph component) {
        if (this.canAdd(component)) {
            this.components.put((Object)((Set)component.getProperty(InternalProperties.EXT_PORT_CONNECTIONS)), (Object)component);
            return true;
        }
        return false;
    }

    private boolean canAdd(LGraph component) {
        Set candidateSides = (Set)component.getProperty(InternalProperties.EXT_PORT_CONNECTIONS);
        Collection constraints = CONSTRAINTS.get((Object)candidateSides);
        for (Set constraint : constraints) {
            if (this.components.get((Object)constraint).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Collection<LGraph> getComponents() {
        return this.components.values();
    }

    public Collection<LGraph> getComponents(Set<PortSide> connections) {
        return this.components.get(connections);
    }
}

