/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.loops.labeling;

import java.util.List;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopComponent;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopLabel;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopLabelPosition;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNode;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopPort;
import org.eclipse.elk.alg.layered.p5edges.loops.labeling.AbstractSelfLoopLabelPositionGenerator;
import org.eclipse.elk.alg.layered.p5edges.splines.SplinesMath;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.PortSide;

public class SideLoopLabelPositionGenerator
extends AbstractSelfLoopLabelPositionGenerator {
    public SideLoopLabelPositionGenerator(SelfLoopNode slNode) {
        super(slNode);
    }

    @Override
    public void generatePositions(SelfLoopComponent component) {
        double edgeEdgeSpacing = this.getEdgeEdgeSpacing();
        double edgeLabelSpacing = this.getEdgeLabelSpacing();
        List<SelfLoopPort> ports = component.getPorts();
        SelfLoopPort startPort = ports.get(0);
        SelfLoopPort endPort = ports.get(ports.size() - 1);
        KVector startPoint = startPort.getLPort().getPosition().clone().add(startPort.getLPort().getAnchor());
        KVector endPoint = endPort.getLPort().getPosition().clone().add(endPort.getLPort().getAnchor());
        KVector dirVectorStart = new KVector(SplinesMath.portSideToDirection(startPort.getPortSide()));
        KVector firstBend = startPoint.clone().add(dirVectorStart.clone().scale((double)startPort.getMaximumLevel() * edgeEdgeSpacing + edgeLabelSpacing));
        KVector dirVectorEnd = new KVector(SplinesMath.portSideToDirection(endPort.getPortSide()));
        KVector secondBend = endPoint.clone().add(dirVectorEnd.clone().scale((double)endPort.getMaximumLevel() * edgeEdgeSpacing + edgeLabelSpacing));
        this.addPositions(component.getSelfLoopLabel(), firstBend, secondBend, startPort, endPort);
    }

    private void addPositions(SelfLoopLabel label, KVector firstBend, KVector secondBend, SelfLoopPort startPort, SelfLoopPort endPort) {
        List<SelfLoopLabelPosition> positions = label.getCandidatePositions();
        KVector startPoint = startPort.getLPort().getPosition().clone().add(startPort.getLPort().getAnchor());
        KVector endPoint = endPort.getLPort().getPosition().clone().add(endPort.getLPort().getAnchor());
        positions.add(this.shortSegmentPosition(label, startPort, PortSide.NORTH, firstBend, secondBend, AbstractSelfLoopLabelPositionGenerator.Alignment.CENTERED, false));
        positions.add(this.shortSegmentPosition(label, startPort, PortSide.NORTH, firstBend, secondBend, AbstractSelfLoopLabelPositionGenerator.Alignment.LEFT_OR_TOP, false));
        positions.add(this.shortSegmentPosition(label, startPort, PortSide.NORTH, firstBend, secondBend, AbstractSelfLoopLabelPositionGenerator.Alignment.RIGHT_OR_BOTTOM, false));
        positions.add(this.outerSegmentPosition(label, startPort.getPortSide(), PortSide.WEST, startPoint, firstBend, true, AbstractSelfLoopLabelPositionGenerator.Alignment.CENTERED));
        positions.add(this.outerSegmentPosition(label, startPort.getPortSide(), PortSide.WEST, startPoint, firstBend, true, AbstractSelfLoopLabelPositionGenerator.Alignment.LEFT_OR_TOP));
        positions.add(this.outerSegmentPosition(label, startPort.getPortSide(), PortSide.WEST, startPoint, firstBend, true, AbstractSelfLoopLabelPositionGenerator.Alignment.RIGHT_OR_BOTTOM));
        positions.add(this.outerSegmentPosition(label, endPort.getPortSide(), PortSide.EAST, endPoint, secondBend, false, AbstractSelfLoopLabelPositionGenerator.Alignment.CENTERED));
        positions.add(this.outerSegmentPosition(label, endPort.getPortSide(), PortSide.EAST, endPoint, secondBend, false, AbstractSelfLoopLabelPositionGenerator.Alignment.LEFT_OR_TOP));
        positions.add(this.outerSegmentPosition(label, endPort.getPortSide(), PortSide.EAST, endPoint, secondBend, false, AbstractSelfLoopLabelPositionGenerator.Alignment.RIGHT_OR_BOTTOM));
    }
}

