/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.loops.labeling;

import org.eclipse.elk.alg.layered.graph.LGraphUtil;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopLabel;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopLabelPosition;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNode;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopPort;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopRoutingDirection;
import org.eclipse.elk.alg.layered.p5edges.loops.labeling.ISelfLoopLabelPositionGenerator;
import org.eclipse.elk.alg.layered.p5edges.loops.labeling.SelfLoopLabelPenalties;
import org.eclipse.elk.alg.layered.p5edges.splines.SplinesMath;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.PortSide;

public abstract class AbstractSelfLoopLabelPositionGenerator
implements ISelfLoopLabelPositionGenerator {
    protected static final double ANCHOR_SIZE = 5.0;
    private final SelfLoopNode slNode;
    private final double edgeEdgeSpacing;
    private final double edgeLabelSpacing;

    public AbstractSelfLoopLabelPositionGenerator(SelfLoopNode slNode) {
        this.slNode = slNode;
        this.edgeEdgeSpacing = LGraphUtil.getIndividualOrInherited(slNode.getNode(), LayeredOptions.SPACING_EDGE_EDGE);
        this.edgeLabelSpacing = LGraphUtil.getIndividualOrInherited(slNode.getNode(), LayeredOptions.SPACING_EDGE_LABEL);
    }

    protected SelfLoopNode getSelfLoopNode() {
        return this.slNode;
    }

    protected double getEdgeEdgeSpacing() {
        return this.edgeEdgeSpacing;
    }

    protected double getEdgeLabelSpacing() {
        return this.edgeLabelSpacing;
    }

    protected KVector centeredCoordinates(SelfLoopLabel label, PortSide labelOffsetDirection, KVector startPoint, KVector endPoint) {
        double pointDistance = startPoint.distance(endPoint);
        KVector offsetDirectionVector = new KVector(SplinesMath.portSideToDirection(labelOffsetDirection));
        KVector labelCoordinates = new KVector(startPoint);
        switch (labelOffsetDirection) {
            case NORTH: {
                labelCoordinates.x += (pointDistance - label.getWidth()) / 2.0;
                labelCoordinates.add(offsetDirectionVector.clone().scale(label.getHeight()));
                break;
            }
            case EAST: {
                labelCoordinates.y += pointDistance / 2.0 - label.getHeight() / 2.0;
                break;
            }
            case SOUTH: {
                labelCoordinates.x += pointDistance / 2.0 - label.getWidth() / 2.0;
                break;
            }
            case WEST: {
                labelCoordinates.y += (pointDistance - label.getHeight()) / 2.0;
                labelCoordinates.add(offsetDirectionVector.clone().scale(label.getWidth()));
            }
        }
        return labelCoordinates;
    }

    protected KVector topOrLeftAlignedCoordinates(SelfLoopLabel label, PortSide labelOffsetDirection, KVector startPoint, KVector endPoint) {
        KVector offsetDirectionVector = new KVector(SplinesMath.portSideToDirection(labelOffsetDirection));
        KVector labelCoordinates = new KVector(startPoint);
        switch (labelOffsetDirection) {
            case NORTH: {
                labelCoordinates.add(offsetDirectionVector.clone().scale(label.getHeight()));
                break;
            }
            case WEST: {
                labelCoordinates.add(offsetDirectionVector.clone().scale(label.getWidth()));
            }
        }
        return labelCoordinates;
    }

    protected KVector bottomOrRightAlignedCoordinates(SelfLoopLabel label, PortSide labelOffsetDirection, KVector startPoint, KVector endPoint) {
        KVector offsetDirectionVector = new KVector(SplinesMath.portSideToDirection(labelOffsetDirection));
        KVector reversedLineDirVector = new KVector(endPoint, startPoint).normalize();
        KVector labelCoordinates = new KVector(endPoint);
        switch (labelOffsetDirection) {
            case NORTH: {
                labelCoordinates.add(offsetDirectionVector.clone().scale(label.getHeight()));
                labelCoordinates.add(reversedLineDirVector.clone().scale(label.getWidth()));
                break;
            }
            case EAST: {
                labelCoordinates.add(reversedLineDirVector.clone().scale(label.getHeight()));
                break;
            }
            case SOUTH: {
                labelCoordinates.add(reversedLineDirVector.clone().scale(label.getWidth()));
                break;
            }
            case WEST: {
                labelCoordinates.add(offsetDirectionVector.clone().scale(label.getWidth()));
                labelCoordinates.add(reversedLineDirVector.clone().scale(label.getHeight()));
            }
        }
        return labelCoordinates;
    }

    protected SelfLoopLabelPosition outerSegmentPosition(SelfLoopLabel label, PortSide portSide, PortSide penaltySide, KVector portPoint, KVector bendPoint, boolean leftFromCenterSegment, Alignment alignment) {
        PortSide labelSide = leftFromCenterSegment ? portSide.left() : portSide.right();
        KVector startPoint = null;
        KVector endPoint = null;
        switch (portSide) {
            case NORTH: 
            case WEST: {
                startPoint = bendPoint;
                endPoint = portPoint;
                break;
            }
            case EAST: 
            case SOUTH: {
                startPoint = portPoint;
                endPoint = bendPoint;
            }
        }
        SelfLoopLabelPosition position = this.doCreateLabelPosition(label, portSide, labelSide, penaltySide, startPoint, endPoint, alignment);
        position.setBasePenalty(position.getBasePenalty() + 0.3);
        return position;
    }

    protected SelfLoopLabelPosition shortSegmentPosition(SelfLoopLabel label, SelfLoopPort closestPort, KVector portPoint, KVector bendPoint, Alignment alignment, boolean addShortSegmentPenalty) {
        return this.shortSegmentPosition(label, closestPort, closestPort.getPortSide(), portPoint, bendPoint, alignment, addShortSegmentPenalty);
    }

    protected SelfLoopLabelPosition shortSegmentPosition(SelfLoopLabel label, SelfLoopPort closestPort, PortSide penaltySide, KVector portPoint, KVector bendPoint, Alignment alignment, boolean addShortSegmentPenalty) {
        PortSide portSide = closestPort.getPortSide();
        SelfLoopRoutingDirection routingDirection = closestPort.getDirection();
        KVector startPoint = null;
        KVector endPoint = null;
        switch (portSide) {
            case NORTH: 
            case EAST: {
                startPoint = routingDirection == SelfLoopRoutingDirection.RIGHT ? portPoint : bendPoint;
                endPoint = routingDirection == SelfLoopRoutingDirection.RIGHT ? bendPoint : portPoint;
                break;
            }
            case SOUTH: 
            case WEST: {
                startPoint = routingDirection == SelfLoopRoutingDirection.LEFT ? portPoint : bendPoint;
                endPoint = routingDirection == SelfLoopRoutingDirection.LEFT ? bendPoint : portPoint;
            }
        }
        SelfLoopLabelPosition position = this.doCreateLabelPosition(label, portSide, portSide, penaltySide, startPoint, endPoint, alignment);
        if (addShortSegmentPenalty) {
            position.setBasePenalty(position.getBasePenalty() + 0.3);
        }
        return position;
    }

    protected SelfLoopLabelPosition longSegmentPosition(SelfLoopLabel label, PortSide segmentSide, KVector firstBend, KVector secondBend, Alignment alignment) {
        KVector startPoint = firstBend;
        KVector endPoint = secondBend;
        switch (segmentSide) {
            case NORTH: 
            case SOUTH: {
                if (!(firstBend.x > secondBend.x)) break;
                startPoint = secondBend;
                endPoint = firstBend;
                break;
            }
            case EAST: 
            case WEST: {
                if (!(firstBend.y > secondBend.y)) break;
                startPoint = secondBend;
                endPoint = firstBend;
            }
        }
        return this.doCreateLabelPosition(label, segmentSide, startPoint, endPoint, alignment);
    }

    private SelfLoopLabelPosition doCreateLabelPosition(SelfLoopLabel label, PortSide side, KVector startPoint, KVector endPoint, Alignment alignment) {
        return this.doCreateLabelPosition(label, side, side, side, startPoint, endPoint, alignment);
    }

    private SelfLoopLabelPosition doCreateLabelPosition(SelfLoopLabel label, PortSide segmentSide, PortSide labelSide, PortSide penaltySide, KVector startPoint, KVector endPoint, Alignment alignment) {
        KVector coordinates = null;
        switch (alignment) {
            case CENTERED: {
                coordinates = this.centeredCoordinates(label, labelSide, startPoint, endPoint);
                break;
            }
            case LEFT_OR_TOP: {
                coordinates = this.topOrLeftAlignedCoordinates(label, labelSide, startPoint, endPoint);
                break;
            }
            case RIGHT_OR_BOTTOM: {
                coordinates = this.bottomOrRightAlignedCoordinates(label, labelSide, startPoint, endPoint);
            }
        }
        SelfLoopLabelPosition.LabelAlignment labelAlignment = null;
        switch (labelSide) {
            case EAST: {
                labelAlignment = SelfLoopLabelPosition.LabelAlignment.LEFT;
                break;
            }
            case WEST: {
                labelAlignment = SelfLoopLabelPosition.LabelAlignment.RIGHT;
                break;
            }
            case NORTH: 
            case SOUTH: {
                labelAlignment = alignment.toLabelAlignment();
            }
        }
        SelfLoopLabelPosition position = new SelfLoopLabelPosition(label, coordinates);
        position.setSide(segmentSide);
        position.setLabelAlignment(labelAlignment);
        position.setBasePenalty(SelfLoopLabelPenalties.getSidePenalty(penaltySide) + SelfLoopLabelPenalties.getAlignmentPenalty(alignment));
        return position;
    }

    public static final class Alignment
    extends Enum<Alignment> {
        public static final /* enum */ Alignment LEFT_OR_TOP = new Alignment();
        public static final /* enum */ Alignment CENTERED = new Alignment();
        public static final /* enum */ Alignment RIGHT_OR_BOTTOM = new Alignment();
        private static final /* synthetic */ Alignment[] ENUM$VALUES;

        static {
            ENUM$VALUES = new Alignment[]{LEFT_OR_TOP, CENTERED, RIGHT_OR_BOTTOM};
        }

        private SelfLoopLabelPosition.LabelAlignment toLabelAlignment() {
            switch (this) {
                case LEFT_OR_TOP: {
                    return SelfLoopLabelPosition.LabelAlignment.LEFT;
                }
                case CENTERED: {
                    return SelfLoopLabelPosition.LabelAlignment.CENTERED;
                }
                case RIGHT_OR_BOTTOM: {
                    return SelfLoopLabelPosition.LabelAlignment.RIGHT;
                }
            }
            assert (false);
            return null;
        }

        public static Alignment[] values() {
            Alignment[] alignmentArray = ENUM$VALUES;
            int n = alignmentArray.length;
            Alignment[] alignmentArray2 = new Alignment[n];
            System.arraycopy(ENUM$VALUES, 0, alignmentArray2, 0, n);
            return alignmentArray2;
        }

        public static Alignment valueOf(String string) {
            return Enum.valueOf(Alignment.class, string);
        }
    }
}

