/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.editor.panel;

import com.dbeaver.ee.vqb.VQBUtils;
import com.dbeaver.ee.vqb.ui.editor.VQBEditorPresentation;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBPanelQueryElements;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.controls.CustomComboBoxCellEditor;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.editors.TextEditorUtils;
import org.jkiss.utils.CommonUtils;

class VQBPanelQuerySelectItems
extends VQBPanelQueryElements<SelectItem> {
    private static final Log log = Log.getLog(VQBPanelQuerySelectItems.class);

    protected VQBPanelQuerySelectItems(VQBEditorPresentation presentation) {
        super(presentation);
    }

    @Override
    protected void loadElements() {
        PlainSelect selectBody = this.getPlainSelect();
        if (selectBody != null) {
            this.elementViewer.setInput((Object)selectBody.getSelectItems());
        } else {
            this.elementViewer.setInput(new ArrayList(0));
        }
    }

    private void replaceSelectItem(SelectItem oldItem, SelectItem newItem) {
        PlainSelect selectBody = this.getPlainSelect();
        if (selectBody != null) {
            List selectItems = selectBody.getSelectItems();
            int itemIndex = selectItems.indexOf(oldItem);
            if (itemIndex >= 0) {
                selectItems.set(itemIndex, newItem);
            } else {
                log.error((Object)("Can't find old select item [" + oldItem + "]"));
            }
        }
    }

    @Override
    protected void fillColumns(ViewerColumnController<Object, SelectItem> columnsController) {
        columnsController.addColumn("#", "Select item position", 16384, true, true, selectItem -> {
            PlainSelect selectBody = this.getPlainSelect();
            if (selectBody != null) {
                return String.valueOf(selectBody.getSelectItems().indexOf(selectItem) + 1);
            }
            return null;
        }, null);
        VQBPanelQueryElements.ExpressionEditingSupport<SelectItem> expressionEditSupport = new VQBPanelQueryElements.ExpressionEditingSupport<SelectItem>((VQBPanelQueryElements)this){

            @Override
            protected CellEditor getCellEditor(Object element) {
                CustomComboBoxCellEditor cellEditor = new CustomComboBoxCellEditor((ColumnViewer)VQBPanelQuerySelectItems.this.elementViewer, (Composite)VQBPanelQuerySelectItems.this.elementViewer.getTree(), new String[0], 4);
                List<String> attrNames = VQBUtils.getAttributeNames(VQBPanelQuerySelectItems.this.presentation.getVQBEditor().getDiagram(), true);
                attrNames.add("*");
                cellEditor.setItems(attrNames.toArray(new String[attrNames.size()]));
                TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)VQBPanelQuerySelectItems.this.presentation.getSQLEditor().getSite(), (Control)cellEditor.getControl());
                return cellEditor;
            }

            @Override
            protected boolean setValue(SelectItem selectItem, String text) {
                if (text.equals("*")) {
                    VQBPanelQuerySelectItems.this.replaceSelectItem(selectItem, (SelectItem)new AllColumns());
                    return true;
                }
                if (text.endsWith(".*")) {
                    VQBPanelQuerySelectItems.this.replaceSelectItem(selectItem, (SelectItem)new AllTableColumns(new Table(text.substring(0, text.length() - 2))));
                    return true;
                }
                return super.setValue(selectItem, text);
            }

            @Override
            protected String convertExpressionToString(SelectItem selectItem) {
                if (selectItem instanceof SelectExpressionItem) {
                    return ((SelectExpressionItem)selectItem).getExpression().toString();
                }
                return super.convertExpressionToString(selectItem);
            }

            @Override
            protected boolean updateElementExpression(SelectItem parent, SelectItem selectItem, Expression expression) {
                SelectExpressionItem newItem = new SelectExpressionItem(expression);
                if (selectItem instanceof SelectExpressionItem) {
                    newItem.setAlias(((SelectExpressionItem)selectItem).getAlias());
                }
                VQBPanelQuerySelectItems.this.replaceSelectItem(selectItem, (SelectItem)newItem);
                return true;
            }
        };
        columnsController.addColumn("Column or Expression", "Expression", 16384, true, true, selectItem -> {
            if (selectItem instanceof SelectExpressionItem) {
                Expression expression = ((SelectExpressionItem)selectItem).getExpression();
                return expression == null ? null : expression.toString();
            }
            return selectItem.toString();
        }, (EditingSupport)expressionEditSupport);
        VQBPanelQueryElements.TextEditingSupport<SelectItem> aliasEditingSupport = new VQBPanelQueryElements.TextEditingSupport<SelectItem>((VQBPanelQueryElements)this){

            @Override
            protected String convertExpressionToString(SelectItem selectItem) {
                if (selectItem instanceof SelectExpressionItem) {
                    Alias alias = ((SelectExpressionItem)selectItem).getAlias();
                    return alias == null ? "" : alias.getName();
                }
                return "";
            }

            @Override
            protected void updateElementText(SelectItem selectItem, String text) {
                if (selectItem instanceof SelectExpressionItem) {
                    if (CommonUtils.isEmpty((String)text)) {
                        ((SelectExpressionItem)selectItem).setAlias(null);
                    } else {
                        ((SelectExpressionItem)selectItem).setAlias(new Alias(text));
                    }
                }
            }
        };
        columnsController.addColumn("Alias", "Select item alias", 16384, true, false, selectItem -> {
            Alias alias;
            if (selectItem instanceof SelectExpressionItem && (alias = ((SelectExpressionItem)selectItem).getAlias()) != null) {
                return alias.getName();
            }
            return null;
        }, (EditingSupport)aliasEditingSupport);
    }

    @Override
    protected DBIcon getDefaultIcon() {
        return DBIcon.TREE_COLUMN;
    }

    @Override
    protected void fillPanelContributions(IContributionManager contributionManager) {
        super.fillPanelContributions(contributionManager);
        contributionManager.add((IAction)new Action("Add Column/Expression", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ROW_ADD)){

            public void run() {
                PlainSelect plainSelect = VQBPanelQuerySelectItems.this.getPlainSelect();
                if (plainSelect != null) {
                    ArrayList<SelectExpressionItem> selectItems = plainSelect.getSelectItems();
                    if (selectItems == null) {
                        selectItems = new ArrayList<SelectExpressionItem>();
                        plainSelect.setSelectItems(selectItems);
                    }
                    SelectItem selectedItem = (SelectItem)VQBPanelQuerySelectItems.this.getSelectedElement();
                    SelectExpressionItem newElement = new SelectExpressionItem((Expression)new LongValue(1L));
                    if (selectedItem != null) {
                        selectItems.add(selectItems.indexOf(selectedItem) + 1, newElement);
                    } else {
                        selectItems.add(newElement);
                    }
                    VQBPanelQuerySelectItems.this.addNewElement(newElement, 1);
                }
            }
        });
        contributionManager.add((IAction)new VQBPanelQueryElements.DeleteActionAbstract(this){

            protected List<SelectItem> getElementsContainer() {
                PlainSelect plainSelect = VQBPanelQuerySelectItems.this.getPlainSelect();
                return plainSelect != null ? plainSelect.getSelectItems() : null;
            }
        });
        contributionManager.add((IContributionItem)new Separator());
        contributionManager.add((IAction)new Action("Move Up", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ARROW_UP)){

            public void run() {
                VQBPanelQuerySelectItems.this.moveElementTo(-1);
            }

            public boolean isEnabled() {
                PlainSelect plainSelect = VQBPanelQuerySelectItems.this.getPlainSelect();
                SelectItem selectedElement = (SelectItem)VQBPanelQuerySelectItems.this.getSelectedElement();
                return plainSelect != null && plainSelect.getSelectItems() != null && selectedElement != null && plainSelect.getSelectItems().indexOf(selectedElement) > 0;
            }
        });
        contributionManager.add((IAction)new Action("Move Down", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ARROW_DOWN)){

            public void run() {
                VQBPanelQuerySelectItems.this.moveElementTo(1);
            }

            public boolean isEnabled() {
                PlainSelect plainSelect = VQBPanelQuerySelectItems.this.getPlainSelect();
                SelectItem selectedElement = (SelectItem)VQBPanelQuerySelectItems.this.getSelectedElement();
                return plainSelect != null && plainSelect.getSelectItems() != null && selectedElement != null && plainSelect.getSelectItems().indexOf(selectedElement) < plainSelect.getSelectItems().size() - 1;
            }
        });
    }

    protected void moveElementTo(int shift) {
        PlainSelect plainSelect;
        List selectItems;
        SelectItem selectedElement = (SelectItem)this.getSelectedElement();
        if (selectedElement != null && (selectItems = (plainSelect = this.getPlainSelect()).getSelectItems()) != null) {
            int oldIndex = selectItems.indexOf(selectedElement);
            if (selectItems.remove(selectedElement)) {
                selectItems.add(oldIndex + shift, selectedElement);
                this.presentation.getQueryPanel().refreshActions();
                this.refreshDiagramAndStatement();
            }
        }
    }

    @Override
    protected boolean supportsElementsMove() {
        return true;
    }

    @Override
    protected void moveElementTo(SelectItem srcElement, SelectItem dstElement) {
        List selectItems = this.getPlainSelect().getSelectItems();
        if (selectItems != null) {
            selectItems.indexOf(srcElement);
            int newIndex = selectItems.indexOf(dstElement);
            if (selectItems.remove(srcElement)) {
                selectItems.add(newIndex, srcElement);
                this.presentation.getQueryPanel().refreshActions();
                this.refreshDiagramAndStatement();
            }
        }
    }
}

