/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.lm.validate;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.lm.LMException;
import org.jkiss.lm.LMLicense;
import org.jkiss.lm.LMProduct;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLBuilder;

public class PublicServiceClient {
    private static final Log log = Log.getLog(PublicServiceClient.class);
    public static final String PUBLIC_SERVICE_HOST = "dbeaver.com";
    public static final String PUBLIC_SERVICE_URL = "https://dbeaver.com/lmp/";
    private final CloseableHttpClient httpclient;

    public PublicServiceClient(String clientId) {
        this(clientId, 0, 0);
    }

    public PublicServiceClient(String clientId, int connectTimeout, int socketTimeout) {
        RequestConfig.Builder requestConfig = RequestConfig.custom();
        if (connectTimeout > 0) {
            requestConfig.setConnectTimeout(connectTimeout);
        }
        if (socketTimeout > 0) {
            requestConfig.setSocketTimeout(socketTimeout);
        }
        RequestConfig config = requestConfig.build();
        String osName = String.valueOf(CommonUtils.notEmpty((String)System.getProperty("os.name"))) + " " + CommonUtils.notEmpty((String)System.getProperty("os.arch"));
        ArrayList<BasicHeader> defHeaders = new ArrayList<BasicHeader>();
        if (clientId != null) {
            defHeaders.add(new BasicHeader("X-Referrer", clientId));
        }
        this.httpclient = HttpClientBuilder.create().setUserAgent(String.valueOf(GeneralUtils.getProductTitle()) + " [" + osName.trim() + "]").setDefaultHeaders(defHeaders).setDefaultRequestConfig(config).build();
    }

    private HttpGet makeGetRequest(String method) {
        HttpGet httpget = new HttpGet(PUBLIC_SERVICE_URL + method);
        return httpget;
    }

    private HttpPost makePostRequest(String method) {
        HttpPost httpget = new HttpPost(PUBLIC_SERVICE_URL + method);
        return httpget;
    }

    public String ping() throws LMException {
        try {
            HttpGet httpget = this.makeGetRequest("ping");
            Throwable throwable = null;
            Object var3_5 = null;
            try (CloseableHttpResponse response = this.httpclient.execute((HttpUriRequest)httpget);){
                return EntityUtils.toString((HttpEntity)response.getEntity());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            throw new LMException("Ping failed", e);
        }
    }

    public String checkCustomerEmail(LMProduct product, String email) throws LMException {
        try {
            HttpGet httpget = this.makeGetRequest("checkCustomer?product=" + product.getId() + "&version=" + product.getVersion() + "&email=" + email);
            Throwable throwable = null;
            Object var5_7 = null;
            try (CloseableHttpResponse response = this.httpclient.execute((HttpUriRequest)httpget);){
                return EntityUtils.toString((HttpEntity)response.getEntity());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            throw new LMException("Customer check failed", e);
        }
    }

    public String generateTrialLicense(LMProduct product, String email, String firstName, String lastName, String company) throws LMException {
        String xmlBody = this.generateLicenseRequest(product, email, firstName, lastName, company);
        try {
            HttpPost post = this.makePostRequest("generateTrialLicense");
            post.setHeader("Content-Type", "text/xml");
            post.setEntity((HttpEntity)new StringEntity(xmlBody));
            Throwable throwable = null;
            Object var9_11 = null;
            try (CloseableHttpResponse response = this.httpclient.execute((HttpUriRequest)post);){
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode >= 200 && statusCode < 300) {
                    if (response.getEntity() == null || response.getEntity().getContentLength() == 0L) {
                        throw new LMException("Internal error - empty license has been returned");
                    }
                    return EntityUtils.toString((HttpEntity)response.getEntity());
                }
                Header errorMessage = response.getLastHeader("ErrorMessage");
                if (errorMessage != null) {
                    throw new LMException(errorMessage.getValue());
                }
                throw new LMException("Bad server status (" + statusCode + "): " + response.getStatusLine().getReasonPhrase());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            if (e instanceof LMException) {
                throw (LMException)e;
            }
            throw new LMException("Error generating trial license", e);
        }
    }

    public String checkLicenseStatus(LMLicense license, LMProduct product) throws LMException {
        try {
            HttpGet httpget = this.makeGetRequest("checkLicense?product=" + product.getId() + "&version=" + product.getVersion() + "&license=" + license.getLicenseId());
            Throwable throwable = null;
            Object var5_8 = null;
            try (CloseableHttpResponse response = this.httpclient.execute((HttpUriRequest)httpget);){
                if (response.getStatusLine().getStatusCode() != 200) {
                    throw new IOException("Bad HTTP response: " + response.getStatusLine().getStatusCode());
                }
                return EntityUtils.toString((HttpEntity)response.getEntity());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.debug((Object)("Error checking license " + license.getLicenseId() + " status: " + e.getMessage()));
            return null;
        }
        catch (Throwable e) {
            throw new LMException("License check failed", e);
        }
    }

    private String generateLicenseRequest(LMProduct product, String email, String firstName, String lastName, String company) throws LMException {
        try {
            StringWriter sw = new StringWriter();
            XMLBuilder xml = new XMLBuilder((Writer)sw, GeneralUtils.UTF8_ENCODING);
            xml.setButify(true);
            Throwable throwable = null;
            Object var9_11 = null;
            try (XMLBuilder.Element e1 = xml.startElement("request");){
                xml.addAttribute("license", "trial");
                xml.addAttribute("productId", product.getId());
                xml.addAttribute("productVersion", product.getVersion());
                Throwable throwable2 = null;
                Object var12_16 = null;
                try (XMLBuilder.Element e2 = xml.startElement("customer");){
                    xml.addAttribute("email", email);
                    xml.addAttribute("firstName", firstName);
                    xml.addAttribute("lastName", lastName);
                    xml.addAttribute("company", company);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
            xml.flush();
            return sw.toString();
        }
        catch (IOException e) {
            throw new LMException("IO errot generating license request", (Throwable)e);
        }
    }
}

