/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.scmp.ui.wizard;

import com.dbeaver.ee.scmp.model.CMPException;
import com.dbeaver.ee.scmp.model.CMPOptions;
import com.dbeaver.ee.scmp.model.CMPQueryReportEngine;
import com.dbeaver.ee.scmp.model.CMPReportEngine;
import com.dbeaver.ee.scmp.model.CMPResult;
import com.dbeaver.ee.scmp.model.CMPResultChangeItem;
import com.dbeaver.ee.scmp.model.CMPResultQuery;
import com.dbeaver.ee.scmp.registry.SCMPEngineRegistry;
import com.dbeaver.ee.scmp.registry.SCMPReportEngineDescriptor;
import com.dbeaver.ee.scmp.ui.wizard.IDiffChangesRenderer;
import com.dbeaver.ee.scmp.ui.wizard.SchemaCompareWizard;
import com.dbeaver.ee.scmp.ui.wizard.SchemaMigration;
import com.dbeaver.ee.scmp.ui.wizard.diagram.DiffRendererDiagram;
import com.dbeaver.ee.scmp.ui.wizard.tree.DiffRendererTree;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.DataSourceContextProvider;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDataSource;
import org.jkiss.dbeaver.model.sql.format.SQLFormatUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceSQL;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomSashForm;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.StringEditorInput;
import org.jkiss.dbeaver.ui.editors.SubEditorSite;
import org.jkiss.dbeaver.ui.editors.json.JSONTextEditor;
import org.jkiss.dbeaver.ui.editors.xml.XMLEditor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

class SchemaComparePageDiff
extends ActiveWizardPage<SchemaCompareWizard>
implements DBPContextProvider {
    private File reportFile;
    private Object diffDetailsText;
    private UIServiceSQL detailsServiceSQL;
    private static RendererInfo[] AVAILABLE_RENDERERS = new RendererInfo[]{new RendererInfo("Changes tree", DiffRendererTree.class), new RendererInfo("Changes diagram", DiffRendererDiagram.class)};
    private static final Log log = Log.getLog(SchemaComparePageDiff.class);
    private Composite diffPanel;
    private Composite reportPanel;
    private CMPOptions options;
    private CMPResult diffResults;
    private RendererInfo selectedRenderer;
    private IDiffChangesRenderer changesRenderer;
    private SCMPReportEngineDescriptor selectedReportEngine;

    SchemaComparePageDiff(SchemaCompareWizard wizard) {
        super("Diff");
        this.setTitle("Preview results of " + (wizard.isMigrateWizard() ? "migration" : "compare"));
        this.setDescription("Here you can review, include or exclude changes in generated diff change sets");
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        Composite mainPanel = UIUtils.createComposite((Composite)composite, (int)2);
        mainPanel.setLayoutData((Object)new GridData(1808));
        mainPanel.setLayout((Layout)new FillLayout());
        CustomSashForm panelDivider = UIUtils.createPartDivider((IWorkbenchPart)((SchemaCompareWizard)this.getWizard()).getWorkbenchPart(), (Composite)mainPanel, (int)256);
        Composite diffGroup = UIUtils.createComposite((Composite)panelDivider, (int)3);
        final Combo diffTypeSelector = UIUtils.createLabelCombo((Composite)diffGroup, (String)"Diff type", (int)12);
        diffTypeSelector.setLayoutData((Object)new GridData(32));
        RendererInfo[] rendererInfoArray = AVAILABLE_RENDERERS;
        int n = AVAILABLE_RENDERERS.length;
        int n2 = 0;
        while (n2 < n) {
            RendererInfo rendererInfo = rendererInfoArray[n2];
            diffTypeSelector.add(rendererInfo.name);
            ++n2;
        }
        diffTypeSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SchemaComparePageDiff.this.selectedRenderer = AVAILABLE_RENDERERS[diffTypeSelector.getSelectionIndex()];
                SchemaComparePageDiff.this.showDiffResults();
            }
        });
        this.selectedRenderer = AVAILABLE_RENDERERS[0];
        diffTypeSelector.select(0);
        CustomSashForm detailsDivider = UIUtils.createPartDivider((IWorkbenchPart)((SchemaCompareWizard)this.getWizard()).getWorkbenchPart(), (Composite)diffGroup, (int)512);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        detailsDivider.setLayoutData((Object)gd);
        this.diffPanel = new Composite((Composite)detailsDivider, 0);
        this.diffPanel.setLayout((Layout)new FillLayout());
        Composite bottomPanel = UIUtils.createComposite((Composite)detailsDivider, (int)1);
        Composite diffDetailsPanel = new Composite(bottomPanel, 2048);
        diffDetailsPanel.setLayoutData((Object)new GridData(1808));
        diffDetailsPanel.setLayout((Layout)new FillLayout());
        this.detailsServiceSQL = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class);
        if (this.detailsServiceSQL != null) {
            try {
                this.diffDetailsText = this.detailsServiceSQL.createSQLPanel((Object)((SchemaCompareWizard)this.getWizard()).getWorkbenchPart().getSite(), (Object)diffDetailsPanel, (DBPContextProvider)this, "Change DDL", false, "");
            }
            catch (DBException e2) {
                DBWorkbench.getPlatformUI().showError("SQL report error", "Can't create SQL panel", (Throwable)e2);
            }
        }
        Composite controlPanel = new Composite(bottomPanel, 0);
        controlPanel.setLayoutData((Object)new GridData(768));
        controlPanel.setLayout((Layout)new GridLayout(3, true));
        UIUtils.createDialogButton((Composite)controlPanel, (String)"All", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SchemaComparePageDiff.this.changesRenderer.selectAllItems(true);
            }
        });
        UIUtils.createDialogButton((Composite)controlPanel, (String)"None", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SchemaComparePageDiff.this.changesRenderer.selectAllItems(false);
            }
        });
        UIUtils.createDialogButton((Composite)controlPanel, (String)"Refresh Report", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SchemaComparePageDiff.this.showDiffReport();
            }
        });
        detailsDivider.setWeights(new int[]{800, 200});
        final Composite reportGroup = UIUtils.createComposite((Composite)panelDivider, (int)3);
        final Combo reportTypeSelector = UIUtils.createLabelCombo((Composite)reportGroup, (String)"Report type", (int)12);
        reportTypeSelector.setLayoutData((Object)new GridData(32));
        final Label reportTypeDescLabel = new Label(reportGroup, 0);
        gd = new GridData(128);
        gd.grabExcessHorizontalSpace = true;
        reportTypeDescLabel.setLayoutData((Object)gd);
        for (SCMPReportEngineDescriptor engineDescriptor : SCMPEngineRegistry.getInstance().getReportEngines()) {
            reportTypeSelector.add(engineDescriptor.getLabel());
            if (this.selectedReportEngine != null) continue;
            this.selectedReportEngine = engineDescriptor;
        }
        if (this.selectedReportEngine != null) {
            reportTypeDescLabel.setText(CommonUtils.notEmpty((String)this.selectedReportEngine.getDescription()));
        }
        reportTypeSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SchemaComparePageDiff.this.selectedReportEngine = (SCMPReportEngineDescriptor)SCMPEngineRegistry.getInstance().getReportEngines().get(reportTypeSelector.getSelectionIndex());
                reportGroup.setRedraw(false);
                try {
                    reportTypeDescLabel.setText(CommonUtils.notEmpty((String)SchemaComparePageDiff.this.selectedReportEngine.getDescription()));
                    reportTypeDescLabel.getParent().layout(true, true);
                    SchemaComparePageDiff.this.showDiffReport();
                }
                finally {
                    reportGroup.setRedraw(true);
                }
            }
        });
        reportTypeSelector.select(0);
        this.reportPanel = UIUtils.createComposite((Composite)reportGroup, (int)1);
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        this.reportPanel.setLayoutData((Object)gd);
        this.reportPanel.addDisposeListener(e -> this.cleanOldReportFile());
        Composite controlPanel2 = new Composite(reportGroup, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        controlPanel2.setLayoutData((Object)gd);
        controlPanel2.setLayout((Layout)new GridLayout(4, true));
        UIUtils.createDialogButton((Composite)controlPanel2, (String)"Save", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File targetFile = DialogUtils.selectFileForSave((Shell)SchemaComparePageDiff.this.getShell(), (String)"Report file", (String[])new String[]{"*." + SchemaComparePageDiff.this.selectedReportEngine.getFileExtension()}, (String)("diff-report." + SchemaComparePageDiff.this.selectedReportEngine.getFileExtension()));
                if (targetFile != null) {
                    try {
                        Throwable throwable = null;
                        Object var4_6 = null;
                        try (FileInputStream is = new FileInputStream(SchemaComparePageDiff.this.reportFile);){
                            Throwable throwable2 = null;
                            Object var7_11 = null;
                            try (FileOutputStream os = new FileOutputStream(targetFile);){
                                IOUtils.fastCopy((InputStream)is, (OutputStream)os);
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable == null) {
                                throwable = throwable4;
                            } else if (throwable != throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e1) {
                        DBWorkbench.getPlatformUI().showError("Save error", "Error saving report to file", (Throwable)e1);
                    }
                }
            }
        });
        UIUtils.createDialogButton((Composite)controlPanel2, (String)"Copy", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String reportText = SchemaComparePageDiff.this.readReportFile();
                UIUtils.setClipboardContents((Display)SchemaComparePageDiff.this.getShell().getDisplay(), (Transfer)TextTransfer.getInstance(), (Object)reportText);
            }
        });
        UIUtils.createDialogButton((Composite)controlPanel2, (String)"Open in editor", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    File editorFile = SchemaComparePageDiff.this.createReportFile();
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (FileInputStream is = new FileInputStream(SchemaComparePageDiff.this.reportFile);){
                        Throwable throwable2 = null;
                        Object var7_11 = null;
                        try (FileOutputStream os = new FileOutputStream(editorFile);){
                            IOUtils.fastCopy((InputStream)is, (OutputStream)os);
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                    EditorUtils.setFileDataSource((File)editorFile, (DBPDataSourceContainer)SchemaComparePageDiff.this.options.getChangelogInput().getDataSourceContainer());
                    EditorUtils.openExternalFileEditor((File)editorFile, (IWorkbenchWindow)UIUtils.getActiveWorkbenchWindow());
                }
                catch (Exception e1) {
                    DBWorkbench.getPlatformUI().showError("Editor file error", "Error creating editor file", (Throwable)e1);
                }
            }
        });
        UIUtils.createDialogButton((Composite)controlPanel2, (String)"Migrate", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SchemaComparePageDiff.this.applyChangeSets();
            }
        });
        this.setControl((Control)composite);
        this.updatePageCompletion();
    }

    protected boolean determinePageCompletion() {
        return true;
    }

    public void populateResults(CMPOptions options, CMPResult cmpResult) {
        this.options = options;
        this.diffResults = cmpResult;
    }

    public void activatePage() {
        this.showDiffResults();
        this.showDiffReport();
    }

    private void showDiffResults() {
        UIUtils.disposeChildControls((Composite)this.diffPanel);
        try {
            this.changesRenderer = this.selectedRenderer.implClass.newInstance();
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("Renderer error", "Error creating changes renderer", (Throwable)e);
            return;
        }
        this.changesRenderer.addChangesListener(event -> this.updateDiffReport());
        this.changesRenderer.addSelectionListener((part, selection) -> this.updateDiffDetails(selection));
        this.changesRenderer.createControl(this.diffPanel);
        this.changesRenderer.populateChanges(this.options, this.diffResults);
        this.diffPanel.layout(true, true);
    }

    private void showDiffReport() {
        UIUtils.disposeChildControls((Composite)this.reportPanel);
        this.reportPanel.setRedraw(false);
        try {
            Composite viewerComposite = new Composite(this.reportPanel, 2048);
            viewerComposite.setLayoutData((Object)new GridData(1808));
            viewerComposite.setLayout((Layout)new FillLayout());
            this.generateDiffReport();
            String reportText = this.readReportFile();
            switch (this.selectedReportEngine.getType()) {
                case sql: {
                    UIServiceSQL uiServiceSQL = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class);
                    if (uiServiceSQL == null) break;
                    try {
                        uiServiceSQL.createSQLPanel((Object)((SchemaCompareWizard)this.getWizard()).getWorkbenchPart().getSite(), (Object)viewerComposite, (DBPContextProvider)new DataSourceContextProvider((DBSObject)this.options.getChangelogInput().getDataSourceContainer()), "Diff DDL", true, reportText);
                    }
                    catch (DBException e) {
                        DBWorkbench.getPlatformUI().showError("SQL report error", "Can't create SQL panel", (Throwable)e);
                    }
                    break;
                }
                case xml: {
                    XMLEditor xmlEditor = new XMLEditor();
                    try {
                        xmlEditor.init((IEditorSite)new SubEditorSite(((SchemaCompareWizard)this.getWizard()).getWorkbenchPart().getSite()), (IEditorInput)new StringEditorInput("XML", (CharSequence)reportText, true, GeneralUtils.DEFAULT_ENCODING));
                        xmlEditor.createPartControl(viewerComposite);
                    }
                    catch (PartInitException e) {
                        DBWorkbench.getPlatformUI().showError("XML report error", "Can't create XML panel", (Throwable)e);
                    }
                    break;
                }
                case json: {
                    JSONTextEditor jsonEditor = new JSONTextEditor();
                    try {
                        jsonEditor.init((IEditorSite)new SubEditorSite(((SchemaCompareWizard)this.getWizard()).getWorkbenchPart().getSite()), (IEditorInput)new StringEditorInput("JSON", (CharSequence)reportText, true, GeneralUtils.DEFAULT_ENCODING));
                        jsonEditor.createPartControl(viewerComposite);
                    }
                    catch (PartInitException e) {
                        DBWorkbench.getPlatformUI().showError("JSON report error", "Can't create JSON panel", (Throwable)e);
                    }
                    break;
                }
                default: {
                    Text text = new Text(viewerComposite, 2824);
                    text.setText(reportText);
                }
            }
            this.reportPanel.layout(true, true);
        }
        finally {
            this.reportPanel.setRedraw(true);
        }
    }

    private void generateDiffReport() {
        try {
            this.getContainer().run(true, true, monitor -> {
                try {
                    this.generateDiffReport((DBRProgressMonitor)new DefaultProgressMonitor(monitor));
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            });
            this.setErrorMessage(null);
        }
        catch (InvocationTargetException e) {
            this.setErrorMessage(e.getTargetException().getMessage());
            DBWorkbench.getPlatformUI().showError("Report error", "Error generating " + this.selectedReportEngine.getLabel() + " report", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
        this.getContainer().updateMessage();
    }

    private void generateDiffReport(DBRProgressMonitor monitor) throws DBException, IOException {
        monitor.beginTask("Generate diff report", 5);
        monitor.subTask("Prepare report file");
        CMPReportEngine engine = this.selectedReportEngine.createEngine();
        this.cleanOldReportFile();
        this.reportFile = this.createReportFile();
        monitor.subTask("Generate report");
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileOutputStream os = new FileOutputStream(this.reportFile);){
            engine.generateDiffReport(monitor, this.diffResults, (OutputStream)os);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        monitor.done();
    }

    private File createReportFile() throws IOException {
        File tempFolder = DBWorkbench.getPlatform().getTempFolder((DBRProgressMonitor)new VoidProgressMonitor(), "scmp-diff-reports");
        return new File(tempFolder, "diff-report-" + this.selectedReportEngine.getId() + "-" + new SimpleDateFormat("yyyyMMddHHmmss").format(System.currentTimeMillis()) + "." + this.selectedReportEngine.getFileExtension());
    }

    private String readReportFile() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileReader reportReader = new FileReader(this.reportFile);){
                return IOUtils.readToString((Reader)reportReader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            DBWorkbench.getPlatformUI().showError("Report IO error", "Error reading report file", (Throwable)e);
            return e.getMessage();
        }
    }

    private void cleanOldReportFile() {
        if (this.reportFile != null && !this.reportFile.delete()) {
            log.warn((Object)("Can't delete old report " + this.reportFile.getAbsolutePath()));
        }
    }

    private void updateDiffReport() {
    }

    private void updateDiffDetails(ISelection selection) {
        if (this.detailsServiceSQL == null) {
            return;
        }
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            StringBuilder details = new StringBuilder();
            boolean lastLineFeed = true;
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                String changeDetails;
                Object element = objectArray[n2];
                if (element instanceof CMPResultChangeItem && (changeDetails = ((CMPResultChangeItem)element).getChangeDetails()) != null) {
                    if (!lastLineFeed) {
                        details.append(GeneralUtils.getDefaultLineSeparator());
                    }
                    details.append(changeDetails);
                    lastLineFeed = changeDetails.endsWith("\n");
                }
                ++n2;
            }
            String sqlText = details.toString();
            DBCExecutionContext executionContext = this.getExecutionContext();
            if (executionContext != null && executionContext.getDataSource() instanceof SQLDataSource) {
                sqlText = SQLFormatUtils.formatSQL((SQLDataSource)((SQLDataSource)executionContext.getDataSource()), (String)sqlText);
            }
            this.detailsServiceSQL.setSQLPanelText(this.diffDetailsText, sqlText);
        } else {
            this.detailsServiceSQL.setSQLPanelText(this.diffDetailsText, "");
        }
    }

    @Nullable
    public DBCExecutionContext getExecutionContext() {
        if (this.options == null) {
            return null;
        }
        return DBUtils.getDefaultContext((DBSObject)this.options.getChangelogInput().getDataSourceContainer().getDataSource(), (boolean)false);
    }

    private void applyChangeSets() {
        CMPReportEngine ddlEngine;
        if (!UIUtils.confirmAction((Shell)this.getShell(), (String)"Perform schema migration", (String)"Target schema may be corrupted without possibility to revert any changes.\nAre you sure you want to proceed with schema migration?")) {
            return;
        }
        if (!UIUtils.confirmAction((Shell)this.getShell(), (String)"Perform schema migration", (String)"Are you absolutely sure?", (int)8)) {
            return;
        }
        SCMPReportEngineDescriptor ddlReportEngine = SCMPEngineRegistry.getInstance().getReportEngine("ddl");
        if (ddlReportEngine == null) {
            DBWorkbench.getPlatformUI().showError("No engine", "DDL report engine not found.");
            return;
        }
        try {
            ddlEngine = ddlReportEngine.createEngine();
        }
        catch (DBException dBException) {
            DBWorkbench.getPlatformUI().showError("Error creating engine", "Can't create DDL engine.");
            return;
        }
        if (ddlEngine instanceof CMPQueryReportEngine) {
            try {
                ((SchemaCompareWizard)this.getWizard()).getContainer().run(true, true, m -> {
                    try {
                        DefaultProgressMonitor monitor = new DefaultProgressMonitor(m);
                        CMPResultQuery[] resultQueries = ((CMPQueryReportEngine)ddlEngine).generateDiffQueries((DBRProgressMonitor)monitor, this.diffResults);
                        this.performMigration((DBRProgressMonitor)monitor, this.options, resultQueries);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                });
            }
            catch (InvocationTargetException e) {
                DBWorkbench.getPlatformUI().showError("Error applying changes", "Error processing schema migration.", e.getTargetException());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            DBWorkbench.getPlatformUI().showError("SQL queries generation error", "SQL queries generation not supported.");
        }
    }

    private void performMigration(DBRProgressMonitor monitor, CMPOptions options, CMPResultQuery[] resultQueries) throws CMPException {
        new SchemaMigration(options, resultQueries).runMigration(monitor);
    }

    private static class RendererInfo {
        String name;
        Class<? extends IDiffChangesRenderer> implClass;

        public RendererInfo(String name, Class<? extends IDiffChangesRenderer> implClass) {
            this.name = name;
            this.implClass = implClass;
        }
    }
}

