/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.scmp.ui.wizard.diagram;

import com.dbeaver.ee.scmp.model.CMPResultChangeItem;
import com.dbeaver.ee.scmp.model.CMPResultChangeType;
import com.dbeaver.ee.scmp.ui.wizard.diagram.DiffEditPartFactory;
import com.dbeaver.ee.scmp.ui.wizard.diagram.DiffEntityDetails;
import java.util.List;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.swt.graphics.Color;
import org.jkiss.dbeaver.ext.erd.model.ERDDecoratorDefault;
import org.jkiss.dbeaver.ext.erd.model.ERDEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class DiffDiagramDecorator
extends ERDDecoratorDefault {
    public boolean showCheckboxes() {
        return false;
    }

    public void fillPalette(PaletteRoot paletteRoot, boolean readOnly) {
        PaletteDrawer toolsDrawer = this.createToolsDrawer(paletteRoot);
        SelectionToolEntry selectionTool = new SelectionToolEntry();
        toolsDrawer.add((PaletteEntry)selectionTool);
        paletteRoot.setDefaultEntry((ToolEntry)selectionTool);
    }

    protected boolean isAttributeVisible(ERDEntity erdEntity, DBSEntityAttribute attribute) {
        DiffEntityDetails changeItem = (DiffEntityDetails)erdEntity.getUserData();
        switch (changeItem.getChangeType()) {
            case CREATE: 
            case RENAME: 
            case DROP: {
                return false;
            }
        }
        return DiffDiagramDecorator.getAttributeItem(changeItem, attribute) != null;
    }

    public EditPartFactory createPartFactory() {
        return new DiffEditPartFactory();
    }

    public static CMPResultChangeItem getAttributeItem(DiffEntityDetails entityDetails, DBSEntityAttribute attribute) {
        List<CMPResultChangeItem> attrItems = entityDetails.getNestedItems();
        if (attrItems != null) {
            for (CMPResultChangeItem attrItem : attrItems) {
                if (!CommonUtils.equalObjects((Object)attrItem.getInnerName(), (Object)attribute.getName())) continue;
                return attrItem;
            }
        }
        return null;
    }

    public static Color getChangeColor(CMPResultChangeType changeType) {
        switch (changeType) {
            case CREATE: {
                return UIUtils.getColorRegistry().get("com.dbeaver.scmp.diff.color.create");
            }
            case DROP: {
                return UIUtils.getColorRegistry().get("com.dbeaver.scmp.diff.color.delete");
            }
        }
        return UIUtils.getColorRegistry().get("com.dbeaver.scmp.diff.color.update");
    }
}

