/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.scmp.ui.wizard;

import com.dbeaver.ee.scmp.model.CMPException;
import com.dbeaver.ee.scmp.model.CMPInput;
import com.dbeaver.ee.scmp.model.CMPOptions;
import com.dbeaver.ee.scmp.registry.SCMPDiffEngineDescriptor;
import com.dbeaver.ee.scmp.registry.SCMPEngineRegistry;
import com.dbeaver.ee.scmp.ui.wizard.SchemaCompareWizard;
import com.dbeaver.ee.scmp.ui.wizard.SchemaMappingDialog;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableParametrized;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomSashForm;
import org.jkiss.dbeaver.ui.controls.SelectDataSourceCombo;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.navigator.INavigatorFilter;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.utils.CommonUtils;

class SchemaComparePageInput
extends ActiveWizardPage<SchemaCompareWizard> {
    private static final Log log = Log.getLog(SchemaComparePageInput.class);
    private DatabaseNavigatorTree sourceTree;
    private DatabaseNavigatorTree targetTree;

    SchemaComparePageInput(SchemaCompareWizard wizard) {
        super("Input objects");
        this.setTitle(wizard.getOptions().getTargetInput() == null ? "Specify objects for changelog" : "Specify input objects for schema " + (wizard.isMigrateWizard() ? "migration" : "compare"));
        String description = "Specify input objects for schema " + (wizard.isMigrateWizard() ? "migration" : "compare");
        description = String.valueOf(description) + ". Number of source schemas must be the same as number of target schemas.\nSelecting individual table(s) in source schema will compare/migrate only these objects.";
        this.setDescription(description);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        boolean doDiff = ((SchemaCompareWizard)this.getWizard()).getTargetInput() != null;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        Composite sourceTargetPanel = UIUtils.createComposite((Composite)composite, (int)(doDiff ? 2 : 1));
        sourceTargetPanel.setLayoutData((Object)new GridData(1808));
        sourceTargetPanel.setLayout((Layout)new FillLayout());
        CustomSashForm panelDivider = UIUtils.createPartDivider((IWorkbenchPart)((SchemaCompareWizard)this.getWizard()).getWorkbenchPart(), (Composite)sourceTargetPanel, (int)256);
        this.sourceTree = this.createObjectSelectorPanel((Composite)panelDivider, "Source", ((SchemaCompareWizard)this.getWizard()).getSourceInput(), true);
        if (doDiff) {
            this.targetTree = this.createObjectSelectorPanel((Composite)panelDivider, "Target", ((SchemaCompareWizard)this.getWizard()).getTargetInput(), false);
        }
        if (doDiff) {
            Composite settingsPanel = UIUtils.createComposite((Composite)composite, (int)3);
            ((GridLayout)settingsPanel.getLayout()).horizontalSpacing = 20;
            UIUtils.createControlLabel((Composite)settingsPanel, (String)"Settings", (int)3);
            Composite optionsGroup = UIUtils.createComposite((Composite)settingsPanel, (int)3);
            final CMPOptions cmpOptions = ((SchemaCompareWizard)this.getWizard()).getOptions();
            UIUtils.createCheckbox((Composite)optionsGroup, (String)"Create missing objects", (String)"Create missing objects in target database", (boolean)cmpOptions.isDoCreate(), (int)1).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    cmpOptions.setDoCreate(((Button)e.widget).getSelection());
                }
            });
            UIUtils.createCheckbox((Composite)optionsGroup, (String)"Alter existing objects", (String)"Alter existing objects in target database", (boolean)cmpOptions.isDoChange(), (int)1).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    cmpOptions.setDoChange(((Button)e.widget).getSelection());
                }
            });
            UIUtils.createCheckbox((Composite)optionsGroup, (String)"Drop unexpected objects", (String)"Drop unexpected objects in target database", (boolean)cmpOptions.isDoDrop(), (int)1).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    cmpOptions.setDoDrop(((Button)e.widget).getSelection());
                }
            });
            Composite buttonsGroup = UIUtils.createComposite((Composite)settingsPanel, (int)1);
            buttonsGroup.setLayoutData((Object)new GridData(2));
            UIUtils.createDialogButton((Composite)buttonsGroup, (String)"Schema mapping ...", (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SchemaComparePageInput.this.showSchemaMappings();
                }
            });
            Composite advancedGroup = UIUtils.createComposite((Composite)settingsPanel, (int)2);
            advancedGroup.setLayoutData((Object)new GridData(2));
        }
        this.setControl((Control)composite);
    }

    private void showSchemaMappings() {
        SchemaMappingDialog dialog = new SchemaMappingDialog(this.getShell(), ((SchemaCompareWizard)this.getWizard()).getOptions());
        dialog.open();
    }

    private void createEngineSelector(Composite settingsGroup, final CMPOptions cmpOptions) {
        final Combo engineCombo = UIUtils.createLabelCombo((Composite)settingsGroup, (String)"Diff Engine", (String)"Diff engine", (int)12);
        engineCombo.setLayoutData((Object)new GridData(32));
        for (SCMPDiffEngineDescriptor diffEngine : SCMPEngineRegistry.getInstance().getDiffEngines()) {
            engineCombo.add(diffEngine.getLabel());
        }
        if (!CommonUtils.isEmpty((String)cmpOptions.getDiffEngineId())) {
            engineCombo.setText(cmpOptions.getDiffEngineId());
        }
        if (engineCombo.getSelectionIndex() < 0) {
            engineCombo.select(0);
        }
        engineCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                cmpOptions.setDiffEngineId(((SCMPDiffEngineDescriptor)SCMPEngineRegistry.getInstance().getDiffEngines().get(engineCombo.getSelectionIndex())).getId());
            }
        });
    }

    private DatabaseNavigatorTree createObjectSelectorPanel(Composite parent, String panelTitle, CMPInput input, boolean showSchemaObjects) {
        Composite group = UIUtils.createComposite((Composite)parent, (int)1);
        Composite dsPanel = UIUtils.createComposite((Composite)group, (int)2);
        dsPanel.setLayoutData((Object)new GridData(768));
        UIUtils.createControlLabel((Composite)dsPanel, (String)panelTitle);
        SelectDataSourceCombo dsSelectCombo = new SelectDataSourceCombo(dsPanel){

            protected DBPProject getActiveProject() {
                return ((SchemaCompareWizard)SchemaComparePageInput.this.getWizard()).getProject();
            }
        };
        GridData gd = new GridData(768);
        gd.widthHint = 200;
        dsSelectCombo.setLayoutData((Object)gd);
        dsSelectCombo.addProjectDataSources();
        ObjectNavigatorFilter filter = new ObjectNavigatorFilter(showSchemaObjects);
        DatabaseNavigatorTree dataSourceTree = new DatabaseNavigatorTree(group, null, 2084, true, (INavigatorFilter)filter);
        gd = new GridData(1808);
        gd.minimumHeight = 100;
        gd.minimumWidth = 200;
        dataSourceTree.setLayoutData((Object)gd);
        DataSourceSelectListener dsSelectListener = new DataSourceSelectListener(dataSourceTree, input);
        dsSelectCombo.addSelectionListener((DBRRunnableParametrized)dsSelectListener);
        dsSelectCombo.select((Object)input.getDataSourceContainer());
        dsSelectListener.loadObjects(input.getDataSourceContainer());
        CheckboxTreeViewer treeViewer = (CheckboxTreeViewer)dataSourceTree.getViewer();
        treeViewer.addCheckStateListener((ICheckStateListener)new ObjectsStateListener(treeViewer, input));
        List inputObjects = input.getInputObjects();
        if (!CommonUtils.isEmpty((Collection)inputObjects)) {
            treeViewer.getControl().setRedraw(false);
            try {
                Iterator iterator = inputObjects.iterator();
                while (iterator.hasNext()) {
                    DBSObject object = (DBSObject)iterator.next();
                    DBNDatabaseNode objectNode = DBNUtils.getNodeByObject((DBRProgressMonitor)new VoidProgressMonitor(), (DBSObject)object, (boolean)false);
                    if (objectNode != null && this.isSelectableNode(objectNode)) {
                        if (object instanceof DBSObjectContainer) {
                            treeViewer.setGrayChecked((Object)objectNode, true);
                        } else {
                            treeViewer.setChecked((Object)objectNode, true);
                        }
                        treeViewer.reveal((Object)objectNode);
                        continue;
                    }
                    iterator.remove();
                }
            }
            finally {
                treeViewer.getControl().setRedraw(true);
            }
        }
        return dataSourceTree;
    }

    private boolean isSelectableNode(DBNDatabaseNode node) {
        boolean cfr_ignored_0 = node instanceof DBNDatabaseFolder;
        if (node instanceof DBNDatabaseFolder) {
            Class folderChildren = ((DBNDatabaseFolder)node).getChildrenClass();
            return folderChildren != null && DBSEntity.class.isAssignableFrom(folderChildren);
        }
        DBSObject object = node.getObject();
        if (object instanceof DBSEntity) {
            return true;
        }
        if (object instanceof DBSObjectContainer) {
            try {
                Class childType = ((DBSObjectContainer)object).getChildType((DBRProgressMonitor)new VoidProgressMonitor());
                return childType != null && DBSEntity.class.isAssignableFrom(childType);
            }
            catch (DBException e) {
                log.debug((Object)e);
                return false;
            }
        }
        return false;
    }

    private void checkInputObject(List<DBSObject> inputObjects, DBSObject object) throws CMPException {
        DBSInstance newInstance = DBUtils.getObjectOwnerInstance((DBSObject)object);
        if (!(newInstance instanceof JDBCRemoteInstance)) {
            throw new CMPException("Only JDBC connections can be compared");
        }
        if (inputObjects.isEmpty()) {
            return;
        }
        DBSInstance curInstance = DBUtils.getObjectOwnerInstance((DBSObject)inputObjects.get(0));
        if (curInstance != newInstance) {
            throw new CMPException("You can't select objects which belong to different physical connections (" + curInstance.getName() + ", " + newInstance.getName() + ")");
        }
    }

    public void activatePage() {
        this.updatePageCompletion();
    }

    public void deactivatePage() {
    }

    protected boolean determinePageCompletion() {
        boolean doDiff;
        if (!((SchemaCompareWizard)this.getWizard()).getSourceInput().isValid()) {
            this.setErrorMessage("You must specify at least one input object");
            return false;
        }
        boolean bl = doDiff = ((SchemaCompareWizard)this.getWizard()).getTargetInput() != null;
        if (doDiff && !((SchemaCompareWizard)this.getWizard()).getTargetInput().isValid()) {
            this.setErrorMessage("You must specify at least one target schema");
            return false;
        }
        if (((SchemaCompareWizard)this.getWizard()).isSrcSameAsTarget()) {
            this.setErrorMessage("Source and target schema(s) must be different");
            return false;
        }
        if (!((SchemaCompareWizard)this.getWizard()).isValidMapping()) {
            this.setErrorMessage("Number of input schemas don't match target schemas");
            return false;
        }
        this.setErrorMessage(null);
        if (doDiff) {
            ((SchemaCompareWizard)this.getWizard()).getOptions().refreshSchemaMappings(false);
        }
        return true;
    }

    private class DataSourceSelectListener
    implements DBRRunnableParametrized<DBPDataSourceContainer> {
        private final DatabaseNavigatorTree dataSourceTree;
        private final CMPInput input;

        DataSourceSelectListener(DatabaseNavigatorTree dataSourceTree, CMPInput input) {
            this.dataSourceTree = dataSourceTree;
            this.input = input;
        }

        public void run(DBPDataSourceContainer selectedDataSource) {
            this.input.setInputObjects(new ArrayList());
            this.input.setDataSourceContainer(selectedDataSource);
            this.loadObjects(selectedDataSource);
        }

        void loadObjects(DBPDataSourceContainer selectedDataSource) {
            DBNModel model = DBWorkbench.getPlatform().getNavigatorModel();
            DBNDatabaseNode dsNode = selectedDataSource == null ? null : model.getNodeByObject((DBSObject)selectedDataSource);
            this.dataSourceTree.setInput((DBNNode)dsNode);
            this.dataSourceTree.getViewer().expandToLevel(2);
            TreeItem topItem = this.dataSourceTree.getViewer().getTree().getTopItem();
            if (topItem != null && topItem.getItemCount() == 1) {
                this.dataSourceTree.getViewer().expandToLevel(1);
            }
            SchemaComparePageInput.this.updatePageCompletion();
        }
    }

    private static class ObjectNavigatorFilter
    implements INavigatorFilter {
        private final boolean showSchemaObjects;

        public ObjectNavigatorFilter(boolean showSchemaObjects) {
            this.showSchemaObjects = showSchemaObjects;
        }

        public boolean filterFolders() {
            return true;
        }

        public boolean isLeafObject(Object object) {
            if (object instanceof DBNDatabaseNode) {
                DBSObject dbObject = ((DBNDatabaseNode)object).getObject();
                if (!this.showSchemaObjects) {
                    if (dbObject instanceof DBSSchema) {
                        return true;
                    }
                    if (dbObject instanceof DBSCatalog) {
                        try {
                            Class childType = ((DBSCatalog)dbObject).getChildType((DBRProgressMonitor)new VoidProgressMonitor());
                            if (!DBSSchema.class.isAssignableFrom(childType)) {
                                return true;
                            }
                        }
                        catch (DBException e) {
                            log.debug((Object)e);
                        }
                    }
                }
                if (dbObject instanceof DBSEntityAttribute) {
                    return true;
                }
            }
            return false;
        }

        public boolean select(Object element) {
            DBSObject object;
            if (element instanceof DBNDatabaseFolder) {
                Class folderChildren = ((DBNDatabaseFolder)element).getChildrenClass();
                if (folderChildren == null) {
                    return false;
                }
                if (!this.isGoodClass(folderChildren)) {
                    return false;
                }
            } else if (element instanceof DBNDatabaseNode && !this.isGoodClass((object = ((DBNDatabaseNode)element).getObject()).getClass())) {
                return false;
            }
            return true;
        }

        private boolean isGoodClass(Class<? extends DBSObject> folderChildren) {
            if (!this.showSchemaObjects) {
                return DBPDataSourceContainer.class.isAssignableFrom(folderChildren) || DBSObjectContainer.class.isAssignableFrom(folderChildren);
            }
            return DBPDataSourceContainer.class.isAssignableFrom(folderChildren) || DBSEntity.class.isAssignableFrom(folderChildren) || DBSObjectContainer.class.isAssignableFrom(folderChildren);
        }
    }

    private class ObjectsStateListener
    implements ICheckStateListener {
        private final CheckboxTreeViewer treeViewer;
        private final CMPInput input;

        public ObjectsStateListener(CheckboxTreeViewer treeViewer, CMPInput input) {
            this.treeViewer = treeViewer;
            this.input = input;
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            boolean isFolder;
            Object element = event.getElement();
            if (!(element instanceof DBNDatabaseNode)) {
                this.treeViewer.setGrayed(element, false);
                this.treeViewer.setChecked(element, false);
                return;
            }
            if (!SchemaComparePageInput.this.isSelectableNode((DBNDatabaseNode)element)) {
                this.treeViewer.setGrayed(element, false);
                this.treeViewer.setChecked(element, false);
                UIUtils.showMessageBox((Shell)SchemaComparePageInput.this.getShell(), (String)"Wrong node", (String)("You can't select item '" + element + "' (" + ((DBNDatabaseNode)element).getNodeType() + "). Only tables or table containers are allowed."), (int)8);
                return;
            }
            boolean bl = isFolder = element instanceof DBNDatabaseFolder || ((DBNDatabaseNode)element).getObject() instanceof DBSObjectContainer;
            if (event.getChecked()) {
                this.treeViewer.setGrayed(element, isFolder);
            }
            List inputObjects = this.input.getInputObjects();
            if (element instanceof DBNDatabaseFolder) {
                this.toggleFolderObjects((DBNDatabaseFolder)element, event.getChecked());
            } else {
                DBSObject object = ((DBNDatabaseNode)element).getObject();
                if (event.getChecked()) {
                    if (!inputObjects.contains(object)) {
                        try {
                            SchemaComparePageInput.this.checkInputObject(this.input.getInputObjects(), object);
                            this.input.getInputObjects().add(object);
                        }
                        catch (Exception e) {
                            this.treeViewer.setChecked(element, false);
                            DBWorkbench.getPlatformUI().showError("Wrong object", "You can't add object [" + object.getName() + "]", (Throwable)e);
                        }
                    }
                } else {
                    this.input.getInputObjects().remove(object);
                }
            }
            SchemaComparePageInput.this.updatePageCompletion();
        }

        private void toggleFolderObjects(DBNDatabaseFolder folder, boolean checked) {
            try {
                SchemaComparePageInput.this.getContainer().run(false, true, monitor -> {
                    try {
                        DBNDatabaseNode[] children = folder.getChildren((DBRProgressMonitor)new DefaultProgressMonitor(monitor));
                        if (children != null) {
                            List inputObjects = this.input.getInputObjects();
                            DBNDatabaseNode[] dBNDatabaseNodeArray = children;
                            int n = children.length;
                            int n2 = 0;
                            while (n2 < n) {
                                DBNDatabaseNode child = dBNDatabaseNodeArray[n2];
                                DBSObject object = child.getObject();
                                SchemaComparePageInput.this.checkInputObject(this.input.getInputObjects(), object);
                                if (checked) {
                                    inputObjects.add(object);
                                } else {
                                    inputObjects.remove(object);
                                }
                                ++n2;
                            }
                            UIUtils.asyncExec(() -> {
                                DBNDatabaseNode[] dBNDatabaseNodeArray2 = children;
                                int n = children.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    DBNDatabaseNode child = dBNDatabaseNodeArray2[n2];
                                    this.treeViewer.setChecked((Object)child, checked);
                                    ++n2;
                                }
                            });
                        }
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                });
            }
            catch (InvocationTargetException e) {
                log.error((Object)e.getTargetException());
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

