/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.scmp.impl.liquibase.report;

import com.dbeaver.ee.scmp.impl.liquibase.LBResultChangeSet;
import com.dbeaver.ee.scmp.impl.liquibase.report.LBReportEngineAbstract;
import com.dbeaver.ee.scmp.model.CMPException;
import com.dbeaver.ee.scmp.model.CMPResult;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import liquibase.changelog.ChangeSet;
import liquibase.serializer.ChangeLogSerializer;
import liquibase.serializer.ChangeLogSerializerFactory;
import liquibase.serializer.LiquibaseSerializable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class LBReportEnginePlainText
extends LBReportEngineAbstract {
    private static final Log log = Log.getLog(LBReportEnginePlainText.class);

    @Override
    public void generateDiffReport(DBRProgressMonitor monitor, CMPResult result, OutputStream stream) throws IOException, CMPException {
        LBResultChangeSet changeSet = (LBResultChangeSet)result.getChangeSet();
        List<ChangeSet> lbChangeSets = changeSet.getSourceDiff();
        OutputStreamWriter writer = new OutputStreamWriter(stream, GeneralUtils.getDefaultFileEncoding());
        ChangeLogSerializer serializer = ChangeLogSerializerFactory.getInstance().getSerializer("txt");
        if (serializer == null) {
            throw new CMPException("Plaintext log serializer not found");
        }
        for (ChangeSet cs : lbChangeSets) {
            String csString = serializer.serialize((LiquibaseSerializable)cs, true);
            writer.write(csString);
            writer.write("\n");
        }
        ((Writer)writer).flush();
    }
}

