/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.net;

import com.github.markusbernhardt.proxy.ProxySearch;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.runtime.net.GlobalProxySelector;

public class DynamicProxySelector
extends GlobalProxySelector {
    private static final Log log = Log.getLog(DynamicProxySelector.class);
    private boolean isSearching = false;

    public DynamicProxySelector(ProxySelector parent) {
        super(parent);
    }

    public List<Proxy> select(URI uri) {
        if (!this.isSearching) {
            this.isSearching = true;
            try {
                DBPDataSourceContainer activeContext = this.getActiveDataSourceContainer(uri);
                if (activeContext != null) {
                    DBWHandlerConfiguration proxyConfig = activeContext.getActualConnectionConfiguration().getHandler("dynamic_proxy");
                    if (proxyConfig != null && proxyConfig.isEnabled() && proxyConfig.getBooleanProperty("pac_enabled")) {
                        ProxySearch proxySearch = this.getProxySearcher(uri, proxyConfig);
                        ProxySelector polySelector = proxySearch.getProxySelector();
                        if (polySelector != null) {
                            log.debug((Object)"Detecting dynamic proxy settings");
                            List<Proxy> proxies = polySelector.select(uri);
                            for (Proxy proxy : proxies) {
                                log.debug((Object)("Poxy: " + proxy));
                            }
                            List<Proxy> list = proxies;
                            return list;
                        }
                        List proxies = super.getProxiesForDataSource(uri, activeContext);
                        if (proxies != null) {
                            List list = proxies;
                            return list;
                        }
                    }
                    List<Proxy> list = this.getParent().select(uri);
                    return list;
                }
            }
            catch (Throwable e) {
                log.debug((Object)"Error selecting dynamic proxy", e);
            }
            finally {
                this.isSearching = false;
            }
        }
        return super.select(uri);
    }

    @NotNull
    private ProxySearch getProxySearcher(URI uri, DBWHandlerConfiguration proxyConfig) {
        ProxySearch proxySearch = new ProxySearch();
        if (proxyConfig.getBooleanProperty("pac_strategy_os")) {
            proxySearch.addStrategy(ProxySearch.Strategy.OS_DEFAULT);
        }
        if (proxyConfig.getBooleanProperty("pac_strategy_browser")) {
            proxySearch.addStrategy(ProxySearch.Strategy.BROWSER);
        }
        if (proxyConfig.getBooleanProperty("pac_strategy_env")) {
            proxySearch.addStrategy(ProxySearch.Strategy.ENV_VAR);
        }
        proxySearch.addStrategy(ProxySearch.Strategy.JAVA);
        return proxySearch;
    }
}

