/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.redis.edit;

import com.dbeaver.ee.redis.RedisUtils;
import com.dbeaver.ee.redis.exec.RedisSession;
import com.dbeaver.ee.redis.model.RedisDatabase;
import com.dbeaver.ee.redis.model.RedisKey;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.DirectDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import redis.clients.jedis.commands.JedisClusterCommands;
import redis.clients.jedis.commands.JedisCommands;

public class RedisKeyManager
extends SQLObjectEditor<RedisKey, RedisDatabase> {
    public long getMakerOptions(DBPDataSource dataSource) {
        return 1L;
    }

    public boolean canCreateObject(Object container) {
        return false;
    }

    public boolean canDeleteObject(RedisKey object) {
        return true;
    }

    public DBSObjectCache<? extends DBSObject, RedisKey> getObjectsCache(RedisKey object) {
        return null;
    }

    protected RedisKey createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        return null;
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, final SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new DirectDatabasePersistAction("Delete key"){

            public String getScript() {
                return "DEL " + ((RedisKey)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL);
            }

            public void afterExecute(DBCSession session, Throwable error) {
                RedisKey key = (RedisKey)command.getObject();
                RedisSession redisSession = (RedisSession)session;
                RedisUtils.selectCurDatabase(redisSession, key.getDatabase());
                if (redisSession.supportsCommands(JedisCommands.class)) {
                    redisSession.getCommands(JedisCommands.class).del(key.getFullyQualifiedName(DBPEvaluationContext.DDL));
                } else {
                    redisSession.getCommands(JedisClusterCommands.class).del(key.getFullyQualifiedName(DBPEvaluationContext.DDL));
                }
            }
        });
    }
}

