/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mongodb.exec;

import com.dbeaver.ee.mongodb.MongoUtils;
import com.dbeaver.ee.mongodb.exec.MongoSession;
import com.dbeaver.ee.mongodb.model.MongoDataSource;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import javax.net.ssl.SSLContext;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.AbstractExecutionContext;
import org.jkiss.dbeaver.model.impl.net.SSLHandlerTrustStoreImpl;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.utils.CommonUtils;

public class MongoExecutionContext
extends AbstractExecutionContext<MongoDataSource> {
    private static final Log log = Log.getLog(MongoExecutionContext.class);
    private boolean autoCommitState;
    private MongoClient client;
    private Document buildInfo;

    public MongoExecutionContext(MongoDataSource dataSource, String purpose) {
        super((DBPDataSource)dataSource, purpose);
    }

    public MongoClient getClient() {
        return this.client;
    }

    public void connect(DBRProgressMonitor monitor) throws DBCException {
        this.connect(monitor, null, null);
    }

    public void connect(DBRProgressMonitor monitor, Boolean autoCommit, @Nullable Integer txnLevel) throws DBCException {
        DBExecUtils.startContextInitiation((DBPDataSourceContainer)((MongoDataSource)this.dataSource).getContainer());
        try {
            try {
                this.autoCommitState = true;
                monitor.subTask("Open cluster session");
                this.reconnect(monitor);
                super.initContextBootstrap(monitor, this.autoCommitState);
            }
            catch (Exception e) {
                throw new DBCException((Throwable)e, this.dataSource);
            }
        }
        finally {
            DBExecUtils.finishContextInitiation((DBPDataSourceContainer)((MongoDataSource)this.dataSource).getContainer());
        }
    }

    @NotNull
    public MongoSession openSession(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionPurpose purpose, @NotNull String taskTitle) {
        return new MongoSession(monitor, purpose, taskTitle, this);
    }

    public void checkContextAlive(DBRProgressMonitor monitor) throws DBException {
    }

    public DBSInstance getOwnerInstance() {
        return (DBSInstance)this.dataSource;
    }

    public boolean isConnected() {
        return true;
    }

    @NotNull
    public DBCExecutionContext.InvalidateResult invalidateContext(@NotNull DBRProgressMonitor monitor, boolean closeOnFailure) throws DBException {
        this.reconnect(monitor);
        ((MongoDataSource)this.dataSource).refreshObject(monitor);
        return DBCExecutionContext.InvalidateResult.RECONNECTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        MongoExecutionContext mongoExecutionContext = this;
        synchronized (mongoExecutionContext) {
            if (this.client != null) {
                this.client.close();
                this.client = null;
            }
            super.closeContext();
        }
    }

    public void reconnect(DBRProgressMonitor monitor) throws DBException {
        monitor.beginTask("Open MongoDB cluster connection", 3);
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
        DBPConnectionConfiguration connectionInfo = ((MongoDataSource)this.dataSource).getContainer().getActualConnectionConfiguration();
        String hostName = connectionInfo.getHostName();
        String hostPort = connectionInfo.getHostPort();
        String selectedDatabase = ((MongoDataSource)this.dataSource).getSelectedDatabase();
        try {
            try {
                String replicaSet;
                String authString;
                String authString2;
                monitor.subTask("Setting connection parameters");
                ServerAddress addr = new ServerAddress(hostName, Integer.parseInt(hostPort));
                ArrayList<ServerAddress> seeds = new ArrayList<ServerAddress>();
                seeds.add(addr);
                int i = 0;
                while ((authString2 = connectionInfo.getProviderProperty("seed" + i)) != null) {
                    String[] seedTokens = MongoUtils.extractSeedInfo(authString2);
                    try {
                        seeds.add(new ServerAddress(seedTokens[0], Integer.parseInt(seedTokens[1])));
                    }
                    catch (NumberFormatException e) {
                        log.warn((Object)e);
                    }
                    ++i;
                }
                String mechanism = connectionInfo.getProviderProperty("@dbeaver-mongo-cred-mechanism@");
                if (mechanism == null) {
                    mechanism = "NONE";
                }
                MongoCredential cred = null;
                String userName = null;
                String userPassword = null;
                String userDB = connectionInfo.getProviderProperty("@dbeaver-auth-source@");
                if (CommonUtils.isEmpty((String)userDB)) {
                    userDB = connectionInfo.getDatabaseName();
                }
                if ((authString = connectionInfo.getProviderProperty("@dbeaver-auth@0")) != null) {
                    String[] authTokens = MongoUtils.extractAuthInfo(authString);
                    userName = authTokens[0];
                    userDB = authTokens[1];
                    userPassword = authTokens[2];
                }
                if (!CommonUtils.isEmpty((String)connectionInfo.getUserName())) {
                    userName = connectionInfo.getUserName();
                }
                if (!CommonUtils.isEmpty((String)connectionInfo.getUserPassword())) {
                    userPassword = connectionInfo.getUserPassword();
                }
                if (!CommonUtils.isEmpty((String)userName) && !"NONE".equals(mechanism)) {
                    if (mechanism.equals(MongoCredential.PLAIN_MECHANISM)) {
                        cred = MongoCredential.createPlainCredential((String)userName, (String)userDB, (char[])(CommonUtils.isEmpty((String)userPassword) ? null : userPassword.toCharArray()));
                    } else if (mechanism.equals(MongoCredential.GSSAPI_MECHANISM)) {
                        cred = MongoCredential.createGSSAPICredential((String)userName);
                    } else if (mechanism.equals(MongoCredential.MONGODB_CR_MECHANISM)) {
                        cred = MongoCredential.createMongoCRCredential((String)userName, (String)userDB, (char[])(CommonUtils.isEmpty((String)userPassword) ? null : userPassword.toCharArray()));
                    } else if (mechanism.equals(MongoCredential.SCRAM_SHA_1_MECHANISM)) {
                        cred = MongoCredential.createScramSha1Credential((String)userName, (String)userDB, (char[])(CommonUtils.isEmpty((String)userPassword) ? null : userPassword.toCharArray()));
                    } else if (mechanism.equals(MongoCredential.SCRAM_SHA_256_MECHANISM)) {
                        cred = MongoCredential.createScramSha256Credential((String)userName, (String)userDB, (char[])(CommonUtils.isEmpty((String)userPassword) ? null : userPassword.toCharArray()));
                    } else if (mechanism.equals(MongoCredential.MONGODB_X509_MECHANISM)) {
                        cred = MongoCredential.createMongoX509Credential((String)userName);
                    }
                }
                MongoClientOptions.Builder builder = MongoClientOptions.builder();
                if (!((MongoDataSource)this.dataSource).getContainer().getPreferenceStore().getBoolean("database.meta.client.name.disable")) {
                    builder.description(DBUtils.getClientApplicationName((DBPDataSourceContainer)((MongoDataSource)this.getDataSource()).getContainer(), null));
                }
                if (connectionInfo.getProperty("serverSelectTimeout") != null) {
                    builder.serverSelectionTimeout(CommonUtils.toInt((Object)connectionInfo.getProperty("serverSelectTimeout")));
                } else {
                    builder.serverSelectionTimeout(5000);
                }
                if (connectionInfo.getProperty("connectTimeout") != null) {
                    builder.connectTimeout(CommonUtils.toInt((Object)connectionInfo.getProperty("connectTimeout")));
                }
                if (connectionInfo.getProperty("socketTimeout") != null) {
                    builder.socketTimeout(CommonUtils.toInt((Object)connectionInfo.getProperty("socketTimeout")));
                }
                if (connectionInfo.getProperty("socketKeepAlive") != null) {
                    builder.socketKeepAlive(CommonUtils.toBoolean((Object)connectionInfo.getProperty("socketKeepAlive")));
                }
                if (connectionInfo.getProperty("maxConnectionIdleTime") != null) {
                    builder.maxConnectionIdleTime(CommonUtils.toInt((Object)connectionInfo.getProperty("maxConnectionIdleTime")));
                }
                if (connectionInfo.getProperty("maxConnectionLifeTime") != null) {
                    builder.maxConnectionLifeTime(CommonUtils.toInt((Object)connectionInfo.getProperty("maxConnectionLifeTime")));
                }
                if (connectionInfo.getProperty("maxWaitTime") != null) {
                    builder.maxWaitTime(CommonUtils.toInt((Object)connectionInfo.getProperty("maxWaitTime")));
                }
                if (connectionInfo.getProperty("heartbeatConnectTimeout") != null) {
                    builder.heartbeatConnectTimeout(CommonUtils.toInt((Object)connectionInfo.getProperty("heartbeatConnectTimeout")));
                }
                if (connectionInfo.getProperty("heartbeatSocketTimeout") != null) {
                    builder.heartbeatSocketTimeout(CommonUtils.toInt((Object)connectionInfo.getProperty("heartbeatSocketTimeout")));
                }
                if (connectionInfo.getProperty("heartbeatFrequency") != null) {
                    builder.heartbeatFrequency(CommonUtils.toInt((Object)connectionInfo.getProperty("heartbeatFrequency")));
                }
                if (!CommonUtils.isEmpty((String)(replicaSet = CommonUtils.toString((Object)connectionInfo.getProviderProperty("replicaSet"), null)))) {
                    builder.requiredReplicaSetName(replicaSet);
                }
                boolean singleNodeMode = CommonUtils.toBoolean((Object)connectionInfo.getProperty("singleNodeMode"));
                monitor.worked(1);
                DBWHandlerConfiguration sslConfig = connectionInfo.getHandler("mongo_ssl");
                if (sslConfig != null && sslConfig.isEnabled()) {
                    monitor.subTask("Initializing SSL");
                    builder.sslEnabled(true);
                    boolean skipHostValidation = sslConfig.getBooleanProperty("sslInvalidHostNameAllowed");
                    if (skipHostValidation) {
                        builder.sslInvalidHostNameAllowed(true);
                    }
                    try {
                        SSLHandlerTrustStoreImpl.initializeTrustStore((DBRProgressMonitor)monitor, (DBPDataSource)this.dataSource, (DBWHandlerConfiguration)sslConfig);
                        SSLContext sslContext = SSLHandlerTrustStoreImpl.createTrustStoreSslContext((DBPDataSource)this.dataSource, (DBWHandlerConfiguration)sslConfig);
                        builder.sslContext(sslContext);
                        log.debug((Object)("Initialized " + sslContext.getProtocol() + " protocol: " + sslContext.getProvider()));
                    }
                    catch (Exception e) {
                        throw new DBCException("Error initializing SSL trust store", (Throwable)e);
                    }
                }
                monitor.worked(1);
                monitor.subTask("Creating client connection");
                MongoClientOptions options = builder.build();
                this.client = seeds.size() == 1 && singleNodeMode ? (cred == null ? new MongoClient((ServerAddress)seeds.get(0), options) : new MongoClient((ServerAddress)seeds.get(0), cred, options)) : (cred == null ? new MongoClient(seeds, options) : new MongoClient(seeds, cred, options));
                monitor.subTask("Connecting to the MongoDB server");
                MongoDatabase database = this.client.getDatabase(selectedDatabase);
                this.buildInfo = database.runCommand((Bson)new Document("buildInfo", (Object)1));
            }
            catch (Throwable e) {
                this.client = null;
                throw new DBException("Error connecting to MongoDB instance [" + hostName + "]", e);
            }
        }
        finally {
            monitor.done();
        }
    }

    public Document getBuildInfo() {
        return this.buildInfo;
    }
}

