/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mongodb.model;

import com.dbeaver.ee.mongodb.MongoUtils;
import com.dbeaver.ee.mongodb.exec.MongoExecutionContext;
import com.dbeaver.ee.mongodb.model.MGDataType;
import com.dbeaver.ee.mongodb.model.MGDatabase;
import com.dbeaver.ee.mongodb.model.MGOperationManager;
import com.dbeaver.ee.mongodb.model.MongoDataSourceInfo;
import com.dbeaver.ee.mongodb.model.MongoSQLDialect;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.MongoSocketException;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bson.Document;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPTermProvider;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.BasicObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDataSource;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectSelector;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Version;

public class MongoDataSource
implements DBPDataSource,
SQLDataSource,
DBSInstance,
DBSObject,
DBSObjectSelector,
DBSObjectContainer,
DBPRefreshableObject,
DBPTermProvider,
DBPDataTypeProvider,
DBPErrorAssistant,
IAdaptable {
    private static final Log log = Log.getLog(MongoDataSource.class);
    private DBPDataSourceContainer container;
    private MongoExecutionContext executionContext;
    private Version serverVersion;
    private String selectedDatabase;
    private DatabaseCache databaseCache = new DatabaseCache();
    private MongoDataSourceInfo info;
    private List<MGDataType> dataTypes = new ArrayList<MGDataType>();

    public MongoDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        this.container = container;
        DBPConnectionConfiguration connectionInfo = this.getContainer().getConnectionConfiguration();
        this.selectedDatabase = connectionInfo.getDatabaseName();
        this.dataTypes.add(new MGDataType(this, 1, "ObjectId", "objectId"));
        this.dataTypes.add(new MGDataType(this, 2, "Document", "document"));
        this.dataTypes.add(new MGDataType(this, 3, "String", "string"));
        this.dataTypes.add(new MGDataType(this, 4, "Number", "number"));
        this.dataTypes.add(new MGDataType(this, 5, "Boolean", "boolean"));
        this.dataTypes.add(new MGDataType(this, 6, "Timestamp", "date"));
        this.dataTypes.add(new MGDataType(this, 7, "Binary", "byte[]"));
        this.dataTypes.add(new MGDataType(this, 8, "List", "array"));
        this.dataTypes.add(new MGDataType(this, 9, "Object", "object"));
        this.executionContext = new MongoExecutionContext(this, "Main Mongo Connection");
        this.executionContext.connect(monitor);
        Document buildInfo = this.executionContext.getBuildInfo();
        Object version = buildInfo.get((Object)"version");
        if (version != null) {
            try {
                this.serverVersion = new Version(CommonUtils.toString((Object)version));
            }
            catch (Exception e) {
                log.debug((Object)"Can't extract Mongo server version", (Throwable)e);
            }
        }
    }

    public Version getServerVersion() {
        return this.serverVersion;
    }

    public boolean isServerVersionAtLeast(int major, int minor) {
        if (this.serverVersion == null) {
            return false;
        }
        if (this.serverVersion.getMajor() < major) {
            return false;
        }
        return this.serverVersion.getMajor() != major || this.serverVersion.getMinor() >= minor;
    }

    public MongoExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public DatabaseCache getDatabaseCache() {
        return this.databaseCache;
    }

    @Association
    public Collection<MGDatabase> getDatabases() {
        return this.databaseCache.getCachedObjects();
    }

    public MGDatabase getDatabase(String name) {
        return (MGDatabase)this.databaseCache.getCachedObject(name);
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.container;
    }

    @NotNull
    public MongoDataSource getDataSource() {
        return this;
    }

    @NotNull
    public DBPDataSourceContainer getContainer() {
        return this.container;
    }

    @NotNull
    public DBPDataSourceInfo getInfo() {
        return this.info;
    }

    public Object getDataSourceFeature(String featureId) {
        return null;
    }

    @NotNull
    public DBCExecutionContext getDefaultContext(boolean meta) {
        return this.executionContext;
    }

    @NotNull
    public DBCExecutionContext[] getAllContexts() {
        return new DBCExecutionContext[]{this.executionContext};
    }

    public MongoClient createClient() throws DBException {
        DBPConnectionConfiguration connectionInfo = this.getContainer().getActualConnectionConfiguration();
        String hostName = connectionInfo.getHostName();
        String hostPort = connectionInfo.getHostPort();
        this.getSelectedDatabase();
        MongoClientSettings.Builder csBuilder = MongoClientSettings.builder();
        try {
            String replicaSet;
            String authString;
            String authString2;
            ServerAddress addr = new ServerAddress(hostName, Integer.parseInt(hostPort));
            ArrayList<ServerAddress> seeds = new ArrayList<ServerAddress>();
            seeds.add(addr);
            int i = 0;
            while ((authString2 = connectionInfo.getProviderProperty("seed" + i)) != null) {
                String[] seedTokens = MongoUtils.extractSeedInfo(authString2);
                try {
                    seeds.add(new ServerAddress(seedTokens[0], Integer.parseInt(seedTokens[1])));
                }
                catch (NumberFormatException e) {
                    log.warn((Object)e);
                }
                ++i;
            }
            String mechanism = connectionInfo.getProviderProperty("@dbeaver-mongo-cred-mechanism@");
            if (mechanism == null) {
                mechanism = "NONE";
            }
            ArrayList<MongoCredential> credentials = new ArrayList<MongoCredential>();
            int i2 = 0;
            while ((authString = connectionInfo.getProviderProperty("@dbeaver-auth@" + i2)) != null) {
                String[] authTokens = MongoUtils.extractAuthInfo(authString);
                String userName = authTokens[0];
                String userDB = authTokens[1];
                String userPassword = authTokens[2];
                if (!CommonUtils.isEmpty((String)userName) && !"NONE".equals(mechanism)) {
                    MongoCredential cred = null;
                    if (mechanism.equals(MongoCredential.PLAIN_MECHANISM)) {
                        cred = MongoCredential.createPlainCredential((String)userName, (String)userDB, (char[])(CommonUtils.isEmpty((String)userPassword) ? null : userPassword.toCharArray()));
                    } else if (mechanism.equals(MongoCredential.GSSAPI_MECHANISM)) {
                        cred = MongoCredential.createGSSAPICredential((String)userName);
                    } else if (mechanism.equals(MongoCredential.MONGODB_CR_MECHANISM)) {
                        cred = MongoCredential.createMongoCRCredential((String)userName, (String)userDB, (char[])(CommonUtils.isEmpty((String)userPassword) ? null : userPassword.toCharArray()));
                    } else if (mechanism.equals(MongoCredential.SCRAM_SHA_1_MECHANISM)) {
                        cred = MongoCredential.createScramSha1Credential((String)userName, (String)userDB, (char[])(CommonUtils.isEmpty((String)userPassword) ? null : userPassword.toCharArray()));
                    } else if (mechanism.equals(MongoCredential.SCRAM_SHA_256_MECHANISM)) {
                        cred = MongoCredential.createScramSha256Credential((String)userName, (String)userDB, (char[])(CommonUtils.isEmpty((String)userPassword) ? null : userPassword.toCharArray()));
                    } else if (mechanism.equals(MongoCredential.MONGODB_X509_MECHANISM)) {
                        cred = MongoCredential.createMongoX509Credential((String)userName);
                    }
                    if (cred != null) {
                        credentials.add(cred);
                        csBuilder.credential(cred);
                    }
                }
                ++i2;
            }
            MongoClientOptions.Builder builder = MongoClientOptions.builder();
            if (!this.getContainer().getPreferenceStore().getBoolean("database.meta.client.name.disable")) {
                builder.description(DBUtils.getClientApplicationName((DBPDataSourceContainer)this.getDataSource().getContainer(), null));
            }
            if (connectionInfo.getProperty("connectTimeout") != null) {
                builder.connectTimeout(CommonUtils.toInt((Object)connectionInfo.getProperty("connectTimeout")));
            }
            if (connectionInfo.getProperty("socketTimeout") != null) {
                builder.socketTimeout(CommonUtils.toInt((Object)connectionInfo.getProperty("socketTimeout")));
            }
            if (connectionInfo.getProperty("socketKeepAlive") != null) {
                builder.socketKeepAlive(CommonUtils.toBoolean((Object)connectionInfo.getProperty("socketKeepAlive")));
            }
            if (connectionInfo.getProperty("maxConnectionIdleTime") != null) {
                builder.maxConnectionIdleTime(CommonUtils.toInt((Object)connectionInfo.getProperty("maxConnectionIdleTime")));
            }
            if (connectionInfo.getProperty("maxConnectionLifeTime") != null) {
                builder.maxConnectionLifeTime(CommonUtils.toInt((Object)connectionInfo.getProperty("maxConnectionLifeTime")));
            }
            if (connectionInfo.getProperty("maxWaitTime") != null) {
                builder.maxWaitTime(CommonUtils.toInt((Object)connectionInfo.getProperty("maxWaitTime")));
            }
            if (connectionInfo.getProperty("heartbeatConnectTimeout") != null) {
                builder.heartbeatConnectTimeout(CommonUtils.toInt((Object)connectionInfo.getProperty("heartbeatConnectTimeout")));
            }
            if (connectionInfo.getProperty("heartbeatSocketTimeout") != null) {
                builder.heartbeatSocketTimeout(CommonUtils.toInt((Object)connectionInfo.getProperty("heartbeatSocketTimeout")));
            }
            if (connectionInfo.getProperty("heartbeatFrequency") != null) {
                builder.heartbeatFrequency(CommonUtils.toInt((Object)connectionInfo.getProperty("heartbeatFrequency")));
            }
            if (!CommonUtils.isEmpty((String)(replicaSet = CommonUtils.toString((Object)connectionInfo.getProviderProperty("replicaSet"), null)))) {
                builder.requiredReplicaSetName(replicaSet);
            }
            CommonUtils.toBoolean((Object)connectionInfo.getProperty("singleNodeMode"));
            if (connectionInfo.getProperty("sslEnabled") != null) {
                builder.sslEnabled(CommonUtils.toBoolean((Object)connectionInfo.getProperty("sslEnabled")));
            }
            if (connectionInfo.getProperty("sslInvalidHostNameAllowed") != null) {
                builder.sslInvalidHostNameAllowed(CommonUtils.toBoolean((Object)connectionInfo.getProperty("sslInvalidHostNameAllowed")));
            }
            return MongoClients.create((MongoClientSettings)csBuilder.build());
        }
        catch (Throwable e) {
            throw new DBException("Error connecting to Mongo instance [" + hostName + "]", e);
        }
    }

    @NotNull
    public DBCExecutionContext openIsolatedContext(@NotNull DBRProgressMonitor monitor, @NotNull String purpose) throws DBException {
        MongoExecutionContext context = new MongoExecutionContext(this, purpose);
        context.connect(monitor);
        return context;
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        try {
            this.databaseCache.getAllObjects(monitor, this);
            this.info = new MongoDataSourceInfo(this.executionContext.getClient());
        }
        catch (Exception e) {
            throw new DBException("Error initializing MongoDB context", (Throwable)e);
        }
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.databaseCache.clearCache();
        this.initialize(monitor);
        return this;
    }

    public boolean supportsDefaultChange() {
        return true;
    }

    public String getSelectedDatabase() {
        return this.selectedDatabase;
    }

    public MGDatabase getDefaultObject() {
        return this.getDatabase(this.selectedDatabase);
    }

    public void setDefaultObject(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject object) throws DBException {
        MGDatabase oldSelectedEntity = this.getDefaultObject();
        this.setActiveEntityName(object);
        if (oldSelectedEntity != null) {
            DBUtils.fireObjectSelect((DBSObject)oldSelectedEntity, (boolean)false);
        }
        DBUtils.fireObjectSelect((DBSObject)object, (boolean)true);
    }

    public boolean refreshDefaultObject(@NotNull DBCSession session) throws DBException {
        return false;
    }

    void setActiveEntityName(DBSObject entity) throws DBException {
        if (entity instanceof MGDatabase) {
            this.selectedDatabase = entity.getName();
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBSStructureAssistant.class) {
            return null;
        }
        if (adapter == DBAServerSessionManager.class) {
            return adapter.cast(new MGOperationManager(this));
        }
        return null;
    }

    public String getObjectTypeTerm(String path, String objectType, boolean multiple) {
        String term = null;
        if ("cluster".equals(objectType)) {
            term = "Cluster";
        } else if ("keypace".equals(objectType)) {
            term = "Keyspace";
        }
        if (term != null && multiple) {
            term = String.valueOf(term) + "s";
        }
        return term;
    }

    @NotNull
    public DBSInstance getDefaultInstance() {
        return this;
    }

    @NotNull
    public Collection<? extends DBSInstance> getAvailableInstances() {
        return Collections.singletonList(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(DBRProgressMonitor monitor) {
        MongoDataSource mongoDataSource = this;
        synchronized (mongoDataSource) {
            this.executionContext.close();
        }
    }

    @NotNull
    public String getName() {
        return this.container.getName();
    }

    public boolean isPersisted() {
        return true;
    }

    public SQLDialect getSQLDialect() {
        return MongoSQLDialect.INSTANCE;
    }

    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getDatabases();
    }

    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return this.getDatabase(childName);
    }

    public Class<? extends DBSObject> getChildType(@NotNull DBRProgressMonitor monitor) throws DBException {
        return MGDatabase.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
    }

    @NotNull
    public DBPDataKind resolveDataKind(@NotNull String typeName, int typeID) {
        switch (typeID) {
            case 1: {
                return DBPDataKind.STRING;
            }
            case 2: {
                return DBPDataKind.DOCUMENT;
            }
            case 3: {
                return DBPDataKind.STRING;
            }
            case 4: {
                return DBPDataKind.NUMERIC;
            }
            case 5: {
                return DBPDataKind.BOOLEAN;
            }
            case 6: {
                return DBPDataKind.DATETIME;
            }
            case 7: {
                return DBPDataKind.BINARY;
            }
            case 8: {
                return DBPDataKind.ARRAY;
            }
        }
        return DBPDataKind.OBJECT;
    }

    public MGDataType resolveDataType(@NotNull DBRProgressMonitor monitor, @NotNull String typeFullName) throws DBException {
        MGDataType dataType = this.getLocalDataType(typeFullName);
        if (dataType == null || dataType.getTypeID() == 2) {
            return null;
        }
        return dataType;
    }

    public Collection<MGDataType> getLocalDataTypes() {
        return this.dataTypes;
    }

    public MGDataType getLocalDataType(String typeName) {
        for (MGDataType type : this.dataTypes) {
            if (!type.getName().equals(typeName)) continue;
            return type;
        }
        return null;
    }

    public DBSDataType getLocalDataType(int typeID) {
        for (MGDataType type : this.dataTypes) {
            if (type.getTypeID() != typeID) continue;
            return type;
        }
        return null;
    }

    public MGDataType getDataTypeByJS(String typeName) {
        for (MGDataType type : this.dataTypes) {
            if (!type.getJsName().equals(typeName)) continue;
            return type;
        }
        return this.getDataType(9);
    }

    public MGDataType getDataType(int valueType) {
        return this.dataTypes.get(valueType - 1);
    }

    public String getDefaultDataTypeName(@NotNull DBPDataKind dataKind) {
        return "String";
    }

    public DBPErrorAssistant.ErrorType discoverErrorType(@NotNull Throwable error) {
        if (error.getCause() instanceof MongoSocketException) {
            return DBPErrorAssistant.ErrorType.CONNECTION_LOST;
        }
        return DBPErrorAssistant.ErrorType.NORMAL;
    }

    @Nullable
    public DBPErrorAssistant.ErrorPosition[] getErrorPosition(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext context, @NotNull String query, @NotNull Throwable error) {
        return null;
    }

    class DatabaseCache
    extends BasicObjectCache<MongoDataSource, MGDatabase> {
        DatabaseCache() {
        }

        @NotNull
        public List<MGDatabase> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable MongoDataSource dataSource) throws DBException {
            if (!this.isFullyCached()) {
                ArrayList<MGDatabase> databaseList = new ArrayList<MGDatabase>();
                if (!CommonUtils.getBoolean((String)MongoDataSource.this.getContainer().getActualConnectionConfiguration().getProviderProperty("showAllDatabases"), (boolean)true) && !CommonUtils.isEmpty((String)dataSource.getContainer().getConnectionConfiguration().getDatabaseName())) {
                    databaseList.add(new MGDatabase(dataSource, dataSource.getContainer().getConnectionConfiguration().getDatabaseName()));
                } else {
                    try {
                        MongoIterable databaseNames = MongoDataSource.this.executionContext.getClient().listDatabaseNames();
                        for (String dbName : databaseNames) {
                            MGDatabase db = new MGDatabase(dataSource, dbName);
                            databaseList.add(db);
                        }
                    }
                    catch (Exception exception) {
                        assert (dataSource != null);
                        databaseList.add(new MGDatabase(dataSource, dataSource.getContainer().getConnectionConfiguration().getDatabaseName()));
                    }
                }
                this.setCache(databaseList);
            }
            return this.getCachedObjects();
        }
    }
}

