/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mongodb.data.handlers;

import com.dbeaver.ee.mongodb.MongoUtils;
import com.dbeaver.ee.mongodb.data.MongoDocument;
import com.dbeaver.ee.mongodb.data.MongoListValue;
import com.dbeaver.ee.mongodb.data.MongoMapValue;
import com.dbeaver.ee.mongodb.data.handlers.MongoBaseValueHandler;
import com.dbeaver.ee.mongodb.exec.MongoCustomStatement;
import com.dbeaver.ee.mongodb.exec.MongoSession;
import com.dbeaver.ee.mongodb.model.MongoDataSource;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDDocument;
import org.jkiss.dbeaver.model.data.DBDValueHandlerComposite;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class MongoDocumentValueHandler
extends MongoBaseValueHandler
implements DBDValueHandlerComposite {
    public static final MongoDocumentValueHandler INSTANCE = new MongoDocumentValueHandler();

    @NotNull
    public Class<DBObject> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return DBObject.class;
    }

    @NotNull
    public String getValueContentType(@NotNull DBSTypedObject attribute) {
        return "text/json";
    }

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (value instanceof DBObject || value instanceof DBDDocument) {
            return value.toString();
        }
        return "#document";
    }

    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy) throws DBCException {
        if (object == null) {
            return new MongoDocument((MongoDataSource)session.getDataSource(), (DBObject)new BasicDBObject());
        }
        if (object instanceof DBObject) {
            if (copy) {
                object = MongoUtils.cloneObject(object);
            }
            return new MongoDocument((MongoDataSource)session.getDataSource(), (DBObject)object);
        }
        if (object instanceof Map) {
            return new MongoDocument((MongoDataSource)session.getDataSource(), (DBObject)new BasicDBObject((Map)object));
        }
        if (object instanceof MongoDocument) {
            MongoDocument srcDocument = (MongoDocument)((Object)object);
            return new MongoDocument((MongoDataSource)srcDocument.getDataSource(), MongoUtils.cloneObject(srcDocument.getRawValue()));
        }
        throw new DBCException("Unsupported struct type: " + object.getClass().getName());
    }

    @Override
    public final Object fetchValueObject(@NotNull DBCSession session, @NotNull DBCResultSet resultSet, @NotNull DBSTypedObject type, int index) throws DBCException {
        DBObject columnValue = (DBObject)super.fetchValueObject(session, resultSet, type, index);
        return new MongoDocument((MongoDataSource)session.getDataSource(), columnValue);
    }

    @Override
    protected void bindParameter(MongoSession session, MongoCustomStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException {
    }

    public Object createNewValueObject(@NotNull DBCSession session, @NotNull DBSTypedObject type) throws DBCException {
        if (type.getDataKind() == DBPDataKind.ARRAY) {
            return new MongoListValue((MongoDataSource)session.getDataSource(), new BasicDBList());
        }
        return new MongoMapValue((MongoDataSource)session.getDataSource(), (DBObject)new BasicDBObject(), null);
    }
}

