/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.mockdata.generator;

import com.dbeaver.ui.mockdata.generator.AbstractMockValueGenerator;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;

public class DateRandomGenerator
extends AbstractMockValueGenerator {
    private static final Log log = Log.getLog(DateRandomGenerator.class);
    private static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd-MM-yyyy");
    public static final long DEFAULT_START_DATE = -946771200000L;
    public static final long DAY_RANGE = 86400000L;
    public static final long YEAR_RANGE = 31536000000L;
    public static final long DEFAULT_RANGE = 3153600000000L;
    private long startDate = Long.MAX_VALUE;
    private long endDate = Long.MAX_VALUE;

    @Override
    public void init(DBSDataManipulator container, DBSAttributeBase attribute, Map<Object, Object> properties) throws DBException {
        String toDate;
        super.init(container, attribute, properties);
        String fromDate = (String)properties.get("startDate");
        if (fromDate != null) {
            try {
                this.startDate = DATE_FORMAT.parse(fromDate).getTime();
            }
            catch (ParseException e) {
                log.error((Object)("Error parse Start Date '" + fromDate + "'."), (Throwable)e);
            }
        }
        if ((toDate = (String)properties.get("endDate")) != null) {
            try {
                this.endDate = DATE_FORMAT.parse(toDate).getTime();
            }
            catch (ParseException e) {
                log.error((Object)("Error parse End Date '" + toDate + "'."), (Throwable)e);
            }
        }
        if (this.startDate != Long.MAX_VALUE && this.endDate != Long.MAX_VALUE && this.startDate > this.endDate) {
            long l = this.startDate;
            this.startDate = this.endDate;
            this.endDate = l;
        }
        if (this.endDate != Long.MAX_VALUE) {
            this.endDate += 86399999L;
        }
    }

    @Override
    public Object generateOneValue(DBRProgressMonitor monitor) throws DBException, IOException {
        if (this.isGenerateNULL()) {
            return null;
        }
        if (this.startDate != Long.MAX_VALUE && this.endDate != Long.MAX_VALUE) {
            return new Date(this.startDate + Math.abs(this.random.nextLong()) % (this.endDate - this.startDate));
        }
        if (this.startDate != Long.MAX_VALUE) {
            return new Date(this.startDate + Math.abs(this.random.nextLong()) % 3153600000000L);
        }
        if (this.endDate != Long.MAX_VALUE) {
            return new Date(this.endDate - 3153600000000L + Math.abs(this.random.nextLong()) % 3153600000000L);
        }
        return new Date(-946771200000L + Math.abs(this.random.nextLong()) % 3153600000000L);
    }
}

