/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.mockdata;

import com.dbeaver.ui.mockdata.MockDataExecuteWizard;
import com.dbeaver.ui.mockdata.MockDataMessages;
import com.dbeaver.ui.mockdata.MockDataSettings;
import com.dbeaver.ui.mockdata.MockDataWizardPageSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.tools.ToolWizardDialog;
import org.jkiss.dbeaver.ui.tools.IUserInterfaceTool;

public class MockDataGenerateTool
implements IUserInterfaceTool {
    private MockDataSettings mockDataSettings = new MockDataSettings();

    public void execute(IWorkbenchWindow window, IWorkbenchPart activePart, Collection<DBSObject> objects) throws DBException {
        ArrayList<DBSDataManipulator> dbObjects = new ArrayList<DBSDataManipulator>();
        HashSet<DBPDataSource> dataSources = new HashSet<DBPDataSource>();
        for (DBSObject obj : objects) {
            dbObjects.add((DBSDataManipulator)obj);
            dataSources.add(obj.getDataSource());
        }
        for (DBPDataSource ds : dataSources) {
            if (!ds.getInfo().isReadOnlyData()) continue;
            UIUtils.showMessageBox((Shell)UIUtils.getActiveWorkbenchShell(), (String)"Read-only database", (String)("Database '" + ds.getContainer().getName() + "' is read-only.\nMock data generation is not possible."), (int)8);
        }
        MockDataExecuteWizard wizard = new MockDataExecuteWizard(this.mockDataSettings, dbObjects, MockDataMessages.tools_mockdata_wizard_page_name);
        ToolWizardDialog dialog = new ToolWizardDialog(window, (IWizard)wizard){

            protected void finishPressed() {
                if (this.validateProperties(this.getCurrentPage())) {
                    return;
                }
                if (MockDataGenerateTool.this.mockDataSettings.isRemoveOldData() && !UIUtils.confirmAction((Shell)this.getShell(), (String)MockDataMessages.tools_mockdata_wizard_title, (String)MockDataMessages.tools_mockdata_wizard_page_settings_confirm_delete_old_data_message)) {
                    return;
                }
                super.finishPressed();
            }

            protected void nextPressed() {
                IWizardPage currentPage = this.getCurrentPage();
                if (currentPage instanceof MockDataWizardPageSettings && this.validateProperties(currentPage)) {
                    return;
                }
                super.nextPressed();
            }

            private boolean validateProperties(IWizardPage currentPage) {
                if (currentPage instanceof MockDataWizardPageSettings && !((MockDataWizardPageSettings)currentPage).validateProperties()) {
                    this.setErrorMessage(MockDataMessages.tools_mockdata_wizard_negative_numeric_error);
                    return true;
                }
                return false;
            }

            protected Point getInitialSize() {
                return new Point(850, 550);
            }
        };
        dialog.open();
    }
}

