/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.mockdata.generator.advanced;

import com.dbeaver.ui.mockdata.MockDataUtils;
import com.dbeaver.ui.mockdata.generator.AbstractStringValueGenerator;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.utils.CommonUtils;

public class StringPriceGenerator
extends AbstractStringValueGenerator {
    private String country = "UK";
    private Locale locale = Locale.UK;
    private double min = 0.0;
    private double max = 1000.0;

    @Override
    public void init(DBSDataManipulator container, DBSAttributeBase attribute, Map<Object, Object> properties) throws DBException {
        Double d;
        block30: {
            super.init(container, attribute, properties);
            String c = (String)properties.get("country");
            if (CommonUtils.isEmpty((String)c)) break block30;
            this.country = c;
            switch (c) {
                case "China": {
                    this.locale = Locale.CHINA;
                    break;
                }
                case "France": {
                    this.locale = Locale.FRANCE;
                    break;
                }
                case "Germany": {
                    this.locale = Locale.GERMANY;
                    break;
                }
                case "Italy": {
                    this.locale = Locale.ITALY;
                    break;
                }
                case "Japan": {
                    this.locale = Locale.JAPAN;
                    break;
                }
                case "Russia": {
                    this.locale = new Locale("ru", "RU");
                    break;
                }
                case "UK": {
                    this.locale = Locale.UK;
                    break;
                }
                case "USA": {
                    this.locale = Locale.US;
                }
            }
        }
        if ((d = (Double)properties.get("min")) != null) {
            this.min = d;
        }
        if ((d = (Double)properties.get("max")) != null) {
            this.max = d;
        }
    }

    @Override
    protected Object generateOneValue(DBRProgressMonitor monitor) throws DBException, IOException {
        if (this.isGenerateNULL()) {
            return null;
        }
        return this.formatCurrency(MockDataUtils.getRandomDouble(this.min, this.max, this.random));
    }

    private String formatCurrency(double d) {
        NumberFormat currencyFormatter = NumberFormat.getCurrencyInstance(this.locale);
        return this.correct(currencyFormatter.format(d));
    }

    public String correct(String str) {
        int length = str.length();
        if (str.lastIndexOf(44) == length - 1 || str.lastIndexOf(44) == length - 1) {
            return String.valueOf(str) + '0';
        }
        if (str.endsWith(".00") || str.endsWith(",00")) {
            return str.substring(0, length - 3);
        }
        return str;
    }
}

