/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.sqlite.crypt;

import com.dbeaver.db.sqlite.crypt.SQLiteCipherType;
import com.dbeaver.db.sqlite.crypt.SQLiteCryptParam;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.sqlite.model.SQLiteDataSource;
import org.jkiss.dbeaver.ext.sqlite.model.SQLiteMetaModel;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class SQLiteCryptDataSource
extends SQLiteDataSource {
    public SQLiteCryptDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container, SQLiteMetaModel metaModel) throws DBException {
        super(monitor, container, (GenericMetaModel)metaModel);
    }

    protected void initializeRemoteInstance(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.initializeRemoteInstance(monitor);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = this.getDefaultInstance().getDefaultContext(true).openSession(monitor, DBCExecutionPurpose.META, "Init cipher properties");){
                JDBCUtils.executeQuery((Connection)session, (String)"select * from sqlite_master", (Object[])new Object[0]);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBCException(e, (DBPDataSource)this);
        }
    }

    protected void initializeContextState(@NotNull DBRProgressMonitor monitor, @NotNull JDBCExecutionContext context, boolean setActiveObject) throws DBCException {
        super.initializeContextState(monitor, context, setActiveObject);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCSession session = context.openSession(monitor, DBCExecutionPurpose.META, "Init cipher properties");){
                DBPConnectionConfiguration connectionInfo = this.getContainer().getActualConnectionConfiguration();
                String cipherName = connectionInfo.getProviderProperty("cipher");
                if (!CommonUtils.isEmpty((String)cipherName)) {
                    SQLiteCipherType cipherType = (SQLiteCipherType)CommonUtils.valueOf(SQLiteCipherType.class, (String)cipherName, (Enum)SQLiteCipherType.CHACHA20);
                    JDBCUtils.executeQuery((Connection)session, (String)("SELECT wxsqlite3_config('cipher', '" + cipherType.getCipherId() + "')"), (Object[])new Object[0]);
                }
                SQLiteCryptParam[] sQLiteCryptParamArray = SQLiteCryptParam.values();
                int n = sQLiteCryptParamArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SQLiteCryptParam param = sQLiteCryptParamArray[n2];
                    String paramValue = connectionInfo.getProviderProperty(param.name());
                    if (paramValue != null) {
                        JDBCUtils.executeQuery((Connection)session, (String)("SELECT wxsqlite3_config('sqlcipher', '" + param.name() + "', " + paramValue + ");"), (Object[])new Object[0]);
                    }
                    ++n2;
                }
                String userPassword = connectionInfo.getUserPassword();
                if (!CommonUtils.isEmpty((String)userPassword)) {
                    JDBCUtils.executeQuery((Connection)session, (String)("PRAGMA key = '" + userPassword + "'"), (Object[])new Object[0]);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBCException(e, (DBPDataSource)this);
        }
    }

    protected Properties getAllConnectionProperties(@NotNull DBRProgressMonitor monitor, String purpose, DBPConnectionConfiguration connectionInfo) throws DBCException {
        Properties props = super.getAllConnectionProperties(monitor, purpose, connectionInfo);
        props.remove("password");
        return props;
    }
}

