/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.data;

import com.dbeaver.db.dynamodb.data.DynamoDocument;
import com.dbeaver.db.dynamodb.model.DynamoDataSource;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValue;
import org.jkiss.dbeaver.model.data.DBDValueHandlerComposite;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class DynamoDocumentValueHandler
implements DBDValueHandlerComposite {
    public static final DynamoDocumentValueHandler INSTANCE = new DynamoDocumentValueHandler();

    @NotNull
    public Class<Object> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return Object.class;
    }

    @NotNull
    public String getValueContentType(@NotNull DBSTypedObject attribute) {
        return "text/json";
    }

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (value instanceof Map || value instanceof DBDValue) {
            return value.toString();
        }
        return DBValueFormatting.getDefaultValueDisplayString((Object)value, (DBDDisplayFormat)format);
    }

    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy) throws DBCException {
        if (object == null) {
            return new DynamoDocument((DynamoDataSource)session.getDataSource(), null, null);
        }
        if (object instanceof Map) {
            return new DynamoDocument((DynamoDataSource)session.getDataSource(), null, (Map)object);
        }
        if (object instanceof DynamoDocument) {
            DynamoDocument srcDocument = (DynamoDocument)((Object)object);
            return copy ? srcDocument.copy() : srcDocument;
        }
        throw new DBCException("Unsupported struct type: " + object.getClass().getName());
    }

    public Object createNewValueObject(@NotNull DBCSession session, @NotNull DBSTypedObject type) throws DBCException {
        return new DynamoDocument((DynamoDataSource)session.getDataSource(), null, null);
    }

    public void releaseValueObject(Object value) {
    }

    @NotNull
    public DBCLogicalOperator[] getSupportedOperators(@NotNull DBSTypedObject attribute) {
        return new DBCLogicalOperator[0];
    }

    public final Object fetchValueObject(@NotNull DBCSession session, @NotNull DBCResultSet resultSet, @NotNull DBSTypedObject type, int index) throws DBCException {
        Object attributeValue = resultSet.getAttributeValue(0);
        return this.getValueFromObject(session, type, attributeValue, false);
    }

    public void bindValueObject(@NotNull DBCSession session, @NotNull DBCStatement statement, @NotNull DBSTypedObject type, int index, Object value) throws DBCException {
    }
}

