/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.model;

import com.dbeaver.db.dynamodb.exec.DynamoExecutionContext;
import com.dbeaver.db.dynamodb.model.DynamoBackup;
import com.dbeaver.db.dynamodb.model.DynamoDataSourceInfo;
import com.dbeaver.db.dynamodb.model.DynamoDataType;
import com.dbeaver.db.dynamodb.model.DynamoGlobalTable;
import com.dbeaver.db.dynamodb.model.DynamoSQLDialect;
import com.dbeaver.db.dynamodb.model.DynamoServerType;
import com.dbeaver.db.dynamodb.model.DynamoStructureAssistant;
import com.dbeaver.db.dynamodb.model.DynamoTable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.impl.BasicObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDataSource;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import software.amazon.awssdk.services.dynamodb.model.BackupSummary;
import software.amazon.awssdk.services.dynamodb.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.dynamodb.model.Endpoint;
import software.amazon.awssdk.services.dynamodb.model.GlobalTable;

public class DynamoDataSource
implements DBPDataSource,
DBSInstance,
SQLDataSource,
DBSObjectContainer,
DBSObject,
DBPRefreshableObject,
DBPDataTypeProvider,
IAdaptable {
    private static final Log log = Log.getLog(DynamoDataSource.class);
    @NotNull
    private final DBPDataSourceContainer container;
    private TableCache tableCache = new TableCache();
    private volatile List<DynamoGlobalTable> globalTables;
    private volatile List<DynamoBackup> backups;
    private DynamoDataSourceInfo info;
    @NotNull
    private DynamoExecutionContext executionContext;
    @NotNull
    private List<DynamoExecutionContext> allContexts = new ArrayList<DynamoExecutionContext>();
    private final List<DynamoDataType> dataTypes = new ArrayList<DynamoDataType>();
    private final DynamoDbClient client;
    private Region awsRegion;
    private DynamoServerType serverType;

    public DynamoDataSource(DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        this.container = container;
        this.client = this.createClient();
        try {
            if (this.awsRegion != null) {
                log.debug((Object)("Connect to DynamoDB instance at " + this.awsRegion.id()));
            }
            if (this.serverType == DynamoServerType.STANDALONE) {
                log.debug((Object)"Connected to local DynamoDB. Check connection.");
                this.client.listTables();
            } else {
                DescribeEndpointsResponse endpoints = this.client.describeEndpoints();
                for (Endpoint endpoint : endpoints.endpoints()) {
                    log.debug((Object)("DynamoDB endpoint: " + endpoint.toString()));
                }
            }
        }
        catch (Exception e) {
            throw new DBException("Error connecting to DynamoDB server", (Throwable)e);
        }
        DynamoDataType.TypeName[] typeNameArray = DynamoDataType.TypeName.values();
        int n = typeNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            DynamoDataType.TypeName typeName = typeNameArray[n2];
            this.dataTypes.add(new DynamoDataType(this, typeName));
            ++n2;
        }
        this.executionContext = new DynamoExecutionContext(this, "Main Dynamo Connection");
        this.executionContext.connect(monitor);
    }

    public DynamoDbClient getClient() {
        return this.client;
    }

    private DynamoDbClient createClient() throws DBException {
        DBPConnectionConfiguration connectionCfg = this.getContainer().getConnectionConfiguration();
        this.serverType = (DynamoServerType)CommonUtils.valueOf(DynamoServerType.class, (String)connectionCfg.getProviderProperty("serverType"), (Enum)DynamoServerType.AWS);
        String credProviderId = connectionCfg.getProviderProperty("credentialsProvider");
        if (CommonUtils.isEmpty((String)credProviderId)) {
            credProviderId = "static";
        }
        StaticCredentialsProvider credentialsProvider = null;
        switch (credProviderId) {
            case "profile": {
                String profileName = connectionCfg.getProviderProperty("profileName");
                if (profileName == null) {
                    throw new DBException("AWS profile name must be specified");
                }
                credentialsProvider = ProfileCredentialsProvider.builder().profileName(profileName).build();
                break;
            }
            default: {
                AwsBasicCredentials credentials;
                if (this.serverType == DynamoServerType.STANDALONE) {
                    credentials = AwsBasicCredentials.create((String)"x", (String)"x");
                } else {
                    if (CommonUtils.isEmpty((String)connectionCfg.getUserName())) {
                        throw new DBException("AWS access key must be specified");
                    }
                    if (CommonUtils.isEmpty((String)connectionCfg.getUserPassword())) {
                        throw new DBException("AWS secret key must be specified");
                    }
                    credentials = AwsBasicCredentials.create((String)connectionCfg.getUserName(), (String)connectionCfg.getUserPassword());
                }
                credentialsProvider = StaticCredentialsProvider.create((AwsCredentials)credentials);
            }
        }
        String regionName = connectionCfg.getProviderProperty("regionName");
        if (regionName == null) {
            throw new DBException("AWS region must be specified");
        }
        this.awsRegion = Region.of((String)regionName);
        DynamoDbClientBuilder builder = (DynamoDbClientBuilder)((DynamoDbClientBuilder)DynamoDbClient.builder().region(this.awsRegion)).credentialsProvider((AwsCredentialsProvider)credentialsProvider);
        if (this.serverType == DynamoServerType.STANDALONE) {
            try {
                builder.endpointOverride(new URI(connectionCfg.getHostName()));
            }
            catch (URISyntaxException e) {
                throw new DBException("Wrong endpoint URI", (Throwable)e);
            }
        }
        return (DynamoDbClient)builder.build();
    }

    public SQLDialect getSQLDialect() {
        return DynamoSQLDialect.INSTANCE;
    }

    @NotNull
    public DBPDataSourceContainer getContainer() {
        return this.container;
    }

    @NotNull
    public DBPDataSourceInfo getInfo() {
        return this.info;
    }

    public Object getDataSourceFeature(String featureId) {
        return null;
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.info = new DynamoDataSourceInfo(this);
    }

    @NotNull
    public DynamoExecutionContext getDefaultContext(boolean meta) {
        return this.executionContext;
    }

    @NotNull
    public DynamoExecutionContext[] getAllContexts() {
        return this.allContexts.toArray(new DynamoExecutionContext[this.allContexts.size()]);
    }

    @NotNull
    public DynamoExecutionContext openIsolatedContext(@NotNull DBRProgressMonitor monitor, @NotNull String purpose) throws DBException {
        DynamoExecutionContext context = new DynamoExecutionContext(this, purpose);
        context.connect(monitor);
        return context;
    }

    public void addExecutionContext(DynamoExecutionContext context) {
        this.allContexts.add(context);
    }

    public void removeExecutionContext(DynamoExecutionContext context) {
        this.allContexts.remove((Object)context);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBSStructureAssistant.class) {
            return adapter.cast(new DynamoStructureAssistant(this));
        }
        return null;
    }

    @NotNull
    public DBSInstance getDefaultInstance() {
        return this;
    }

    @NotNull
    public Collection<? extends DBSInstance> getAvailableInstances() {
        return Collections.singletonList(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(DBRProgressMonitor monitor) {
        DynamoDataSource dynamoDataSource = this;
        synchronized (dynamoDataSource) {
            this.executionContext.close();
        }
        this.client.close();
    }

    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.container;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this;
    }

    @NotNull
    public String getName() {
        return this.container.getName();
    }

    public boolean isPersisted() {
        return true;
    }

    public TableCache getTableCache() {
        return this.tableCache;
    }

    @Association
    public List<DynamoTable> getTables(DBRProgressMonitor monitor) throws DBException {
        return this.tableCache.getAllObjects(monitor, this);
    }

    @Association
    public List<DynamoGlobalTable> getGlobalTables(DBRProgressMonitor monitor) {
        if (this.globalTables == null) {
            ArrayList<DynamoGlobalTable> tableList = new ArrayList<DynamoGlobalTable>();
            for (GlobalTable globalTable : this.client.listGlobalTables().globalTables()) {
                DynamoGlobalTable table = new DynamoGlobalTable(this, globalTable);
                tableList.add(table);
            }
            this.globalTables = tableList;
        }
        return this.globalTables;
    }

    @Association
    public List<DynamoBackup> getBackups(DBRProgressMonitor monitor) {
        if (this.backups == null) {
            ArrayList<DynamoBackup> backupList = new ArrayList<DynamoBackup>();
            for (BackupSummary backupSummary : this.client.listBackups().backupSummaries()) {
                DynamoBackup backup = new DynamoBackup(this, backupSummary);
                backupList.add(backup);
            }
            this.backups = backupList;
        }
        return this.backups;
    }

    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getTables(monitor);
    }

    public DynamoTable getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return (DynamoTable)this.tableCache.getObject(monitor, this, childName);
    }

    public Class<? extends DBSObject> getChildType(@NotNull DBRProgressMonitor monitor) throws DBException {
        return DynamoTable.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        this.getTables(monitor);
        this.getGlobalTables(monitor);
    }

    @NotNull
    public DBPDataKind resolveDataKind(@NotNull String typeName, int typeID) {
        for (DynamoDataType dataType : this.dataTypes) {
            if (!dataType.getTypeName().equals(typeName)) continue;
            return dataType.getDataKind();
        }
        return DBPDataKind.OBJECT;
    }

    public DynamoDataType resolveDataType(@NotNull DBRProgressMonitor monitor, @NotNull String typeFullName) throws DBException {
        return this.getLocalDataType(typeFullName);
    }

    public List<DynamoDataType> getLocalDataTypes() {
        return this.dataTypes;
    }

    public DynamoDataType getLocalDataType(String typeName) {
        for (DynamoDataType dataType : this.dataTypes) {
            if (!dataType.getTypeName().equals(typeName)) continue;
            return dataType;
        }
        return null;
    }

    public DynamoDataType getLocalDataType(int typeID) {
        for (DynamoDataType dataType : this.dataTypes) {
            if (dataType.getTypeID() != typeID) continue;
            return dataType;
        }
        return null;
    }

    public String getDefaultDataTypeName(@NotNull DBPDataKind dataKind) {
        return DynamoDataType.TypeName.STRING.getTypeName();
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.tableCache.clearCache();
        this.globalTables = null;
        this.backups = null;
        return this;
    }

    class TableCache
    extends BasicObjectCache<DynamoDataSource, DynamoTable> {
        TableCache() {
        }

        @NotNull
        public List<DynamoTable> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable DynamoDataSource dataSource) throws DBException {
            if (!this.isFullyCached()) {
                ArrayList<DynamoTable> tableList = new ArrayList<DynamoTable>();
                for (String tableName : DynamoDataSource.this.client.listTables().tableNames()) {
                    DynamoTable table = new DynamoTable(dataSource, tableName, true);
                    tableList.add(table);
                }
                this.setCache(tableList);
            }
            return this.getCachedObjects();
        }
    }
}

