/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.exec;

import com.dbeaver.db.dynamodb.DynamoDBUtils;
import com.dbeaver.db.dynamodb.exec.DynamoBaseStatement;
import com.dbeaver.db.dynamodb.exec.DynamoResultIterable;
import com.dbeaver.db.dynamodb.exec.DynamoSQL;
import com.dbeaver.db.dynamodb.exec.DynamoSession;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.Limit;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.services.dynamodb.model.Condition;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.paginators.QueryIterable;

public class DynamoQueryStatement
extends DynamoBaseStatement {
    public static Gson QUERY_PARSER = new GsonBuilder().setPrettyPrinting().setDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").serializeNulls().setLenient().create();
    private static final Log log = Log.getLog(DynamoQueryStatement.class);
    private final String queryText;
    private DBCExecutionSource source;
    private QueryRequest queryRequest;
    protected long offset;
    protected long limit;
    private DynamoResultIterable resultSet;

    public DynamoQueryStatement(DynamoSession session, String queryText) {
        super(session);
        this.queryText = queryText;
        if (session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementOpen((DBCStatement)this);
        }
    }

    public String getQueryString() {
        return this.queryRequest == null ? this.queryText : this.queryRequest.toString();
    }

    public DBCExecutionSource getStatementSource() {
        return this.source;
    }

    public void setStatementSource(@Nullable DBCExecutionSource source) {
        this.source = source;
    }

    public boolean executeStatement() throws DBCException {
        if (((DynamoSession)this.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteBegin((DBCStatement)this);
        }
        Exception executeError = null;
        try {
            String query = this.queryText.trim();
            if (query.toUpperCase(Locale.ENGLISH).startsWith("SELECT")) {
                this.createSelectQuery(query);
            } else {
                if (!query.startsWith("{")) {
                    query = "{" + query + "}";
                }
                this.createJsonQueryRequest(query);
            }
            if (CommonUtils.isEmpty((Map)this.queryRequest.keyConditions())) {
                ScanRequest.Builder srBuilder = ScanRequest.builder().tableName(this.queryRequest.tableName()).attributesToGet((Collection)this.queryRequest.attributesToGet());
                if (this.limit > 0L) {
                    srBuilder.limit(Integer.valueOf((int)this.limit));
                }
                ScanRequest scanRequest = (ScanRequest)srBuilder.build();
                this.resultSet = new DynamoResultIterable(this, (Iterable<?>)((DynamoSession)this.getSession()).getDataSource().getClient().scanPaginator(scanRequest), this.limit);
            } else {
                QueryIterable queryResponse = ((DynamoSession)this.getSession()).getDataSource().getClient().queryPaginator(this.queryRequest);
                this.resultSet = new DynamoResultIterable(this, (Iterable<?>)queryResponse, this.limit);
            }
            return true;
        }
        catch (Exception e) {
            executeError = e;
            if (e instanceof DBCException) {
                throw (DBCException)e;
            }
            throw new DBCException(GeneralUtils.getRootCause((Throwable)e), (DBPDataSource)((DynamoSession)this.getSession()).getDataSource());
        }
        finally {
            if (((DynamoSession)this.getSession()).isLoggingEnabled()) {
                QMUtils.getDefaultHandler().handleStatementExecuteEnd((DBCStatement)this, (long)this.getUpdateRowCount(), (Throwable)executeError);
            }
        }
    }

    private void createSelectQuery(String query) throws Exception {
        Statement statement = CCJSqlParserUtil.parse((String)query);
        if (!(statement instanceof Select) || !(((Select)statement).getSelectBody() instanceof PlainSelect)) {
            throw new DBCException("Only SELECT SQL queries supported");
        }
        PlainSelect select = (PlainSelect)((Select)statement).getSelectBody();
        this.parseSelect(select);
    }

    private void parseSelect(PlainSelect select) throws DBCException {
        Limit sLimit;
        Expression where;
        if (!(select.getFromItem() instanceof Table)) {
            throw new DBCException("FROM keyword missing");
        }
        if (!CommonUtils.isEmpty((Collection)select.getJoins())) {
            throw new DBCException("JOINs are not supported");
        }
        if (select.getHaving() != null) {
            throw new DBCException("HAVING is not supported");
        }
        QueryRequest.Builder queryBuilder = QueryRequest.builder();
        queryBuilder.limit(Integer.valueOf((int)this.limit));
        queryBuilder.tableName(((Table)select.getFromItem()).getName());
        List selectItems = select.getSelectItems();
        if (!CommonUtils.isEmpty((Collection)selectItems)) {
            ArrayList<String> attrNames = new ArrayList<String>();
            for (SelectItem item : selectItems) {
                if (item instanceof AllColumns || item instanceof AllTableColumns) break;
                if (!(item instanceof SelectExpressionItem)) continue;
                SelectExpressionItem sei = (SelectExpressionItem)item;
                Expression expr = sei.getExpression();
                if (expr instanceof Column) {
                    String attrName = DBUtils.getUnQuotedIdentifier((String)((Column)expr).getFullyQualifiedName(), (String)"\"");
                    attrNames.add(attrName);
                    continue;
                }
                throw new DBCException("Unsupported select expression: " + expr);
            }
            if (!CommonUtils.isEmpty(attrNames)) {
                queryBuilder.attributesToGet(attrNames);
            }
        }
        if ((where = select.getWhere()) != null) {
            LinkedHashMap<String, Condition> conditions = new LinkedHashMap<String, Condition>();
            DynamoSQL.parseExpression(conditions, where);
            if (!CommonUtils.isEmpty(conditions)) {
                queryBuilder.keyConditions(conditions);
            }
        }
        if ((sLimit = select.getLimit()) != null) {
            try {
                if (sLimit.getOffset() != null) {
                    this.offset = Long.parseLong(sLimit.getOffset().toString());
                }
                if (sLimit.getRowCount() != null) {
                    this.limit = Long.parseLong(sLimit.getRowCount().toString());
                }
                queryBuilder.limit(Integer.valueOf((int)this.limit));
            }
            catch (NumberFormatException e) {
                throw new DBCException("Bad LIMIT clause", (Throwable)e);
            }
        }
        this.queryRequest = (QueryRequest)queryBuilder.build();
    }

    private void createJsonQueryRequest(String jsonString) throws Exception {
        Map paramMap = (Map)QUERY_PARSER.fromJson(jsonString, Map.class);
        QueryRequest.Builder queryBuilder = QueryRequest.builder();
        queryBuilder.limit(Integer.valueOf((int)this.limit));
        for (Map.Entry param : paramMap.entrySet()) {
            Object value = param.getValue();
            switch (((String)param.getKey()).toLowerCase(Locale.ENGLISH)) {
                case "tablename": {
                    queryBuilder.tableName(CommonUtils.toString(value));
                    break;
                }
                case "indexname": {
                    queryBuilder.indexName(CommonUtils.toString(value));
                    break;
                }
                case "select": {
                    queryBuilder.select(CommonUtils.toString(value));
                    break;
                }
                case "attributestoget": {
                    ArrayList<String> attrNames = new ArrayList<String>();
                    if (value instanceof Collection) {
                        for (Object object : (Collection)value) {
                            attrNames.add(CommonUtils.toString((Object)object));
                        }
                    }
                    queryBuilder.attributesToGet(attrNames);
                    break;
                }
                case "limit": {
                    queryBuilder.limit(Integer.valueOf(CommonUtils.toInt(value)));
                    break;
                }
                case "consistentread": {
                    queryBuilder.consistentRead(Boolean.valueOf(CommonUtils.toBoolean(value)));
                    break;
                }
                case "keyconditions": {
                    queryBuilder.keyConditionExpression(QUERY_PARSER.toJson(value));
                    break;
                }
                case "queryfilter": {
                    queryBuilder.filterExpression(QUERY_PARSER.toJson(value));
                    break;
                }
                case "conditionaloperator": {
                    queryBuilder.conditionalOperator(CommonUtils.toString(value));
                    break;
                }
                case "scanindexforward": {
                    queryBuilder.scanIndexForward(Boolean.valueOf(CommonUtils.toBoolean(value)));
                    break;
                }
                case "returnconsumedcapacity": {
                    queryBuilder.returnConsumedCapacity(CommonUtils.toString(value));
                    break;
                }
                case "projectionexpression": {
                    queryBuilder.projectionExpression(CommonUtils.toString(value));
                    break;
                }
                case "filterexpression": {
                    queryBuilder.filterExpression(CommonUtils.toString(value));
                    break;
                }
                case "keyconditionexpression": {
                    queryBuilder.keyConditionExpression(CommonUtils.toString(value));
                    break;
                }
                case "expressionattributenames": {
                    LinkedHashMap<String, String> expAttributes = new LinkedHashMap();
                    if (value instanceof Map) {
                        for (Map.Entry entry : ((Map)value).entrySet()) {
                            expAttributes.put((String)entry.getKey(), QUERY_PARSER.toJson(entry.getValue()));
                        }
                    }
                    queryBuilder.expressionAttributeNames(expAttributes);
                    break;
                }
                case "expressionattributevalues": {
                    LinkedHashMap<String, String> expAttributes = new LinkedHashMap<String, String>();
                    if (value instanceof Map) {
                        for (Map.Entry entry : ((Map)value).entrySet()) {
                            expAttributes.put((String)entry.getKey(), (String)DynamoDBUtils.getAttributeValue(entry.getValue()));
                        }
                    }
                    queryBuilder.expressionAttributeValues(expAttributes);
                    break;
                }
                default: {
                    log.debug((Object)("Unsupported DynamoDB query parameter: " + (String)param.getKey()));
                }
                case "exclusivestartkey": 
            }
        }
        this.queryRequest = (QueryRequest)queryBuilder.build();
    }

    public void addToBatch() throws DBCException {
        throw new DBCException("Not implemented");
    }

    public int[] executeStatementBatch() throws DBCException {
        throw new DBCException("Not implemented");
    }

    public DynamoResultIterable openResultSet() throws DBCException {
        return this.resultSet;
    }

    public DBCResultSet openGeneratedKeysResultSet() throws DBCException {
        throw new DBCException("Not implemented");
    }

    public int getUpdateRowCount() {
        return -1;
    }

    public boolean nextResults() throws DBCException {
        return false;
    }

    public void close() {
        if (((DynamoSession)this.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementClose((DBCStatement)this, (long)this.getUpdateRowCount());
        }
    }

    public void setLimit(long offset, long limit) throws DBCException {
        this.offset = offset;
        this.limit = limit;
    }

    @Nullable
    public Throwable[] getStatementWarnings() throws DBCException {
        return null;
    }

    public void setStatementTimeout(int timeout) throws DBCException {
    }

    public void setResultsFetchSize(int fetchSize) throws DBCException {
    }

    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
        if (blockThread == null) {
            throw new DBException("Mongo query cancel not implemented");
        }
        blockThread.interrupt();
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLimit() {
        return this.limit;
    }

    @Override
    public String getEntityName() {
        return this.queryRequest == null ? null : this.queryRequest.tableName();
    }
}

