/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.ui.views;

import com.dbeaver.db.dynamodb.model.DynamoServerType;
import com.dbeaver.db.dynamodb.ui.DynamoDBMessages;
import com.dbeaver.db.dynamodb.ui.DynamoDBUIActivator;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.ICompositeDialogPage;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.regions.Region;

public class DynamoDBConnectionPage
extends ConnectionPageAbstract
implements ICompositeDialogPage {
    private static ImageDescriptor logoImage = DynamoDBUIActivator.getImageDescriptor("icons/dynamodb_logo.png");
    private static final int AUTH_TYPE_STATIC = 0;
    private static final int AUTH_TYPE_PROFILE = 1;
    private Composite settingsGroup;
    private Combo regionCombo;
    private Combo credentialProviderCombo;
    private Combo profileCombo;
    private Text accessKeyText;
    private Text secretKeyText;
    private boolean activated;
    private Composite profileSettingsGroup;
    private Composite staticSettingsGroup;
    private Text endpointText;
    private DynamoServerType serverType = DynamoServerType.AWS;

    public void createControl(Composite composite) {
        this.setImageDescriptor(logoImage);
        this.createGeneralTab(composite);
        this.setControl((Control)this.settingsGroup);
    }

    private Composite createGeneralTab(Composite parent) {
        ModifyListener textListener = e -> {
            if (this.activated) {
                this.saveAndUpdate();
            }
        };
        this.settingsGroup = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        this.settingsGroup.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        this.settingsGroup.setLayoutData((Object)gd);
        new Label(this.settingsGroup, 0).setText(DynamoDBMessages.connection_page_text_dynamo_support);
        Group serverGroup = UIUtils.createControlGroup((Composite)this.settingsGroup, (String)DynamoDBMessages.connection_page_control_group_server, (int)2, (int)768, (int)-1);
        UIUtils.createControlLabel((Composite)serverGroup, (String)"Type");
        Composite typePanel = UIUtils.createComposite((Composite)serverGroup, (int)2);
        SelectionAdapter serverTypeListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DynamoDBConnectionPage.this.serverType = (DynamoServerType)e.widget.getData();
                DynamoDBConnectionPage.this.endpointText.setEnabled(DynamoDBConnectionPage.this.serverType == DynamoServerType.STANDALONE);
                if (DynamoDBConnectionPage.this.activated) {
                    DynamoDBConnectionPage.this.saveAndUpdate();
                }
            }
        };
        Button conTypeAWSRadio = UIUtils.createRadioButton((Composite)typePanel, (String)"AWS", (Object)DynamoServerType.AWS, (SelectionListener)serverTypeListener);
        Button conTypeStandaloneRadio = UIUtils.createRadioButton((Composite)typePanel, (String)"Standalone", (Object)DynamoServerType.STANDALONE, (SelectionListener)serverTypeListener);
        if (this.serverType == DynamoServerType.AWS) {
            conTypeAWSRadio.setSelection(true);
        } else {
            conTypeStandaloneRadio.setSelection(true);
        }
        this.regionCombo = UIUtils.createLabelCombo((Composite)serverGroup, (String)"AWS Region", (int)2052);
        this.regionCombo.setLayoutData((Object)new GridData(32));
        this.regionCombo.addModifyListener(textListener);
        for (Region region : Region.regions()) {
            this.regionCombo.add(region.id());
        }
        this.regionCombo.setText(Region.US_EAST_1.id());
        this.endpointText = UIUtils.createLabelText((Composite)serverGroup, (String)"Endpoint", (String)"", (int)2048);
        this.endpointText.setLayoutData((Object)new GridData(768));
        this.endpointText.addModifyListener(textListener);
        this.endpointText.setText("http://localhost:8000");
        Group securityGroup = UIUtils.createControlGroup((Composite)this.settingsGroup, (String)DynamoDBMessages.connection_page_control_group_security, (int)2, (int)32, (int)-1);
        this.credentialProviderCombo = UIUtils.createLabelCombo((Composite)securityGroup, (String)"Auth type", (int)2052);
        this.credentialProviderCombo.setLayoutData((Object)new GridData(32));
        this.credentialProviderCombo.addModifyListener(textListener);
        this.credentialProviderCombo.add("Access key");
        this.credentialProviderCombo.add("Profile");
        this.credentialProviderCombo.select(0);
        this.credentialProviderCombo.setEnabled(false);
        this.credentialProviderCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DynamoDBConnectionPage.this.updateCredentialsControls();
            }
        });
        this.profileSettingsGroup = UIUtils.createComposite((Composite)securityGroup, (int)2);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.profileSettingsGroup.setLayoutData((Object)gd);
        this.profileCombo = UIUtils.createLabelCombo((Composite)this.profileSettingsGroup, (String)"Profile Name", (int)2052);
        gd = new GridData(32);
        gd.widthHint = 300;
        this.profileCombo.setLayoutData((Object)gd);
        this.profileCombo.addModifyListener(textListener);
        this.profileCombo.add("<N/A>");
        this.profileCombo.select(0);
        this.staticSettingsGroup = UIUtils.createComposite((Composite)securityGroup, (int)2);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.staticSettingsGroup.setLayoutData((Object)gd);
        this.accessKeyText = UIUtils.createLabelText((Composite)this.staticSettingsGroup, (String)"Access Key", (String)"", (int)2048);
        gd = new GridData(32);
        gd.widthHint = 300;
        this.accessKeyText.setLayoutData((Object)gd);
        this.accessKeyText.addModifyListener(textListener);
        this.secretKeyText = UIUtils.createLabelText((Composite)this.staticSettingsGroup, (String)"Secret Key", (String)"", (int)0x400800);
        gd = new GridData(32);
        gd.widthHint = 300;
        this.secretKeyText.setLayoutData((Object)gd);
        this.secretKeyText.addModifyListener(textListener);
        this.createSavePasswordButton((Composite)securityGroup, 2);
        return this.settingsGroup;
    }

    private void updateCredentialsControls() {
        switch (this.credentialProviderCombo.getSelectionIndex()) {
            case 0: {
                this.showControl((Control)this.profileSettingsGroup, false);
                this.showControl((Control)this.staticSettingsGroup, true);
                break;
            }
            case 1: {
                this.showControl((Control)this.profileSettingsGroup, true);
                this.showControl((Control)this.staticSettingsGroup, false);
            }
        }
        this.settingsGroup.layout(true, true);
    }

    private void showControl(Control control, boolean show) {
        ((GridData)control.getLayoutData()).exclude = !show;
        control.setVisible(show);
    }

    public boolean isComplete() {
        if (this.regionCombo == null) {
            return false;
        }
        if (this.regionCombo.getText().isEmpty() || this.credentialProviderCombo.getSelectionIndex() < 0) {
            return false;
        }
        if (this.serverType == DynamoServerType.STANDALONE) {
            return !this.endpointText.getText().isEmpty();
        }
        if (this.credentialProviderCombo.getSelectionIndex() == 0) {
            return !this.accessKeyText.getText().isEmpty() && !this.secretKeyText.getText().isEmpty();
        }
        return !this.profileCombo.getText().isEmpty();
    }

    public void loadSettings() {
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        String serverTypeStr = connectionInfo.getProviderProperty("serverType");
        this.serverType = (DynamoServerType)CommonUtils.valueOf(DynamoServerType.class, (String)serverTypeStr, (Enum)DynamoServerType.AWS);
        String regionName = connectionInfo.getProviderProperty("regionName");
        if (!CommonUtils.isEmpty((String)regionName)) {
            this.regionCombo.setText(regionName);
        }
        if (!CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
            this.endpointText.setText(connectionInfo.getHostName());
        }
        this.endpointText.setEnabled(this.serverType == DynamoServerType.STANDALONE);
        String credProvider = connectionInfo.getProviderProperty("credentialsProvider");
        if ("profile".equals(credProvider)) {
            this.credentialProviderCombo.select(1);
        } else {
            this.credentialProviderCombo.select(0);
        }
        this.profileCombo.setText(CommonUtils.notEmpty((String)connectionInfo.getProviderProperty("profileName")));
        this.accessKeyText.setText(CommonUtils.notEmpty((String)connectionInfo.getUserName()));
        this.secretKeyText.setText(CommonUtils.notEmpty((String)connectionInfo.getUserPassword()));
        super.loadSettings();
        this.updateCredentialsControls();
        this.activated = true;
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        connectionInfo.setProviderProperty("serverType", this.serverType.name());
        connectionInfo.setProviderProperty("regionName", this.regionCombo.getText());
        if (this.serverType == DynamoServerType.STANDALONE) {
            connectionInfo.setHostName(this.endpointText.getText());
        } else {
            connectionInfo.setHostName(null);
        }
        switch (this.credentialProviderCombo.getSelectionIndex()) {
            case 0: {
                connectionInfo.setProviderProperty("credentialsProvider", "static");
                connectionInfo.removeProviderProperty("profileName");
                connectionInfo.setUserName(this.accessKeyText.getText());
                connectionInfo.setUserPassword(this.secretKeyText.getText());
                break;
            }
            case 1: {
                connectionInfo.setProviderProperty("credentialsProvider", "profile");
                connectionInfo.setProviderProperty("profileName", this.profileCombo.getText());
                break;
            }
            default: {
                connectionInfo.removeProviderProperty("credentialsProvider");
            }
        }
        super.saveSettings(dataSource);
    }

    private void saveAndUpdate() {
        this.site.updateButtons();
    }

    public IDialogPage[] getSubPages(boolean extrasOnly) {
        return new IDialogPage[0];
    }
}

