/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.cassandra.model;

import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPTransactionIsolation;
import org.jkiss.dbeaver.model.impl.BaseDataSourceInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class CasDataSourceInfo
extends BaseDataSourceInfo {
    private static final Log log = Log.getLog(CasDataSourceInfo.class);
    public static final String DRIVER_BUNDLE_NAME = "org.jkiss.bundle.cassandra";
    private final Metadata metadata;

    public CasDataSourceInfo(Metadata metadata) {
        this.metadata = metadata;
    }

    public boolean isReadOnlyData() {
        return false;
    }

    public boolean isReadOnlyMetaData() {
        return false;
    }

    public String getDatabaseProductName() {
        return "Cassandra";
    }

    public String getDatabaseProductVersion() {
        StringBuilder version = new StringBuilder();
        HashSet<String> visitedVersions = new HashSet<String>();
        Set allHosts = this.metadata.getAllHosts();
        for (Host host : allHosts) {
            String hostVersion = host.getCassandraVersion().toString();
            if (visitedVersions.contains(hostVersion)) continue;
            visitedVersions.add(hostVersion);
            if (version.length() > 0) {
                version.append(",");
            }
            version.append(hostVersion);
        }
        return version.toString();
    }

    public Map<String, Object> getDatabaseProductDetails() {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
        ArrayList hosts = new ArrayList();
        details.put("Cluster", this.metadata.getClusterName());
        details.put("Partitioner", this.metadata.getPartitioner());
        details.put("Hosts", hosts);
        Set allHosts = this.metadata.getAllHosts();
        for (Host host : allHosts) {
            LinkedHashMap<String, Object> hostInfo = new LinkedHashMap<String, Object>();
            hosts.add(hostInfo);
            hostInfo.put("ID", host.getHostId());
            hostInfo.put("Address", host.getAddress());
            hostInfo.put("Cassandra Version", host.getCassandraVersion());
            hostInfo.put("Schema Version", host.getSchemaVersion());
            hostInfo.put("Datacenter", host.getDatacenter());
            hostInfo.put("Rack", host.getRack());
        }
        return details;
    }

    private Bundle getDriverBundle() {
        Bundle bundle = Platform.getBundle((String)DRIVER_BUNDLE_NAME);
        if (bundle == null) {
            throw new IllegalStateException("Cassandra driver bundle 'org.jkiss.bundle.cassandra' not found");
        }
        return bundle;
    }

    public Version getDatabaseVersion() {
        return this.getDriverBundle().getVersion();
    }

    public String getDriverName() {
        return (String)this.getDriverBundle().getHeaders().get("Bundle-Name");
    }

    public String getDriverVersion() {
        return this.getDriverBundle().getVersion().toString();
    }

    public String getSchemaTerm() {
        return null;
    }

    public String getProcedureTerm() {
        return null;
    }

    public String getCatalogTerm() {
        return "Keyspace";
    }

    public boolean supportsTransactions() {
        return false;
    }

    public boolean supportsSavepoints() {
        return false;
    }

    public boolean supportsReferentialIntegrity() {
        return false;
    }

    public boolean supportsIndexes() {
        return true;
    }

    public boolean supportsStoredCode() {
        return false;
    }

    public Collection<DBPTransactionIsolation> getSupportedTransactionsIsolation() {
        return null;
    }

    public boolean supportsBatchUpdates() {
        return false;
    }

    public boolean supportsResultSetLimit() {
        return false;
    }

    public boolean supportsResultSetScroll() {
        return false;
    }

    public boolean isDynamicMetadata() {
        return false;
    }

    public boolean supportsMultipleResults() {
        return false;
    }
}

