/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.google.bigtable.ui.views;

import com.dbeaver.db.google.bigtable.ui.BigTableUIActivator;
import com.dbeaver.db.google.common.ui.views.GoogleCloudConnectionPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class BigTableConnectionPage
extends GoogleCloudConnectionPage {
    private static ImageDescriptor logoImage = BigTableUIActivator.getImageDescriptor("icons/bigtable_logo.png");
    private Combo instanceCombo;

    @Override
    public void createControl(Composite composite) {
        this.setImageDescriptor(logoImage);
        super.createControl(composite);
    }

    @Override
    protected void createDatabaseGroup(Composite composite) {
        this.instanceCombo = UIUtils.createLabelCombo((Composite)composite, (String)"Instance", (String)"BigTable instance (optional)", (int)4);
        GridData gd = new GridData(32);
        gd.widthHint = 300;
        this.instanceCombo.setLayoutData((Object)gd);
    }

    @Override
    public boolean isComplete() {
        return super.isComplete();
    }

    @Override
    public void loadSettings() {
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        this.instanceCombo.setText(CommonUtils.toString((Object)connectionInfo.getServerName()));
        super.loadSettings();
    }

    @Override
    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        connectionInfo.setServerName(this.instanceCombo.getText());
        super.saveSettings(dataSource);
    }
}

