/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cachedb.sqlgenerator;

import liquibase.database.Database;
import liquibase.ext.cachedb.database.CacheDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.SetNullableGenerator;
import liquibase.statement.core.SetNullableStatement;
import liquibase.structure.DatabaseObject;

public class SetNullableGeneratorCache
extends SetNullableGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(SetNullableStatement statement, Database database) {
        return database instanceof CacheDatabase;
    }

    public Sql[] generateSql(SetNullableStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String nullableString = statement.isNullable() ? " NULL" : " NOT NULL";
        String sql = "ALTER TABLE " + database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName()) + " ALTER COLUMN  " + database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), statement.getColumnName()) + nullableString;
        return new Sql[]{new UnparsedSql(sql, new DatabaseObject[]{this.getAffectedColumn(statement)})};
    }
}

