/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.virtual;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.virtual.DBVColorOverride;
import org.jkiss.dbeaver.model.virtual.DBVContainer;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityAttribute;
import org.jkiss.dbeaver.model.virtual.DBVEntityConstraint;
import org.jkiss.dbeaver.model.virtual.DBVEntityConstraintColumn;
import org.jkiss.dbeaver.model.virtual.DBVEntityForeignKey;
import org.jkiss.dbeaver.model.virtual.DBVEntityForeignKeyColumn;
import org.jkiss.dbeaver.model.virtual.DBVModel;
import org.jkiss.dbeaver.model.virtual.DBVModelSerializer;
import org.jkiss.dbeaver.model.virtual.DBVTransformSettings;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

class DBVModelSerializerModern
implements DBVModelSerializer {
    private static final Log log = Log.getLog(DBVModelSerializerModern.class);

    DBVModelSerializerModern() {
    }

    static void serializeContainer(DBRProgressMonitor monitor, JsonWriter json, DBVContainer object) throws IOException, DBException {
        if (!object.hasValuableData()) {
            return;
        }
        if (object instanceof DBVModel) {
            json.name(((DBVModel)object).getId());
        } else {
            json.name(object.getName());
        }
        json.beginObject();
        JSONUtils.serializeProperties(json, "@properties", object.getProperties());
        for (DBVEntity entity : object.getEntities()) {
            if (!entity.hasValuableData()) continue;
            DBVModelSerializerModern.serializeEntity(monitor, json, entity);
        }
        for (DBVContainer container : object.getContainers()) {
            DBVModelSerializerModern.serializeContainer(monitor, json, container);
        }
        json.endObject();
    }

    private static void serializeEntity(DBRProgressMonitor monitor, JsonWriter json, DBVEntity entity) throws IOException, DBException {
        json.name(":" + entity.getName());
        json.beginObject();
        JSONUtils.fieldNE(json, "description", entity.getDescriptionColumnNames());
        JSONUtils.serializeProperties(json, "properties", entity.getProperties());
        if (!CommonUtils.isEmpty(entity.getEntityAttributes())) {
            json.name("attributes");
            json.beginObject();
            for (DBVEntityAttribute attr : entity.getEntityAttributes()) {
                if (!attr.hasValuableData()) continue;
                json.name(attr.getName());
                json.beginObject();
                DBVTransformSettings transformSettings = attr.getTransformSettings();
                if (transformSettings != null && transformSettings.hasValuableData()) {
                    json.name("transforms");
                    json.beginObject();
                    JSONUtils.fieldNE(json, "custom", transformSettings.getCustomTransformer());
                    JSONUtils.serializeStringList(json, "include", transformSettings.getIncludedTransformers());
                    JSONUtils.serializeStringList(json, "exclude", transformSettings.getExcludedTransformers());
                    JSONUtils.serializeProperties(json, "properties", transformSettings.getTransformOptions());
                    json.endObject();
                }
                JSONUtils.serializeProperties(json, "properties", attr.getProperties());
                json.endObject();
            }
            json.endObject();
        }
        if (!CommonUtils.isEmpty(entity.getConstraints())) {
            json.name("constraints");
            json.beginObject();
            for (DBVEntityConstraint c : entity.getConstraints()) {
                if (!c.hasAttributes()) continue;
                json.name(c.getName());
                json.beginObject();
                JSONUtils.field(json, "type", c.getConstraintType().getId());
                List<DBVEntityConstraintColumn> attrRefs = c.getAttributeReferences(null);
                if (!CommonUtils.isEmpty(attrRefs)) {
                    json.name("attributes");
                    json.beginArray();
                    for (DBVEntityConstraintColumn dBVEntityConstraintColumn : attrRefs) {
                        json.value(dBVEntityConstraintColumn.getAttributeName());
                    }
                    json.endArray();
                }
                json.endObject();
            }
            json.endObject();
        }
        if (!CommonUtils.isEmpty(entity.getForeignKeys())) {
            json.name("foreign-keys");
            json.beginArray();
            for (DBVEntityForeignKey fk : CommonUtils.safeCollection(entity.getForeignKeys())) {
                json.beginObject();
                JSONUtils.field(json, "entity", fk.getRefEntityId());
                JSONUtils.field(json, "constraint", fk.getRefConstraintId());
                List<DBVEntityForeignKeyColumn> refAttrs = fk.getAttributeReferences(null);
                if (!CommonUtils.isEmpty(refAttrs)) {
                    json.name("attributes");
                    json.beginObject();
                    for (DBVEntityForeignKeyColumn dBVEntityForeignKeyColumn : refAttrs) {
                        json.name(dBVEntityForeignKeyColumn.getAttributeName());
                        json.value(dBVEntityForeignKeyColumn.getRefAttributeName());
                    }
                    json.endObject();
                }
                json.endObject();
            }
            json.endArray();
        }
        if (!CommonUtils.isEmpty(entity.getColorOverrides())) {
            json.name("colors");
            json.beginArray();
            for (DBVColorOverride color : entity.getColorOverrides()) {
                json.beginObject();
                JSONUtils.field(json, "name", color.getAttributeName());
                JSONUtils.field(json, "operator", color.getOperator().name());
                if (color.isRange()) {
                    JSONUtils.field(json, "range", true);
                }
                if (color.isSingleColumn()) {
                    JSONUtils.field(json, "single-column", true);
                }
                JSONUtils.fieldNE(json, "foreground", color.getColorForeground());
                JSONUtils.fieldNE(json, "foreground2", color.getColorForeground2());
                JSONUtils.fieldNE(json, "background", color.getColorBackground());
                JSONUtils.fieldNE(json, "background2", color.getColorBackground2());
                if (!ArrayUtils.isEmpty((Object[])color.getAttributeValues())) {
                    JSONUtils.serializeObjectList(json, "values", Arrays.asList(color.getAttributeValues()));
                }
                json.endObject();
            }
            json.endArray();
        }
        json.endObject();
    }
}

