/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;

public abstract class AbstractContextDescriptor
extends AbstractDescriptor {
    private static final String OBJECT_TYPE = "objectType";
    private List<AbstractDescriptor.ObjectType> objectTypes = new ArrayList<AbstractDescriptor.ObjectType>();

    public AbstractContextDescriptor(IConfigurationElement config) {
        super(config.getContributor().getName());
        if (config != null) {
            String objectType = config.getAttribute(OBJECT_TYPE);
            if (objectType != null) {
                this.objectTypes.add((AbstractDescriptor)this.new AbstractDescriptor.ObjectType(objectType));
            }
            IConfigurationElement[] iConfigurationElementArray = config.getChildren(OBJECT_TYPE);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement typeCfg = iConfigurationElementArray[n2];
                this.objectTypes.add((AbstractDescriptor)this.new AbstractDescriptor.ObjectType(typeCfg));
                ++n2;
            }
        }
    }

    public AbstractContextDescriptor(String pluginId) {
        super(pluginId);
    }

    public boolean hasObjectTypes() {
        return !this.objectTypes.isEmpty();
    }

    public List<AbstractDescriptor.ObjectType> getObjectTypes() {
        return this.objectTypes;
    }

    public boolean appliesTo(DBPObject object) {
        return this.appliesTo(object, null);
    }

    public boolean appliesTo(DBPObject object, Object context) {
        if ((object = DBUtils.getPublicObject(object)) == null) {
            return false;
        }
        Object adapted = this.adaptType(object);
        for (AbstractDescriptor.ObjectType objectType : this.objectTypes) {
            if (!objectType.appliesTo(object, context) && (adapted == null || !objectType.appliesTo(adapted, context))) continue;
            return true;
        }
        return false;
    }

    protected Object adaptType(DBPObject object) {
        return null;
    }
}

