/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.redis.exec;

import com.dbeaver.ee.redis.RedisUtils;
import com.dbeaver.ee.redis.exec.RedisBaseResultSet;
import com.dbeaver.ee.redis.exec.RedisBaseStatement;
import com.dbeaver.ee.redis.exec.RedisResultSetSimple;
import com.dbeaver.ee.redis.exec.RedisSession;
import com.dbeaver.ee.redis.model.RedisKeyType;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import redis.clients.jedis.commands.JedisClusterCommands;
import redis.clients.jedis.commands.JedisCommands;

public class RedisKeySizeStatement
extends RedisBaseStatement {
    private static final Log log = Log.getLog(RedisKeySizeStatement.class);
    @NotNull
    private final String keyName;
    @NotNull
    private final RedisKeyType keyType;
    private long keySize;

    public RedisKeySizeStatement(@NotNull RedisSession session, @NotNull String key, @NotNull RedisKeyType keyType) {
        super(session, "SELECT count(*) FROM " + key);
        this.keyName = key;
        this.keyType = keyType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean executeStatement() throws DBCException {
        if (this.session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteBegin((DBCStatement)this);
        }
        RedisUtils.selectCurDatabase(this.getSession());
        try {
            if (this.session.supportsCommands(JedisCommands.class)) {
                JedisCommands jedis = this.getSession().getCommands(JedisCommands.class);
                switch (this.keyType) {
                    case string: {
                        this.keySize = 1L;
                        return true;
                    }
                    case hash: {
                        this.keySize = jedis.hlen(this.keyName);
                        return true;
                    }
                    case set: {
                        this.keySize = jedis.scard(this.keyName);
                        return true;
                    }
                    case zset: {
                        this.keySize = jedis.zcount(this.keyName, Double.MIN_VALUE, Double.MAX_VALUE);
                        return true;
                    }
                    case list: {
                        this.keySize = jedis.llen(this.keyName);
                    }
                }
                return true;
            }
            JedisClusterCommands jedis = this.getSession().getCommands(JedisClusterCommands.class);
            switch (this.keyType) {
                case string: {
                    this.keySize = 1L;
                    return true;
                }
                case hash: {
                    this.keySize = jedis.hlen(this.keyName);
                    return true;
                }
                case set: {
                    this.keySize = jedis.scard(this.keyName);
                    return true;
                }
                case zset: {
                    this.keySize = jedis.zcount(this.keyName, Double.MIN_VALUE, Double.MAX_VALUE);
                    return true;
                }
                case list: {
                    this.keySize = jedis.llen(this.keyName);
                    return true;
                }
            }
            return true;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            if (this.session.isLoggingEnabled()) {
                QMUtils.getDefaultHandler().handleStatementExecuteEnd((DBCStatement)this, -1L, this.executeError);
            }
        }
    }

    public RedisBaseResultSet openResultSet() throws DBCException {
        return new RedisResultSetSimple(this, this.keySize, this.offset);
    }

    public long getKeySize() {
        return this.keySize;
    }
}

