/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.google.bigtable.data;

import com.dbeaver.db.google.bigtable.BigTableUtils;
import com.dbeaver.db.google.bigtable.model.BigTableDataSource;
import com.dbeaver.db.google.bigtable.model.BigTableTable;
import com.dbeaver.ee.model.document.DBAbstractDocument;
import com.dbeaver.ee.model.document.DBMapValue;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowCell;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.utils.CommonUtils;

public class BigTableDocument
extends DBAbstractDocument<BigTableDataSource, Row> {
    private static final Log log = Log.getLog(BigTableDocument.class);
    private static Gson JSON_BUILDER = new GsonBuilder().setPrettyPrinting().setDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").registerTypeAdapter(RowCell.class, (Object)new RowCellJsonConverter()).registerTypeAdapter(ByteString.class, (Object)new ByteStringJsonConverter()).serializeNulls().create();
    @Nullable
    private BigTableTable table;

    public BigTableDocument(@NotNull BigTableDataSource dataSource, @Nullable BigTableTable table, Row row) {
        super((DBPDataSource)dataSource, (Object)row);
        this.table = table;
    }

    public Object getDocumentProperty(String name) {
        switch (name) {
            case "id": {
                return ((Row)this.rawValue).getKey().toStringUtf8();
            }
        }
        return null;
    }

    @NotNull
    public String getDocumentContentType() {
        return "text/json";
    }

    protected DBMapValue<BigTableDataSource> makeRawMap() {
        return BigTableUtils.makeRawMap((BigTableDataSource)this.dataSource, this.table, (Row)this.rawValue);
    }

    public void serializeDocument(@NotNull DBRProgressMonitor monitor, @NotNull OutputStream stream, Charset charset) throws DBException, IOException {
        String json = JSON_BUILDER.toJson(this.getRawValue());
        stream.write(json.getBytes(charset));
    }

    public void updateDocument(@NotNull DBRProgressMonitor monitor, @NotNull InputStream stream, Charset charset) throws DBException, IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStreamReader reader = new InputStreamReader(stream);){
            this.rawMap = new DBMapValue(this.dataSource, (Map)JSON_BUILDER.fromJson((Reader)reader, Map.class));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public BigTableDocument copy() {
        return new BigTableDocument((BigTableDataSource)this.dataSource, this.table, (Row)this.rawValue);
    }

    @NotNull
    public DBSAttributeBase[] getAttributes() {
        List cells = ((Row)this.rawValue).getCells();
        ArrayList<DBAbstractDocument.DocumentAttribute> attrs = new ArrayList<DBAbstractDocument.DocumentAttribute>();
        attrs.add(new DocumentAttributeRowKey());
        int cfIndex = 1;
        for (RowCell cell : cells) {
            DocumentAttributeColumnFamily cfAttr = null;
            for (DBAbstractDocument.DocumentAttribute attr : attrs) {
                if (!(attr instanceof DocumentAttributeColumnFamily) || !attr.getName().equals(cell.getFamily())) continue;
                cfAttr = (DocumentAttributeColumnFamily)attr;
                break;
            }
            if (cfAttr != null) continue;
            cfAttr = new DocumentAttributeColumnFamily(cfIndex++, cell.getFamily());
            attrs.add(cfAttr);
        }
        return attrs.toArray(new DBSAttributeBase[0]);
    }

    public Object getAttributeValue(@NotNull DBSAttributeBase attribute) throws DBCException {
        if (attribute instanceof DocumentAttributeRowKey) {
            return ((Row)this.rawValue).getKey().toStringUtf8();
        }
        if (attribute instanceof DocumentAttributeColumnFamily) {
            LinkedHashMap<String, String> cfMap = new LinkedHashMap<String, String>();
            for (RowCell cell : ((Row)this.rawValue).getCells(attribute.getName())) {
                cfMap.put(cell.getQualifier().toStringUtf8(), cell.getValue().toStringUtf8());
            }
            return new DBMapValue((DBPDataSource)((BigTableDataSource)this.dataSource), cfMap);
        }
        if (attribute instanceof DocumentAttributeCell) {
            List cfCells = ((Row)this.rawValue).getCells(((DocumentAttributeCell)attribute).getColumnFamily().getName(), attribute.getName());
            if (cfCells.isEmpty()) {
                return null;
            }
            return ((RowCell)cfCells.get(0)).getValue().toStringUtf8();
        }
        log.debug((Object)("Wrong attribute: " + attribute));
        return null;
    }

    public void setAttributeValue(@NotNull DBSAttributeBase attribute, Object value) {
    }

    public String toString() {
        return JSON_BUILDER.toJson(this.getRawValue());
    }

    public static class ByteStringJsonConverter
    implements JsonSerializer<ByteString>,
    JsonDeserializer<ByteString> {
        public JsonElement serialize(ByteString src, Type srcType, JsonSerializationContext context) {
            return new JsonPrimitive(src.toStringUtf8());
        }

        public ByteString deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            return null;
        }
    }

    private static class DocumentAttributeCell
    extends DBAbstractDocument.DocumentAttribute {
        DocumentAttributeColumnFamily cf;

        public DocumentAttributeCell(DocumentAttributeColumnFamily cf, int index, String name) {
            super(index, name, DBPDataKind.OBJECT);
            this.cf = cf;
        }

        public DocumentAttributeColumnFamily getColumnFamily() {
            return this.cf;
        }
    }

    private static class DocumentAttributeColumnFamily
    extends DBAbstractDocument.DocumentAttribute {
        DocumentAttributeColumnFamily(int index, String name) {
            super(index, name, DBPDataKind.DOCUMENT);
        }
    }

    private static class DocumentAttributeRowKey
    extends DBAbstractDocument.DocumentAttribute {
        DocumentAttributeRowKey() {
            super(0, "RowKey");
        }
    }

    public static class RowCellJsonConverter
    implements JsonSerializer<RowCell>,
    JsonDeserializer<RowCell> {
        public JsonElement serialize(RowCell src, Type srcType, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("family", src.getFamily());
            jsonObject.addProperty("qualifier", src.getQualifier().toStringUtf8());
            if (!CommonUtils.isEmpty((Collection)src.getLabels())) {
                JsonArray labelsArray = new JsonArray();
                for (String label : src.getLabels()) {
                    labelsArray.add(label);
                }
                jsonObject.add("labels", (JsonElement)labelsArray);
            }
            jsonObject.addProperty("value", src.getValue().toStringUtf8());
            return jsonObject;
        }

        public RowCell deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            return null;
        }
    }
}

