/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mssql.data.spatial;

import com.dbeaver.db.mssql.data.spatial.reader.SqlServerBinaryReader;
import java.io.IOException;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.data.gis.handlers.GISGeometryValueHandler;
import org.jkiss.dbeaver.model.data.DBDValueBinder;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.gis.DBGeometry;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.locationtech.jts.geom.Geometry;

public class SQLServerGeometryValueHandler
extends GISGeometryValueHandler
implements DBDValueBinder {
    protected Geometry convertGeometryFromBinaryFormat(DBCSession session, byte[] object) throws DBCException {
        SqlServerBinaryReader binaryReader = new SqlServerBinaryReader();
        try {
            return binaryReader.read(object);
        }
        catch (IOException e) {
            throw new DBCException((Throwable)e, session.getDataSource());
        }
    }

    protected void bindGeometryParameter(@NotNull JDBCSession session, @NotNull JDBCPreparedStatement statement, int paramIndex, @NotNull Geometry value) throws SQLException, DBCException {
        statement.setString(paramIndex, value.toString());
    }

    protected byte[] convertGeometryToBinaryFormat(DBCSession session, Geometry geometry) throws DBCException {
        throw new DBCException("Saving in SQL Server binary format not supported yet");
    }

    public String makeQueryBind(DBSAttributeBase attribute, Object value) throws DBCException {
        int srid = 0;
        if (value instanceof DBGeometry) {
            srid = ((DBGeometry)value).getSRID();
        } else if (value instanceof Geometry) {
            srid = ((Geometry)value).getSRID();
        }
        return "geometry::STGeomFromText(?," + srid + ")";
    }
}

