/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.loops.position;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.p3order.counting.BinaryIndexedTree;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopComponent;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopEdge;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNode;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNodeSide;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopOpposingSegment;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopPort;
import org.eclipse.elk.alg.layered.p5edges.loops.position.AbstractSelfLoopPortPositioner;
import org.eclipse.elk.core.options.PortSide;

public class FixedOrderSelfLoopPortPositioner
extends AbstractSelfLoopPortPositioner {
    private SelfLoopNode slNode;

    @Override
    public void position(LNode node) {
        this.slNode = (SelfLoopNode)node.getProperty(InternalProperties.SELFLOOP_NODE_REPRESENTATION);
        List<SelfLoopComponent> components = this.slNode.getSelfLoopComponents();
        ArrayList<SelfLoopPort> allPorts = new ArrayList<SelfLoopPort>();
        for (SelfLoopComponent component : components) {
            List<SelfLoopPort> ports = component.getPorts();
            allPorts.addAll(ports);
        }
        allPorts.sort(ORIGINAL_INDEX_PORT_COMPARATOR);
        int i = 0;
        while (i < allPorts.size()) {
            SelfLoopPort port = (SelfLoopPort)allPorts.get(i);
            port.setOriginalIndex(i);
            this.slNode.appendPort(port, port.getPortSide());
            ++i;
        }
        this.minimizeSides(components);
        this.minimizeCrossings(components);
        for (SelfLoopComponent component : components) {
            Map<PortSide, Map<SelfLoopEdge, SelfLoopOpposingSegment>> componentSegments = SelfLoopOpposingSegment.create(component, this.slNode);
            for (SelfLoopNodeSide side : this.slNode.getSides()) {
                Map<SelfLoopEdge, SelfLoopOpposingSegment> segmentsOfSide = componentSegments.get(side.getSide());
                if (segmentsOfSide == null) continue;
                side.getOpposingSegments().putAll(segmentsOfSide);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void minimizeSides(List<SelfLoopComponent> components) {
        for (SelfLoopComponent component : components) {
            ports = component.getPorts();
            portWithGreatestDistanceToRight = ports.get(0);
            portDistance = 0;
            greatestDistance = 0;
            i = 0;
            while (i < ports.size()) {
                block7: {
                    currentPort = ports.get(i);
                    nextPort = ports.get((i + 1) % ports.size());
                    currentSide = currentPort.getPortSide();
                    currentSideNodeRep = this.slNode.getNodeSide(currentSide);
                    currentPortSideIndex = currentSideNodeRep.getPorts().indexOf(currentPort);
                    nextSide = nextPort.getPortSide();
                    nextSideNodeRep = this.slNode.getNodeSide(nextSide);
                    nextPortSideIndex = nextSideNodeRep.getPorts().indexOf(nextPort);
                    newPortDistance = 0;
                    sideDistance = 0;
                    if (currentSide != nextSide || currentPort.getOriginalIndex() <= nextPort.getOriginalIndex()) ** GOTO lbl24
                    sideDistance = this.slNode.getSides().size();
                    newPortDistance = currentSideNodeRep.getPorts().size() - currentPortSideIndex + nextPortSideIndex;
                    break block7;
lbl-1000:
                    // 1 sources

                    {
                        ++sideDistance;
                        currentSide = currentSide.right();
lbl24:
                        // 2 sources

                        ** while (currentSide != nextSide)
                    }
lbl25:
                    // 1 sources

                    v0 = newPortDistance = currentSide != nextSide ? currentSideNodeRep.getPorts().size() - currentPortSideIndex + nextPortSideIndex : nextPortSideIndex - currentPortSideIndex;
                }
                if (greatestDistance < sideDistance) {
                    greatestDistance = sideDistance;
                    portWithGreatestDistanceToRight = currentPort;
                    portDistance = newPortDistance;
                } else if (greatestDistance == sideDistance && portDistance < newPortDistance) {
                    portWithGreatestDistanceToRight = currentPort;
                    portDistance = newPortDistance;
                }
                ++i;
            }
            portWithGreatestDistanceToRightIndex = ports.indexOf(portWithGreatestDistanceToRight);
            rightIndex = portWithGreatestDistanceToRightIndex + 1 > ports.size() ? ports.size() : portWithGreatestDistanceToRightIndex + 1;
            startList = new ArrayList<SelfLoopPort>(ports.subList(0, rightIndex));
            endList = new ArrayList<SelfLoopPort>(ports.subList(rightIndex, ports.size()));
            ports.clear();
            ports.addAll(endList);
            ports.addAll(startList);
            i = 0;
            while (i < ports.size()) {
                this.setDirection(ports.get(i), i, ports.size());
                ++i;
            }
        }
    }

    private void minimizeCrossings(List<SelfLoopComponent> components) {
        int numberOfPorts = this.slNode.getNumberOfPorts();
        ArrayListMultimap componentsConfiguration = ArrayListMultimap.create();
        for (SelfLoopComponent component : components) {
            List<SelfLoopPort> ports = component.getPorts();
            int startIndex = ports.get(0).getOriginalIndex() + 1;
            int endIndex = ports.get(ports.size() - 1).getOriginalIndex() + 1;
            this.updateComponentConfiguration((Multimap<Integer, Integer>)componentsConfiguration, ports, startIndex, endIndex, numberOfPorts, true);
        }
        int previousMinimumCrossings = Integer.MAX_VALUE;
        int minimumCrossings = this.countCrossings((Multimap<Integer, Integer>)componentsConfiguration);
        while (minimumCrossings != 0 && minimumCrossings != previousMinimumCrossings) {
            previousMinimumCrossings = minimumCrossings;
            for (SelfLoopComponent component : components) {
                List<SelfLoopPort> ports = component.getPorts();
                List<SelfLoopPort> minimumRotation = new ArrayList<SelfLoopPort>(ports);
                int cnt = 0;
                while (cnt < ports.size() - 1) {
                    int previousStart = component.getPorts().get(0).getOriginalIndex() + 1;
                    int previousEnd = component.getPorts().get(component.getPorts().size() - 1).getOriginalIndex() + 1;
                    this.updateComponentConfiguration((Multimap<Integer, Integer>)componentsConfiguration, ports, previousStart, previousEnd, numberOfPorts, false);
                    List<SelfLoopPort> newRotation = this.rotate(component.getPorts());
                    component.getPorts().clear();
                    component.getPorts().addAll(newRotation);
                    int startIndex = newRotation.get(0).getOriginalIndex() + 1;
                    int endIndex = newRotation.get(newRotation.size() - 1).getOriginalIndex() + 1;
                    this.updateComponentConfiguration((Multimap<Integer, Integer>)componentsConfiguration, ports, startIndex, endIndex, numberOfPorts, true);
                    int newNumberOfCrossings = this.countCrossings((Multimap<Integer, Integer>)componentsConfiguration);
                    if (newNumberOfCrossings < minimumCrossings) {
                        minimumCrossings = newNumberOfCrossings;
                        minimumRotation = newRotation;
                        ports = newRotation;
                    }
                    component.getPorts().clear();
                    component.getPorts().addAll(minimumRotation);
                    ++cnt;
                }
            }
            for (SelfLoopComponent component : components) {
                List<SelfLoopPort> ports = component.getPorts();
                int i = 0;
                while (i < ports.size()) {
                    this.setDirection(ports.get(i), i, ports.size());
                    ++i;
                }
            }
        }
    }

    private void updateComponentConfiguration(Multimap<Integer, Integer> componentsConfiguration, List<SelfLoopPort> ports, int startIndex, int endIndex, int totalNumberOfPorts, boolean addValue) {
        if (addValue) {
            if (ports.size() != 1) {
                if (startIndex > endIndex) {
                    componentsConfiguration.put((Object)0, (Object)endIndex);
                    componentsConfiguration.put((Object)startIndex, (Object)(endIndex + totalNumberOfPorts));
                } else {
                    componentsConfiguration.put((Object)startIndex, (Object)endIndex);
                }
            } else {
                componentsConfiguration.put((Object)startIndex, (Object)(startIndex + totalNumberOfPorts));
            }
        } else if (startIndex > endIndex) {
            componentsConfiguration.remove((Object)0, (Object)endIndex);
            componentsConfiguration.remove((Object)startIndex, (Object)(endIndex + totalNumberOfPorts));
        } else {
            componentsConfiguration.remove((Object)startIndex, (Object)endIndex);
        }
    }

    private List<SelfLoopPort> rotate(List<SelfLoopPort> formerRotation) {
        ArrayList<SelfLoopPort> newRotation = new ArrayList<SelfLoopPort>();
        newRotation.addAll(formerRotation.subList(1, formerRotation.size()));
        newRotation.add(formerRotation.get(0));
        return newRotation;
    }

    private int countCrossings(Multimap<Integer, Integer> componentsConfiguration) {
        int numberOfPorts = this.slNode.getNumberOfPorts();
        BinaryIndexedTree indexTree = new BinaryIndexedTree(numberOfPorts * 2 + 1);
        ArrayDeque<Integer> ends = new ArrayDeque<Integer>();
        int crossings = 0;
        int index = 0;
        while (index < numberOfPorts * 2 + 1) {
            indexTree.removeAll(index);
            Collection endPositions = componentsConfiguration.get((Object)index);
            Iterator iterator = endPositions.iterator();
            while (iterator.hasNext()) {
                int endPosition = (Integer)iterator.next();
                if (endPosition <= index) continue;
                crossings += indexTree.rank(endPosition);
                ends.push(endPosition);
            }
            while (!ends.isEmpty()) {
                indexTree.add((Integer)ends.pop());
            }
            ++index;
        }
        return crossings;
    }
}

