/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.jna;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.firebirdsql.gds.ng.jna.AbstractNativeDatabaseFactory;
import org.firebirdsql.jna.fbclient.FbClientLibrary;
import org.firebirdsql.jna.fbclient.WinFbClientLibrary;

public final class FbClientDatabaseFactory
extends AbstractNativeDatabaseFactory {
    private static final FbClientDatabaseFactory INSTANCE = new FbClientDatabaseFactory();

    @Override
    protected FbClientLibrary getClientLibrary() {
        return ClientHolder.clientLibrary;
    }

    public static FbClientDatabaseFactory getInstance() {
        return INSTANCE;
    }

    private static final class ClientHolder {
        private static final FbClientLibrary clientLibrary = ClientHolder.syncWrapIfNecessary(ClientHolder.initClientLibrary());

        private ClientHolder() {
        }

        private static FbClientLibrary initClientLibrary() {
            if (Platform.isWindows()) {
                return (FbClientLibrary)Native.loadLibrary((String)"fbclient", WinFbClientLibrary.class);
            }
            return (FbClientLibrary)Native.loadLibrary((String)"fbclient", FbClientLibrary.class);
        }

        private static FbClientLibrary syncWrapIfNecessary(FbClientLibrary clientLibrary) {
            if ("true".equalsIgnoreCase(ClientHolder.getSystemPropertyPrivileged("org.firebirdsql.jna.syncWrapNativeLibrary"))) {
                return (FbClientLibrary)Native.synchronizedLibrary((Library)clientLibrary);
            }
            return clientLibrary;
        }

        private static String getSystemPropertyPrivileged(final String propertyName) {
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(propertyName);
                }
            });
        }
    }
}

