/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.features;

import java.util.ArrayList;
import org.eclipse.graphiti.features.DefaultFeatureProviderWrapper;
import org.eclipse.graphiti.features.IAddBendpointFeature;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IDirectEditingFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureChecker;
import org.eclipse.graphiti.features.IFeatureCheckerHolder;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IMoveAnchorFeature;
import org.eclipse.graphiti.features.IMoveBendpointFeature;
import org.eclipse.graphiti.features.IMoveConnectionDecoratorFeature;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IPasteFeature;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IReconnectionFeature;
import org.eclipse.graphiti.features.IRemoveBendpointFeature;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddBendpointContext;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IDirectEditingContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.IMoveAnchorContext;
import org.eclipse.graphiti.features.context.IMoveBendpointContext;
import org.eclipse.graphiti.features.context.IMoveConnectionDecoratorContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.IPasteContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.context.IRemoveBendpointContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;

public class ConfigurableFeatureProviderWrapper
extends DefaultFeatureProviderWrapper {
    public ConfigurableFeatureProviderWrapper(IFeatureProvider innerFeatureProvider) {
        super(innerFeatureProvider);
    }

    @Override
    public IReason canAdd(IAddContext context) {
        IFeatureChecker featureChecker = this.getFeatureChecker();
        if (featureChecker == null || featureChecker.allowAdd(context)) {
            return super.canAdd(context);
        }
        return Reason.createFalseReason();
    }

    @Override
    public IReason canLayout(ILayoutContext context) {
        IFeatureChecker featureChecker = this.getFeatureChecker();
        if (featureChecker == null || featureChecker.allowLayout(context)) {
            return super.canLayout(context);
        }
        return Reason.createFalseReason();
    }

    @Override
    public IReason canUpdate(IUpdateContext context) {
        IFeatureChecker featureChecker = this.getFeatureChecker();
        if (featureChecker == null || featureChecker.allowUpdate(context)) {
            return super.canUpdate(context);
        }
        return Reason.createFalseReason();
    }

    @Override
    public IAddBendpointFeature getAddBendpointFeature(IAddBendpointContext context) {
        IFeatureChecker featureChecker = this.getFeatureChecker();
        if (featureChecker == null || featureChecker.allowAdd(context)) {
            return super.getAddBendpointFeature(context);
        }
        return null;
    }

    @Override
    public IAddFeature getAddFeature(IAddContext context) {
        IFeatureChecker featureChecker = this.getFeatureChecker();
        if (featureChecker == null || featureChecker.allowAdd(context)) {
            return super.getAddFeature(context);
        }
        return null;
    }

    @Override
    public ICreateConnectionFeature[] getCreateConnectionFeatures() {
        IFeatureChecker featureChecker = this.getFeatureChecker();
        if (featureChecker == null || featureChecker.allowCreate()) {
            return super.getCreateConnectionFeatures();
        }
        return new ICreateConnectionFeature[0];
    }

    @Override
    public ICreateFeature[] getCreateFeatures() {
        IFeatureChecker featureChecker = this.getFeatureChecker();
        if (featureChecker == null || featureChecker.allowCreate()) {
            return super.getCreateFeatures();
        }
        return new ICreateFeature[0];
    }

    @Override
    public ICustomFeature[] getCustomFeatures(ICustomContext context) {
        IFeatureChecker featureChecker = this.getFeatureChecker();
        if (featureChecker == null) {
            return super.getCustomFeatures(context);
        }
        if (featureChecker.allowCustomFeatures(context)) {
            ICustomFeature[] customFeatures = super.getCustomFeatures(context);
            return this.filterAllowedCustomFeatures(customFeatures, context);
        }
        return new ICustomFeature[0];
    }

    private ICustomFeature[] filterAllowedCustomFeatures(ICustomFeature[] features, IContext context) {
        ArrayList<ICustomFeature> retList = new ArrayList<ICustomFeature>();
        int i = 0;
        while (i < features.length) {
            ICustomFeature feature = features[i];
            if (this.getFeatureChecker().allow(feature, context)) {
                retList.add(feature);
            }
            ++i;
        }
        return retList.toArray(new ICustomFeature[0]);
    }

    @Override
    public IDeleteFeature getDeleteFeature(IDeleteContext context) {
        IFeatureChecker featureChecker = this.getFeatureChecker();
        if (featureChecker == null || featureChecker.allowDelete(context)) {
            return super.getDeleteFeature(context);
        }
        return null;
    }

    @Override
    public IDirectEditingFeature getDirectEditingFeature(IDirectEditingContext context) {
        IFeatureChecker featureChecker = this.getFeatureChecker();
        if (featureChecker == null || featureChecker.allowAdd(context)) {
            return super.getDirectEditingFeature(context);
        }
        return null;
    }

    @Override
    public IFeature[] getDragAndDropFeatures(IPictogramElementContext context) {
        IFeatureChecker featureChecker = this.getFeatureChecker();
        if (featureChecker == null || featureChecker.allowDragAndDrop(context)) {
            return super.getDragAndDropFeatures(context);
        }
        return new IFeature[0];
    }

    protected IFeatureChecker getFeatureChecker() {
        IToolBehaviorProvider currentToolBehaviorProvider = this.getDiagramTypeProvider().getCurrentToolBehaviorProvider();
        if (currentToolBehaviorProvider instanceof IFeatureCheckerHolder) {
            IFeatureCheckerHolder holder = (IFeatureCheckerHolder)((Object)currentToolBehaviorProvider);
            IFeatureChecker featureChecker = holder.getFeatureChecker();
            return featureChecker;
        }
        return null;
    }

    @Override
    public ILayoutFeature getLayoutFeature(ILayoutContext context) {
        IFeatureChecker featureChecker = this.getFeatureChecker();
        if (featureChecker == null || featureChecker.allowAdd(context)) {
            return super.getLayoutFeature(context);
        }
        return null;
    }

    @Override
    public IMoveAnchorFeature getMoveAnchorFeature(IMoveAnchorContext context) {
        IFeatureChecker featureChecker = this.getFeatureChecker();
        if (featureChecker == null || featureChecker.allowMove(context)) {
            return super.getMoveAnchorFeature(context);
        }
        return null;
    }

    @Override
    public IMoveBendpointFeature getMoveBendpointFeature(IMoveBendpointContext context) {
        IFeatureChecker featureChecker = this.getFeatureChecker();
        if (featureChecker == null || featureChecker.allowMove(context)) {
            return super.getMoveBendpointFeature(context);
        }
        return null;
    }

    @Override
    public IMoveConnectionDecoratorFeature getMoveConnectionDecoratorFeature(IMoveConnectionDecoratorContext context) {
        IFeatureChecker featureChecker = this.getFeatureChecker();
        if (featureChecker == null || featureChecker.allowMove(context)) {
            return super.getMoveConnectionDecoratorFeature(context);
        }
        return null;
    }

    @Override
    public IMoveShapeFeature getMoveShapeFeature(IMoveShapeContext context) {
        IFeatureChecker featureChecker = this.getFeatureChecker();
        if (featureChecker == null || featureChecker.allowMove(context)) {
            return super.getMoveShapeFeature(context);
        }
        return null;
    }

    @Override
    public IPasteFeature getPasteFeature(IPasteContext context) {
        IFeatureChecker featureChecker = this.getFeatureChecker();
        if (featureChecker == null || featureChecker.allowPaste(context)) {
            return super.getPasteFeature(context);
        }
        return null;
    }

    @Override
    public IReconnectionFeature getReconnectionFeature(IReconnectionContext context) {
        IFeatureChecker featureChecker = this.getFeatureChecker();
        if (featureChecker == null || featureChecker.allowReconnect(context)) {
            return super.getReconnectionFeature(context);
        }
        return null;
    }

    @Override
    public IRemoveBendpointFeature getRemoveBendpointFeature(IRemoveBendpointContext context) {
        IFeatureChecker featureChecker = this.getFeatureChecker();
        if (featureChecker == null || featureChecker.allowRemove(context)) {
            return super.getRemoveBendpointFeature(context);
        }
        return null;
    }

    @Override
    public IRemoveFeature getRemoveFeature(IRemoveContext context) {
        IFeatureChecker featureChecker = this.getFeatureChecker();
        if (featureChecker == null || featureChecker.allowRemove(context)) {
            return super.getRemoveFeature(context);
        }
        return null;
    }

    @Override
    public IResizeShapeFeature getResizeShapeFeature(IResizeShapeContext context) {
        IFeatureChecker featureChecker = this.getFeatureChecker();
        if (featureChecker == null || featureChecker.allowResize(context)) {
            return super.getResizeShapeFeature(context);
        }
        return null;
    }

    @Override
    public IUpdateFeature getUpdateFeature(IUpdateContext context) {
        IFeatureChecker featureChecker = this.getFeatureChecker();
        if (featureChecker == null || featureChecker.allowUpdate(context)) {
            return super.getUpdateFeature(context);
        }
        return null;
    }
}

