/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.editors.sql.plan.diagram.features;

import com.dbeaver.ui.editors.sql.plan.diagram.renders.PlanNodeRenderInfo;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.impl.AbstractLayoutFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class PlansLayoutNodeFeature
extends AbstractLayoutFeature {
    public PlansLayoutNodeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canLayout(ILayoutContext context) {
        PictogramElement pe = context.getPictogramElement();
        if (pe == null) {
            return false;
        }
        if (!(pe instanceof ContainerShape)) {
            return false;
        }
        if (pe.getLink() == null) {
            return false;
        }
        for (Object o : pe.getLink().getBusinessObjects()) {
            if (!(o instanceof PlanNodeRenderInfo)) continue;
            return true;
        }
        return false;
    }

    public boolean layout(ILayoutContext context) {
        boolean anythingChanged = false;
        ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
        GraphicsAlgorithm containerGA = containerShape.getGraphicsAlgorithm();
        if (containerGA.getGraphicsAlgorithmChildren().size() == 0) {
            return false;
        }
        GraphicsAlgorithm visibleRectangle = (GraphicsAlgorithm)containerGA.getGraphicsAlgorithmChildren().get(0);
        int requestedHeight = containerGA.getHeight();
        int requestedWidth = containerGA.getWidth();
        if (visibleRectangle.getHeight() != requestedHeight) {
            visibleRectangle.setHeight(requestedHeight);
            anythingChanged = true;
        }
        if (visibleRectangle.getWidth() != requestedWidth) {
            visibleRectangle.setWidth(requestedWidth);
            anythingChanged = true;
        }
        return anythingChanged;
    }
}

