/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import oracle.xml.parser.v2.XMLParser;
import oracle.xml.xpath.XPathCompileEvents;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathItem;
import oracle.xml.xpath.XPathRuntimeContext;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xpath.XSLNodeSetExpr;
import oracle.xml.xpath.XSLParseString;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xslt.XSLException;

class UnaryExpr
extends XSLExprBase {
    UnaryExpr() {
        super.setExprType(1048632);
    }

    static XSLExprBase parse(XSLParseString xSLParseString) throws XSLException, XQException {
        int n = 1;
        XPathCompileEvents xPathCompileEvents = xSLParseString.getXPathCompileEvents();
        if (xPathCompileEvents != null) {
            xPathCompileEvents.reportEventsNoParam(120, 0);
        }
        while (xSLParseString.peekToken(104)) {
            if (xSLParseString.getOperator() == 201) {
                n *= -1;
                continue;
            }
            if (xSLParseString.getXSLTVersion() != 10 || xSLParseString.getOperator() != 200) continue;
            throw new XPathException(1013, xSLParseString.getExprString());
        }
        XSLExprBase xSLExprBase = XSLNodeSetExpr.parse(xSLParseString);
        if (n == -1) {
            UnaryExpr unaryExpr = new UnaryExpr();
            unaryExpr.setCompatibilityFlags(xSLParseString.getXSLTVersion(), xSLParseString.isBackwardCompatibilityMode(), xSLParseString.isForwardCompatibilityMode());
            unaryExpr.leftExpr = xSLExprBase;
            xSLExprBase = unaryExpr;
        }
        if (xPathCompileEvents != null && xSLExprBase instanceof UnaryExpr) {
            xPathCompileEvents.reportEventsWithIntParam(120, 1, xSLParseString.getOperator(), 0);
        }
        return xSLExprBase;
    }

    @Override
    int checkPosLastFN() {
        if (this.flag < 0) {
            this.flag = this.leftExpr.checkPosLastFN();
        }
        return this.flag;
    }

    @Override
    void cacheSubExpr() throws XQException {
        if (this.leftExpr.canCacheExpr()) {
            this.leftExpr = this.leftExpr.createCachedExpr();
        }
    }

    @Override
    boolean canCacheExpr() {
        return this.leftExpr.canCacheExpr();
    }

    @Override
    public String getNormalizedExpr() throws XQException {
        StringBuffer stringBuffer = new StringBuffer(this.leftExpr.getNormalizedExpr());
        stringBuffer.insert(0, 201);
        return stringBuffer.toString();
    }

    @Override
    public void evaluate(XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        xPathRuntimeContext.setCompatibilityFlags(this.getXSLTVersion(), this.isBackwardCompatibilityMode(), this.isForwardCompatibilityMode());
        this.leftExpr.evaluate(xPathRuntimeContext);
        if (this.getXSLTVersion() == 20 && !this.isBackwardCompatibilityMode() || this.getXSLTVersion() == 10 && this.isForwardCompatibilityMode()) {
            XPathSequence xPathSequence = new XPathSequence(xPathRuntimeContext);
            XPathItem xPathItem = xPathSequence.ctx.allocItem();
            if (XMLParser.getIs1010Compatible()) {
                xPathItem.setDouble(OXMLSequenceType.TDOUBLE, -1.0);
            } else {
                xPathItem.setInt(OXMLSequenceType.TINTEGER, -1);
            }
            xPathSequence.appendItem(xPathItem);
            XPathSequence.arithmetic20(xPathRuntimeContext.peekExprValue(), xPathSequence, 202);
        } else {
            XPathSequence xPathSequence = new XPathSequence(xPathRuntimeContext);
            XPathItem xPathItem = xPathSequence.ctx.allocItem();
            xPathItem.setDouble(OXMLSequenceType.TDOUBLE, -1.0);
            xPathSequence.appendItem(xPathItem);
            XPathSequence.arithmetic(xPathRuntimeContext.peekExprValue(), xPathSequence, 202);
        }
    }
}

