/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.Expression;
import org.relique.jdbc.csv.LogicalExpression;
import org.relique.jdbc.csv.Placeholder;

class ParsedExpression
extends LogicalExpression {
    public Expression content;
    private Map<String, Object> placeholders;

    public ParsedExpression(Expression expression) {
        this.content = expression;
        this.placeholders = new HashMap<String, Object>();
    }

    @Override
    public boolean isValid() {
        return this.content.isValid();
    }

    @Override
    public Boolean isTrue(Map<String, Object> map) throws SQLException {
        if (!this.placeholders.isEmpty()) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.putAll(map);
            hashMap.putAll(this.placeholders);
            map = hashMap;
        }
        return ((LogicalExpression)this.content).isTrue(map);
    }

    @Override
    public Object eval(Map<String, Object> map) throws SQLException {
        if (!this.placeholders.isEmpty()) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.putAll(map);
            hashMap.putAll(this.placeholders);
            map = hashMap;
        }
        return this.content.eval(map);
    }

    public String toString() {
        return this.content.toString();
    }

    @Override
    public List<String> usedColumns(Set<String> set) {
        return this.content.usedColumns(set);
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        return this.content.aggregateFunctions();
    }

    @Override
    public void resetAggregateFunctions() {
        this.content.resetAggregateFunctions();
    }

    public int getPlaceholdersCount() {
        return Placeholder.nextIndex - 1;
    }

    public void setPlaceholdersValues(Object[] objectArray) {
        for (int i = 1; i < objectArray.length; ++i) {
            this.placeholders.put("?" + i, objectArray[i]);
        }
    }
}

