/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.team.git.ui.handlers;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IProject;
import org.eclipse.egit.ui.internal.sharing.SharingWizard;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.team.git.ui.utils.GitUIUtils;

public class ProjectShareHandler
extends AbstractHandler
implements IElementUpdater {
    private static final String CMD_SHARE = "org.eclipse.egit.ui.command.shareProject";

    public Object execute(ExecutionEvent event) {
        IProject project = GitUIUtils.extractActiveProject(event);
        if (project == null) {
            DBWorkbench.getPlatformUI().showError("Nothing to share - no active project", "Select a project or resource to share");
            return null;
        }
        IWorkbench workbench = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getWorkbench();
        SharingWizard wizard = new SharingWizard();
        wizard.init(workbench, project);
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)wizard);
        wizardDialog.setHelpAvailable(false);
        wizardDialog.open();
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        IProject project = GitUIUtils.extractActiveProject(element.getServiceLocator());
        if (project != null) {
            element.setText("Add '" + project.getName() + "' to Git repository");
        }
    }
}

