/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.sqlfire.datatype;

import java.sql.Timestamp;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.core.FirebirdDatabase;
import liquibase.database.core.H2Database;
import liquibase.database.core.HsqlDatabase;
import liquibase.database.core.InformixDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.database.core.SQLiteDatabase;
import liquibase.datatype.DataTypeInfo;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.LiquibaseDataType;
import liquibase.ext.sqlfire.database.SQLFireDatabase;
import liquibase.statement.DatabaseFunction;

@DataTypeInfo(name="datetime", aliases={"java.sql.Types.DATETIME", "java.util.Date", "smalldatetime", "datetime2"}, minParameters=0, maxParameters=1, priority=1)
public class DateTimeType
extends LiquibaseDataType {
    public DatabaseDataType toDatabaseDataType(Database database) {
        if (database instanceof DB2Database || database instanceof DerbyDatabase || database instanceof SQLFireDatabase || database instanceof FirebirdDatabase || database instanceof H2Database || database instanceof HsqlDatabase || database instanceof OracleDatabase) {
            return new DatabaseDataType("TIMESTAMP");
        }
        if (database instanceof MSSQLDatabase && this.getParameters().length > 0 && "16".equals(this.getParameters()[0])) {
            return new DatabaseDataType("SMALLDATETIME");
        }
        if (database instanceof InformixDatabase) {
            return new DatabaseDataType("DATETIME YEAR TO FRACTION", new Object[]{5});
        }
        if (database instanceof PostgresDatabase) {
            return new DatabaseDataType("TIMESTAMP WITH TIME ZONE");
        }
        if (database instanceof SQLiteDatabase) {
            return new DatabaseDataType("TEXT");
        }
        if (database instanceof MySQLDatabase) {
            return new DatabaseDataType(this.getName());
        }
        return new DatabaseDataType(this.getName());
    }

    public String objectToSql(Object value, Database database) {
        if (value == null || value.toString().equalsIgnoreCase("null")) {
            return null;
        }
        if (value instanceof DatabaseFunction) {
            return database.generateDatabaseFunctionValue((DatabaseFunction)value);
        }
        if (database.isFunction(value.toString())) {
            return value.toString();
        }
        if (value instanceof String) {
            return "'" + ((String)value).replaceAll("'", "''") + "'";
        }
        return database.getDateTimeLiteral((Timestamp)value);
    }

    public Object sqlToObject(String value, Database database) {
        if (database instanceof DB2Database) {
            return value.replaceFirst("^\"SYSIBM\".\"TIMESTAMP\"\\('", "").replaceFirst("'\\)", "");
        }
        if (database instanceof DerbyDatabase) {
            return value.replaceFirst("^TIMESTAMP\\('", "").replaceFirst("'\\)", "");
        }
        return super.sqlToObject(value, database);
    }
}

