/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.sqlfire.database;

import liquibase.CatalogAndSchema;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.exception.DatabaseException;
import liquibase.executor.ExecutorService;
import liquibase.logging.LogFactory;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.DatabaseObject;

public class SQLFireDatabase
extends AbstractJdbcDatabase {
    public SQLFireDatabase() {
        super.setCurrentDateTimeFunction("CURRENT_TIMESTAMP");
        this.sequenceNextValueFunction = "NEXT VALUE FOR %s";
        this.sequenceCurrentValueFunction = "(SELECT currentvalue FROM sys.syssequences WHERE %s='SEQ_TYPE')";
    }

    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return "Apache Derby".equalsIgnoreCase(conn.getDatabaseProductName()) && conn.getURL().startsWith("jdbc:sqlfire:");
    }

    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:sqlfire://")) {
            return "com.vmware.sqlfire.jdbc.ClientDriver";
        }
        return null;
    }

    public int getPriority() {
        return 5;
    }

    public boolean supportsSchemas() {
        return false;
    }

    public boolean jdbcCallsCatalogsSchemas() {
        return true;
    }

    public Integer getDefaultPort() {
        return 1527;
    }

    protected String getDefaultDatabaseProductName() {
        return "SqlFire";
    }

    public String correctObjectName(String objectName, Class<? extends DatabaseObject> objectType) {
        if (objectName == null) {
            return null;
        }
        return objectName.toUpperCase();
    }

    public String getShortName() {
        return "sqlfire";
    }

    public boolean supportsSequences() {
        return false;
    }

    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    public String getDateLiteral(String isoDate) {
        if (this.isDateOnly(isoDate)) {
            return "DATE(" + super.getDateLiteral(isoDate) + ")";
        }
        if (this.isTimeOnly(isoDate)) {
            return "TIME(" + super.getDateLiteral(isoDate) + ")";
        }
        String dateString = super.getDateLiteral(isoDate);
        int decimalDigits = dateString.length() - dateString.indexOf(46) - 2;
        String padding = "";
        for (int i = 6; i > decimalDigits; --i) {
            padding = padding + "0";
        }
        return "TIMESTAMP(" + dateString.replaceFirst("'$", padding + "'") + ")";
    }

    public boolean supportsTablespaces() {
        return false;
    }

    public String getViewDefinition(CatalogAndSchema schema, String name) throws DatabaseException {
        return super.getViewDefinition(schema, name).replaceFirst("CREATE VIEW \\w+ AS ", "");
    }

    protected String getConnectionCatalogName() throws DatabaseException {
        try {
            return (String)ExecutorService.getInstance().getExecutor((Database)this).queryForObject((SqlStatement)new RawSqlStatement("select current schema from sysibm.sysdummy1"), String.class);
        }
        catch (Exception e) {
            LogFactory.getLogger().info("Error getting default schema", (Throwable)e);
            return null;
        }
    }

    public boolean supportsCatalogInObjectName(Class<? extends DatabaseObject> type) {
        return true;
    }
}

