/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.OptionGroupOptionSetting;
import software.amazon.awssdk.services.rds.model.OptionGroupOptionSettingsListCopier;
import software.amazon.awssdk.services.rds.model.OptionGroupOptionVersionsListCopier;
import software.amazon.awssdk.services.rds.model.OptionVersion;
import software.amazon.awssdk.services.rds.model.OptionsConflictsWithCopier;
import software.amazon.awssdk.services.rds.model.OptionsDependedOnCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OptionGroupOption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OptionGroupOption> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OptionGroupOption.getter(OptionGroupOption::name)).setter(OptionGroupOption.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OptionGroupOption.getter(OptionGroupOption::description)).setter(OptionGroupOption.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ENGINE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OptionGroupOption.getter(OptionGroupOption::engineName)).setter(OptionGroupOption.setter(Builder::engineName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineName").build()}).build();
    private static final SdkField<String> MAJOR_ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OptionGroupOption.getter(OptionGroupOption::majorEngineVersion)).setter(OptionGroupOption.setter(Builder::majorEngineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MajorEngineVersion").build()}).build();
    private static final SdkField<String> MINIMUM_REQUIRED_MINOR_ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OptionGroupOption.getter(OptionGroupOption::minimumRequiredMinorEngineVersion)).setter(OptionGroupOption.setter(Builder::minimumRequiredMinorEngineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumRequiredMinorEngineVersion").build()}).build();
    private static final SdkField<Boolean> PORT_REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(OptionGroupOption.getter(OptionGroupOption::portRequired)).setter(OptionGroupOption.setter(Builder::portRequired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortRequired").build()}).build();
    private static final SdkField<Integer> DEFAULT_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(OptionGroupOption.getter(OptionGroupOption::defaultPort)).setter(OptionGroupOption.setter(Builder::defaultPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultPort").build()}).build();
    private static final SdkField<List<String>> OPTIONS_DEPENDED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(OptionGroupOption.getter(OptionGroupOption::optionsDependedOn)).setter(OptionGroupOption.setter(Builder::optionsDependedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionsDependedOn").build(), ListTrait.builder().memberLocationName("OptionName").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionName").build()}).build()).build()}).build();
    private static final SdkField<List<String>> OPTIONS_CONFLICTS_WITH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(OptionGroupOption.getter(OptionGroupOption::optionsConflictsWith)).setter(OptionGroupOption.setter(Builder::optionsConflictsWith)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionsConflictsWith").build(), ListTrait.builder().memberLocationName("OptionConflictName").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionConflictName").build()}).build()).build()}).build();
    private static final SdkField<Boolean> PERSISTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(OptionGroupOption.getter(OptionGroupOption::persistent)).setter(OptionGroupOption.setter(Builder::persistent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Persistent").build()}).build();
    private static final SdkField<Boolean> PERMANENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(OptionGroupOption.getter(OptionGroupOption::permanent)).setter(OptionGroupOption.setter(Builder::permanent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permanent").build()}).build();
    private static final SdkField<Boolean> REQUIRES_AUTO_MINOR_ENGINE_VERSION_UPGRADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(OptionGroupOption.getter(OptionGroupOption::requiresAutoMinorEngineVersionUpgrade)).setter(OptionGroupOption.setter(Builder::requiresAutoMinorEngineVersionUpgrade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequiresAutoMinorEngineVersionUpgrade").build()}).build();
    private static final SdkField<Boolean> VPC_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(OptionGroupOption.getter(OptionGroupOption::vpcOnly)).setter(OptionGroupOption.setter(Builder::vpcOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcOnly").build()}).build();
    private static final SdkField<Boolean> SUPPORTS_OPTION_VERSION_DOWNGRADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(OptionGroupOption.getter(OptionGroupOption::supportsOptionVersionDowngrade)).setter(OptionGroupOption.setter(Builder::supportsOptionVersionDowngrade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsOptionVersionDowngrade").build()}).build();
    private static final SdkField<List<OptionGroupOptionSetting>> OPTION_GROUP_OPTION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(OptionGroupOption.getter(OptionGroupOption::optionGroupOptionSettings)).setter(OptionGroupOption.setter(Builder::optionGroupOptionSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupOptionSettings").build(), ListTrait.builder().memberLocationName("OptionGroupOptionSetting").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OptionGroupOptionSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupOptionSetting").build()}).build()).build()}).build();
    private static final SdkField<List<OptionVersion>> OPTION_GROUP_OPTION_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(OptionGroupOption.getter(OptionGroupOption::optionGroupOptionVersions)).setter(OptionGroupOption.setter(Builder::optionGroupOptionVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupOptionVersions").build(), ListTrait.builder().memberLocationName("OptionVersion").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OptionVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionVersion").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, ENGINE_NAME_FIELD, MAJOR_ENGINE_VERSION_FIELD, MINIMUM_REQUIRED_MINOR_ENGINE_VERSION_FIELD, PORT_REQUIRED_FIELD, DEFAULT_PORT_FIELD, OPTIONS_DEPENDED_ON_FIELD, OPTIONS_CONFLICTS_WITH_FIELD, PERSISTENT_FIELD, PERMANENT_FIELD, REQUIRES_AUTO_MINOR_ENGINE_VERSION_UPGRADE_FIELD, VPC_ONLY_FIELD, SUPPORTS_OPTION_VERSION_DOWNGRADE_FIELD, OPTION_GROUP_OPTION_SETTINGS_FIELD, OPTION_GROUP_OPTION_VERSIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final String engineName;
    private final String majorEngineVersion;
    private final String minimumRequiredMinorEngineVersion;
    private final Boolean portRequired;
    private final Integer defaultPort;
    private final List<String> optionsDependedOn;
    private final List<String> optionsConflictsWith;
    private final Boolean persistent;
    private final Boolean permanent;
    private final Boolean requiresAutoMinorEngineVersionUpgrade;
    private final Boolean vpcOnly;
    private final Boolean supportsOptionVersionDowngrade;
    private final List<OptionGroupOptionSetting> optionGroupOptionSettings;
    private final List<OptionVersion> optionGroupOptionVersions;

    private OptionGroupOption(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.engineName = builder.engineName;
        this.majorEngineVersion = builder.majorEngineVersion;
        this.minimumRequiredMinorEngineVersion = builder.minimumRequiredMinorEngineVersion;
        this.portRequired = builder.portRequired;
        this.defaultPort = builder.defaultPort;
        this.optionsDependedOn = builder.optionsDependedOn;
        this.optionsConflictsWith = builder.optionsConflictsWith;
        this.persistent = builder.persistent;
        this.permanent = builder.permanent;
        this.requiresAutoMinorEngineVersionUpgrade = builder.requiresAutoMinorEngineVersionUpgrade;
        this.vpcOnly = builder.vpcOnly;
        this.supportsOptionVersionDowngrade = builder.supportsOptionVersionDowngrade;
        this.optionGroupOptionSettings = builder.optionGroupOptionSettings;
        this.optionGroupOptionVersions = builder.optionGroupOptionVersions;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String engineName() {
        return this.engineName;
    }

    public String majorEngineVersion() {
        return this.majorEngineVersion;
    }

    public String minimumRequiredMinorEngineVersion() {
        return this.minimumRequiredMinorEngineVersion;
    }

    public Boolean portRequired() {
        return this.portRequired;
    }

    public Integer defaultPort() {
        return this.defaultPort;
    }

    public List<String> optionsDependedOn() {
        return this.optionsDependedOn;
    }

    public List<String> optionsConflictsWith() {
        return this.optionsConflictsWith;
    }

    public Boolean persistent() {
        return this.persistent;
    }

    public Boolean permanent() {
        return this.permanent;
    }

    public Boolean requiresAutoMinorEngineVersionUpgrade() {
        return this.requiresAutoMinorEngineVersionUpgrade;
    }

    public Boolean vpcOnly() {
        return this.vpcOnly;
    }

    public Boolean supportsOptionVersionDowngrade() {
        return this.supportsOptionVersionDowngrade;
    }

    public List<OptionGroupOptionSetting> optionGroupOptionSettings() {
        return this.optionGroupOptionSettings;
    }

    public List<OptionVersion> optionGroupOptionVersions() {
        return this.optionGroupOptionVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.majorEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumRequiredMinorEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.portRequired());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionsDependedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionsConflictsWith());
        hashCode = 31 * hashCode + Objects.hashCode(this.persistent());
        hashCode = 31 * hashCode + Objects.hashCode(this.permanent());
        hashCode = 31 * hashCode + Objects.hashCode(this.requiresAutoMinorEngineVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcOnly());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsOptionVersionDowngrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionGroupOptionSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionGroupOptionVersions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptionGroupOption)) {
            return false;
        }
        OptionGroupOption other = (OptionGroupOption)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.engineName(), other.engineName()) && Objects.equals(this.majorEngineVersion(), other.majorEngineVersion()) && Objects.equals(this.minimumRequiredMinorEngineVersion(), other.minimumRequiredMinorEngineVersion()) && Objects.equals(this.portRequired(), other.portRequired()) && Objects.equals(this.defaultPort(), other.defaultPort()) && Objects.equals(this.optionsDependedOn(), other.optionsDependedOn()) && Objects.equals(this.optionsConflictsWith(), other.optionsConflictsWith()) && Objects.equals(this.persistent(), other.persistent()) && Objects.equals(this.permanent(), other.permanent()) && Objects.equals(this.requiresAutoMinorEngineVersionUpgrade(), other.requiresAutoMinorEngineVersionUpgrade()) && Objects.equals(this.vpcOnly(), other.vpcOnly()) && Objects.equals(this.supportsOptionVersionDowngrade(), other.supportsOptionVersionDowngrade()) && Objects.equals(this.optionGroupOptionSettings(), other.optionGroupOptionSettings()) && Objects.equals(this.optionGroupOptionVersions(), other.optionGroupOptionVersions());
    }

    public String toString() {
        return ToString.builder((String)"OptionGroupOption").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("EngineName", (Object)this.engineName()).add("MajorEngineVersion", (Object)this.majorEngineVersion()).add("MinimumRequiredMinorEngineVersion", (Object)this.minimumRequiredMinorEngineVersion()).add("PortRequired", (Object)this.portRequired()).add("DefaultPort", (Object)this.defaultPort()).add("OptionsDependedOn", this.optionsDependedOn()).add("OptionsConflictsWith", this.optionsConflictsWith()).add("Persistent", (Object)this.persistent()).add("Permanent", (Object)this.permanent()).add("RequiresAutoMinorEngineVersionUpgrade", (Object)this.requiresAutoMinorEngineVersionUpgrade()).add("VpcOnly", (Object)this.vpcOnly()).add("SupportsOptionVersionDowngrade", (Object)this.supportsOptionVersionDowngrade()).add("OptionGroupOptionSettings", this.optionGroupOptionSettings()).add("OptionGroupOptionVersions", this.optionGroupOptionVersions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EngineName": {
                return Optional.ofNullable(clazz.cast(this.engineName()));
            }
            case "MajorEngineVersion": {
                return Optional.ofNullable(clazz.cast(this.majorEngineVersion()));
            }
            case "MinimumRequiredMinorEngineVersion": {
                return Optional.ofNullable(clazz.cast(this.minimumRequiredMinorEngineVersion()));
            }
            case "PortRequired": {
                return Optional.ofNullable(clazz.cast(this.portRequired()));
            }
            case "DefaultPort": {
                return Optional.ofNullable(clazz.cast(this.defaultPort()));
            }
            case "OptionsDependedOn": {
                return Optional.ofNullable(clazz.cast(this.optionsDependedOn()));
            }
            case "OptionsConflictsWith": {
                return Optional.ofNullable(clazz.cast(this.optionsConflictsWith()));
            }
            case "Persistent": {
                return Optional.ofNullable(clazz.cast(this.persistent()));
            }
            case "Permanent": {
                return Optional.ofNullable(clazz.cast(this.permanent()));
            }
            case "RequiresAutoMinorEngineVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.requiresAutoMinorEngineVersionUpgrade()));
            }
            case "VpcOnly": {
                return Optional.ofNullable(clazz.cast(this.vpcOnly()));
            }
            case "SupportsOptionVersionDowngrade": {
                return Optional.ofNullable(clazz.cast(this.supportsOptionVersionDowngrade()));
            }
            case "OptionGroupOptionSettings": {
                return Optional.ofNullable(clazz.cast(this.optionGroupOptionSettings()));
            }
            case "OptionGroupOptionVersions": {
                return Optional.ofNullable(clazz.cast(this.optionGroupOptionVersions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OptionGroupOption, T> g) {
        return obj -> g.apply((OptionGroupOption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String engineName;
        private String majorEngineVersion;
        private String minimumRequiredMinorEngineVersion;
        private Boolean portRequired;
        private Integer defaultPort;
        private List<String> optionsDependedOn = DefaultSdkAutoConstructList.getInstance();
        private List<String> optionsConflictsWith = DefaultSdkAutoConstructList.getInstance();
        private Boolean persistent;
        private Boolean permanent;
        private Boolean requiresAutoMinorEngineVersionUpgrade;
        private Boolean vpcOnly;
        private Boolean supportsOptionVersionDowngrade;
        private List<OptionGroupOptionSetting> optionGroupOptionSettings = DefaultSdkAutoConstructList.getInstance();
        private List<OptionVersion> optionGroupOptionVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OptionGroupOption model) {
            this.name(model.name);
            this.description(model.description);
            this.engineName(model.engineName);
            this.majorEngineVersion(model.majorEngineVersion);
            this.minimumRequiredMinorEngineVersion(model.minimumRequiredMinorEngineVersion);
            this.portRequired(model.portRequired);
            this.defaultPort(model.defaultPort);
            this.optionsDependedOn(model.optionsDependedOn);
            this.optionsConflictsWith(model.optionsConflictsWith);
            this.persistent(model.persistent);
            this.permanent(model.permanent);
            this.requiresAutoMinorEngineVersionUpgrade(model.requiresAutoMinorEngineVersionUpgrade);
            this.vpcOnly(model.vpcOnly);
            this.supportsOptionVersionDowngrade(model.supportsOptionVersionDowngrade);
            this.optionGroupOptionSettings(model.optionGroupOptionSettings);
            this.optionGroupOptionVersions(model.optionGroupOptionVersions);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getEngineName() {
            return this.engineName;
        }

        @Override
        public final Builder engineName(String engineName) {
            this.engineName = engineName;
            return this;
        }

        public final void setEngineName(String engineName) {
            this.engineName = engineName;
        }

        public final String getMajorEngineVersion() {
            return this.majorEngineVersion;
        }

        @Override
        public final Builder majorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
            return this;
        }

        public final void setMajorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
        }

        public final String getMinimumRequiredMinorEngineVersion() {
            return this.minimumRequiredMinorEngineVersion;
        }

        @Override
        public final Builder minimumRequiredMinorEngineVersion(String minimumRequiredMinorEngineVersion) {
            this.minimumRequiredMinorEngineVersion = minimumRequiredMinorEngineVersion;
            return this;
        }

        public final void setMinimumRequiredMinorEngineVersion(String minimumRequiredMinorEngineVersion) {
            this.minimumRequiredMinorEngineVersion = minimumRequiredMinorEngineVersion;
        }

        public final Boolean getPortRequired() {
            return this.portRequired;
        }

        @Override
        public final Builder portRequired(Boolean portRequired) {
            this.portRequired = portRequired;
            return this;
        }

        public final void setPortRequired(Boolean portRequired) {
            this.portRequired = portRequired;
        }

        public final Integer getDefaultPort() {
            return this.defaultPort;
        }

        @Override
        public final Builder defaultPort(Integer defaultPort) {
            this.defaultPort = defaultPort;
            return this;
        }

        public final void setDefaultPort(Integer defaultPort) {
            this.defaultPort = defaultPort;
        }

        public final Collection<String> getOptionsDependedOn() {
            return this.optionsDependedOn;
        }

        @Override
        public final Builder optionsDependedOn(Collection<String> optionsDependedOn) {
            this.optionsDependedOn = OptionsDependedOnCopier.copy(optionsDependedOn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionsDependedOn(String ... optionsDependedOn) {
            this.optionsDependedOn(Arrays.asList(optionsDependedOn));
            return this;
        }

        public final void setOptionsDependedOn(Collection<String> optionsDependedOn) {
            this.optionsDependedOn = OptionsDependedOnCopier.copy(optionsDependedOn);
        }

        public final Collection<String> getOptionsConflictsWith() {
            return this.optionsConflictsWith;
        }

        @Override
        public final Builder optionsConflictsWith(Collection<String> optionsConflictsWith) {
            this.optionsConflictsWith = OptionsConflictsWithCopier.copy(optionsConflictsWith);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionsConflictsWith(String ... optionsConflictsWith) {
            this.optionsConflictsWith(Arrays.asList(optionsConflictsWith));
            return this;
        }

        public final void setOptionsConflictsWith(Collection<String> optionsConflictsWith) {
            this.optionsConflictsWith = OptionsConflictsWithCopier.copy(optionsConflictsWith);
        }

        public final Boolean getPersistent() {
            return this.persistent;
        }

        @Override
        public final Builder persistent(Boolean persistent) {
            this.persistent = persistent;
            return this;
        }

        public final void setPersistent(Boolean persistent) {
            this.persistent = persistent;
        }

        public final Boolean getPermanent() {
            return this.permanent;
        }

        @Override
        public final Builder permanent(Boolean permanent) {
            this.permanent = permanent;
            return this;
        }

        public final void setPermanent(Boolean permanent) {
            this.permanent = permanent;
        }

        public final Boolean getRequiresAutoMinorEngineVersionUpgrade() {
            return this.requiresAutoMinorEngineVersionUpgrade;
        }

        @Override
        public final Builder requiresAutoMinorEngineVersionUpgrade(Boolean requiresAutoMinorEngineVersionUpgrade) {
            this.requiresAutoMinorEngineVersionUpgrade = requiresAutoMinorEngineVersionUpgrade;
            return this;
        }

        public final void setRequiresAutoMinorEngineVersionUpgrade(Boolean requiresAutoMinorEngineVersionUpgrade) {
            this.requiresAutoMinorEngineVersionUpgrade = requiresAutoMinorEngineVersionUpgrade;
        }

        public final Boolean getVpcOnly() {
            return this.vpcOnly;
        }

        @Override
        public final Builder vpcOnly(Boolean vpcOnly) {
            this.vpcOnly = vpcOnly;
            return this;
        }

        public final void setVpcOnly(Boolean vpcOnly) {
            this.vpcOnly = vpcOnly;
        }

        public final Boolean getSupportsOptionVersionDowngrade() {
            return this.supportsOptionVersionDowngrade;
        }

        @Override
        public final Builder supportsOptionVersionDowngrade(Boolean supportsOptionVersionDowngrade) {
            this.supportsOptionVersionDowngrade = supportsOptionVersionDowngrade;
            return this;
        }

        public final void setSupportsOptionVersionDowngrade(Boolean supportsOptionVersionDowngrade) {
            this.supportsOptionVersionDowngrade = supportsOptionVersionDowngrade;
        }

        public final Collection<OptionGroupOptionSetting.Builder> getOptionGroupOptionSettings() {
            return this.optionGroupOptionSettings != null ? (Collection)this.optionGroupOptionSettings.stream().map(OptionGroupOptionSetting::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder optionGroupOptionSettings(Collection<OptionGroupOptionSetting> optionGroupOptionSettings) {
            this.optionGroupOptionSettings = OptionGroupOptionSettingsListCopier.copy(optionGroupOptionSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionGroupOptionSettings(OptionGroupOptionSetting ... optionGroupOptionSettings) {
            this.optionGroupOptionSettings(Arrays.asList(optionGroupOptionSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionGroupOptionSettings(Consumer<OptionGroupOptionSetting.Builder> ... optionGroupOptionSettings) {
            this.optionGroupOptionSettings(Stream.of(optionGroupOptionSettings).map(c -> (OptionGroupOptionSetting)((OptionGroupOptionSetting.Builder)OptionGroupOptionSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOptionGroupOptionSettings(Collection<OptionGroupOptionSetting.BuilderImpl> optionGroupOptionSettings) {
            this.optionGroupOptionSettings = OptionGroupOptionSettingsListCopier.copyFromBuilder(optionGroupOptionSettings);
        }

        public final Collection<OptionVersion.Builder> getOptionGroupOptionVersions() {
            return this.optionGroupOptionVersions != null ? (Collection)this.optionGroupOptionVersions.stream().map(OptionVersion::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder optionGroupOptionVersions(Collection<OptionVersion> optionGroupOptionVersions) {
            this.optionGroupOptionVersions = OptionGroupOptionVersionsListCopier.copy(optionGroupOptionVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionGroupOptionVersions(OptionVersion ... optionGroupOptionVersions) {
            this.optionGroupOptionVersions(Arrays.asList(optionGroupOptionVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionGroupOptionVersions(Consumer<OptionVersion.Builder> ... optionGroupOptionVersions) {
            this.optionGroupOptionVersions(Stream.of(optionGroupOptionVersions).map(c -> (OptionVersion)((OptionVersion.Builder)OptionVersion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOptionGroupOptionVersions(Collection<OptionVersion.BuilderImpl> optionGroupOptionVersions) {
            this.optionGroupOptionVersions = OptionGroupOptionVersionsListCopier.copyFromBuilder(optionGroupOptionVersions);
        }

        public OptionGroupOption build() {
            return new OptionGroupOption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OptionGroupOption> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder engineName(String var1);

        public Builder majorEngineVersion(String var1);

        public Builder minimumRequiredMinorEngineVersion(String var1);

        public Builder portRequired(Boolean var1);

        public Builder defaultPort(Integer var1);

        public Builder optionsDependedOn(Collection<String> var1);

        public Builder optionsDependedOn(String ... var1);

        public Builder optionsConflictsWith(Collection<String> var1);

        public Builder optionsConflictsWith(String ... var1);

        public Builder persistent(Boolean var1);

        public Builder permanent(Boolean var1);

        public Builder requiresAutoMinorEngineVersionUpgrade(Boolean var1);

        public Builder vpcOnly(Boolean var1);

        public Builder supportsOptionVersionDowngrade(Boolean var1);

        public Builder optionGroupOptionSettings(Collection<OptionGroupOptionSetting> var1);

        public Builder optionGroupOptionSettings(OptionGroupOptionSetting ... var1);

        public Builder optionGroupOptionSettings(Consumer<OptionGroupOptionSetting.Builder> ... var1);

        public Builder optionGroupOptionVersions(Collection<OptionVersion> var1);

        public Builder optionGroupOptionVersions(OptionVersion ... var1);

        public Builder optionGroupOptionVersions(Consumer<OptionVersion.Builder> ... var1);
    }
}

