/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxStatement;
import com.informix.util.IfxErrMsg;
import com.informix.util.dateUtil;
import com.informix.util.memoryUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class IfxVarChar
extends IfxObject {
    private static final int h = 255;
    protected String value;
    private String i;
    private String j;

    IfxVarChar() throws SQLException {
        this.setIfxType(13);
    }

    IfxVarChar(String string) throws SQLException {
        block3: {
            block2: {
                this.setIfxType(13);
                this.value = string;
                if (this.value != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.unnullify();
        }
    }

    @Override
    public byte[] toIfx() throws SQLException {
        try {
            String string = this.conn.getdbEncoding();
            return ((IfxSqliConnect)this.conn).javatoifx.JavaToIfxChar(this.value, string, ((IfxSqliConnect)this.conn).encoption);
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    @Override
    public byte[] toIfxTuple() throws SQLException {
        try {
            block6: {
                byte[] byArray;
                block8: {
                    block7: {
                        if (!this.isNull()) break block6;
                        if (!((IfxSqliConnect)this.conn).r()) break block7;
                        byArray = new byte[2];
                        if (IfxStatement.t == 0) break block8;
                    }
                    byArray = new byte[this.encodedLength + 1];
                }
                memoryUtil.byfill(byArray, (byte)0);
                byArray[0] = 1;
                return byArray;
            }
            String string = this.conn.getdbEncoding();
            byte[] byArray = ((IfxSqliConnect)this.conn).javatoifx.JavaToIfxVarChar(this.value, string, this.encodedLength, ((IfxSqliConnect)this.conn).encoption);
            if (((IfxSqliConnect)this.conn).r()) {
                int n = 1 + (0xFF & byArray[0]);
                byte[] byArray2 = new byte[n];
                System.arraycopy(byArray, 0, byArray2, 0, n);
                return byArray2;
            }
            return byArray;
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    @Override
    public void fromIfx(byte[] byArray) throws SQLException {
        this.fromIfx(byArray, 0, byArray.length);
    }

    @Override
    public void fromIfx(byte[] byArray, int n, int n2) throws SQLException {
        try {
            block9: {
                int n3;
                block8: {
                    n3 = byArray[n] & 0xFF;
                    if (n3 == 1 && byArray[n + 1] == 0) {
                        this.value = null;
                        this.nullify();
                        return;
                    }
                    if (n3 != 0) break block8;
                    this.value = new String("");
                    if (IfxStatement.t == 0) break block9;
                }
                String string = this.conn.getdbEncoding();
                if (n2 > 0) {
                    n3 = Math.min(n3, n2);
                }
                if (((IfxSqliConnect)this.conn).isOnLine5SER()) {
                    string = "NOCODING";
                }
                this.value = ((IfxSqliConnect)this.conn).ifxtojava.IfxToJavaChar(byArray, n + 1, n3, string, ((IfxSqliConnect)this.conn).encoption);
            }
            this.unnullify();
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    @Override
    public Object toObject() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    public byte[] toBytes() throws SQLException {
        byte[] byArray;
        block3: {
            block4: {
                byArray = null;
                if (this.value != null) break block4;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            try {
                String string = ((IfxSqliConnect)this.conn).returnEnc();
                byte[] byArray2 = ((IfxSqliConnect)this.conn).javatoifx.JavaToIfxChar(this.value, string, ((IfxSqliConnect)this.conn).encoption);
                int n = byArray2.length;
                byArray = new byte[n - 2];
                System.arraycopy(byArray2, 2, byArray, 0, n - 2);
            }
            catch (Exception exception) {
                this.value = null;
                if (!(exception instanceof IOException)) break block3;
                throw IfxErrMsg.getSQLException(-79783, this.conn);
            }
        }
        return byArray;
    }

    @Override
    public String toString() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    public void fromString(String string) throws SQLException {
        this.fromString(string, false);
    }

    @Override
    public void fromString(String string, boolean bl) throws SQLException {
        block3: {
            block5: {
                String string2;
                block4: {
                    int n;
                    block2: {
                        n = IfxStatement.t;
                        if (string != null) break block2;
                        this.nullify();
                        if (n == 0) break block3;
                    }
                    this.clearWarning();
                    string2 = null;
                    string2 = bl ? string.trim() : string;
                    if (string2.length() <= 255) break block4;
                    this.value = string2.substring(0, 255);
                    if (n == 0) break block5;
                }
                this.value = string2;
            }
            this.unnullify();
        }
    }

    @Override
    public void fromBytes(byte[] byArray) throws SQLException {
        block4: {
            block5: {
                if (byArray != null) break block5;
                this.nullify();
                if (IfxStatement.t == 0) break block4;
            }
            try {
                int n = byArray.length;
                if (byArray.length > 255) {
                    n = 255;
                }
                String string = this.conn.getdbEncoding();
                this.value = ((IfxSqliConnect)this.conn).ifxtojava.IfxToJavaChar(byArray, 0, n, string, ((IfxSqliConnect)this.conn).encoption);
                this.unnullify();
            }
            catch (Exception exception) {
                this.value = null;
                if (!(exception instanceof IOException)) break block4;
                throw IfxErrMsg.getSQLException(-79783, this.conn);
            }
        }
    }

    @Override
    public byte toByte() throws SQLException {
        byte by;
        if (this.isNull()) {
            return 0;
        }
        try {
            by = Byte.parseByte(this.value);
        }
        catch (Exception exception) {
            throw new SQLException(IfxErrMsg.getMessage(-79716, this.conn) + exception.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
        return by;
    }

    @Override
    public void fromByte(Byte by) throws SQLException {
        block3: {
            block2: {
                if (by != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.fromByte((byte)by);
        }
    }

    @Override
    public void fromByte(byte by) throws SQLException {
        this.value = String.valueOf(by);
        this.unnullify();
    }

    @Override
    public boolean toBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        return this.value.equalsIgnoreCase("1") || this.value.equalsIgnoreCase("true") || this.value.equalsIgnoreCase("t");
    }

    @Override
    public void fromBoolean(Boolean bl) throws SQLException {
        block3: {
            block2: {
                if (bl != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.fromBoolean((boolean)bl);
        }
    }

    @Override
    public void fromBoolean(boolean bl) throws SQLException {
        block3: {
            block2: {
                if (!bl) break block2;
                this.value = "true";
                if (IfxStatement.t == 0) break block3;
            }
            this.value = "false";
        }
        this.unnullify();
    }

    @Override
    public int toInt() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        try {
            this.b(this.value);
            Integer n = Integer.parseInt(this.i);
            return n;
        }
        catch (Exception exception) {
            throw new SQLException(IfxErrMsg.getMessage(-79716, this.conn) + exception.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
    }

    private void b(String string) {
        int n;
        int n2;
        int n3;
        block12: {
            int n4;
            block14: {
                block13: {
                    int n5;
                    int n6;
                    block11: {
                        n4 = IfxStatement.t;
                        if (string == null) {
                            this.value = string;
                            this.i = string;
                            this.nullify();
                            return;
                        }
                        this.value = string;
                        n3 = string.length();
                        for (n2 = n3 - 1; n2 >= 0; --n2) {
                            n6 = string.charAt(n2);
                            n5 = 32;
                            if (n4 == 0) {
                                if (n6 != n5) break;
                                if (n4 == 0) continue;
                            }
                            break block11;
                        }
                        n6 = n2;
                        n5 = n3 - 1;
                    }
                    if (n6 == n5) break block13;
                    this.i = string.substring(0, ++n2);
                    if (n4 == 0) break block14;
                }
                this.i = string;
            }
            if (this.conn != null && this.conn.getTrimTrailingSpaces()) {
                this.j = this.i;
            }
            n3 = this.i.length();
            for (n2 = 0; n2 < n3; ++n2) {
                n = string.charAt(n2);
                if (n4 == 0) {
                    if (n != 32) break;
                    if (n4 == 0) continue;
                }
                break block12;
            }
            n = n2;
        }
        if (n != 0) {
            this.i = this.i.substring(n2, n3);
        }
        this.unnullify();
    }

    @Override
    public void fromInt(Integer n) throws SQLException {
        block3: {
            block2: {
                if (n != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.fromInt((int)n);
        }
    }

    @Override
    public void fromInt(int n) throws SQLException {
        this.value = Integer.toString(n);
        this.unnullify();
    }

    @Override
    public void fromDecimal(BigDecimal bigDecimal) throws SQLException {
        block3: {
            block2: {
                if (bigDecimal != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.value = bigDecimal.toString();
            this.unnullify();
        }
    }

    @Override
    public short toShort() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        try {
            Short s = new Short(this.value);
            return s;
        }
        catch (Exception exception) {
            throw new SQLException(IfxErrMsg.getMessage(-79716) + exception.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
    }

    @Override
    public void fromShort(Short s) throws SQLException {
        block3: {
            block2: {
                if (s != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.fromShort((short)s);
        }
    }

    @Override
    public void fromShort(short s) throws SQLException {
        this.value = String.valueOf(s);
        this.unnullify();
    }

    @Override
    public long toLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        try {
            return Long.parseLong(this.value);
        }
        catch (Exception exception) {
            throw new SQLException(IfxErrMsg.getMessage(-79716, this.conn) + exception.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
    }

    @Override
    public void fromLong(Long l2) throws SQLException {
        block3: {
            block2: {
                if (l2 != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.fromLong((long)l2);
        }
    }

    @Override
    public void fromLong(long l2) throws SQLException {
        this.value = String.valueOf(l2);
        this.unnullify();
    }

    @Override
    public float toFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        Float f2 = Float.valueOf(this.value);
        return f2.floatValue();
    }

    @Override
    public void fromFloat(Float f2) throws SQLException {
        block3: {
            block2: {
                if (f2 != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.fromFloat(f2.floatValue());
        }
    }

    @Override
    public void fromFloat(float f2) throws SQLException {
        this.value = String.valueOf(f2);
        this.unnullify();
    }

    @Override
    public Date toDate() throws SQLException {
        Date date = null;
        if (this.isNull()) {
            return null;
        }
        try {
            date = dateUtil.convertDateObj(this.value, this.conn);
        }
        catch (Exception exception) {
            throw new SQLException(IfxErrMsg.getMessage(-79716, this.conn) + exception.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
        return date;
    }

    @Override
    public void fromDate(Date date) throws SQLException {
        block3: {
            block2: {
                if (date != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.value = dateUtil.convertDateStr(date, this.conn);
            this.unnullify();
        }
    }

    @Override
    public Time toTime() throws SQLException {
        Time time;
        long l2 = 0L;
        if (this.isNull()) {
            return null;
        }
        try {
            boolean bl = true;
            Object object = dateUtil.convertDateTimeObj(this.value, this.conn, bl);
            l2 = ((java.util.Date)object).getTime();
            time = new Time(l2);
        }
        catch (Exception exception) {
            throw new SQLException(IfxErrMsg.getMessage(-79716, this.conn) + exception.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
        return time;
    }

    @Override
    public void fromTime(Time time) throws SQLException {
        block3: {
            block2: {
                if (time != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            long l2 = time.getTime();
            this.value = dateUtil.convertDateTimeStr(time, this.conn, l2);
            this.unnullify();
        }
    }

    @Override
    public Timestamp toTimestamp() throws SQLException {
        Timestamp timestamp;
        if (this.isNull()) {
            return null;
        }
        try {
            boolean bl = false;
            timestamp = (Timestamp)dateUtil.convertDateTimeObj(this.value, this.conn, bl);
        }
        catch (Exception exception) {
            throw new SQLException(IfxErrMsg.getMessage(-79716, this.conn) + exception.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
        return timestamp;
    }

    @Override
    public void fromTimestamp(Timestamp timestamp) throws SQLException {
        block3: {
            block2: {
                if (timestamp != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            long l2 = timestamp.getTime();
            this.value = dateUtil.convertDateTimeStr(timestamp, this.conn, l2);
            this.unnullify();
        }
    }

    @Override
    public double toDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        Double d2 = Double.valueOf(this.value);
        return d2;
    }

    @Override
    public void fromDouble(Double d2) throws SQLException {
        block3: {
            block2: {
                if (d2 != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.fromDouble((double)d2);
        }
    }

    @Override
    public void fromDouble(double d2) throws SQLException {
        this.value = String.valueOf(d2);
        this.unnullify();
    }

    @Override
    public BigDecimal toDecimal() throws SQLException {
        BigDecimal bigDecimal;
        if (this.isNull()) {
            return null;
        }
        try {
            bigDecimal = new BigDecimal(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            throw IfxErrMsg.getSQLException(-79716, numberFormatException.toString(), this.conn);
        }
        return bigDecimal;
    }

    public void fromBigDecimal(BigDecimal bigDecimal) throws SQLException {
        block3: {
            block2: {
                if (bigDecimal != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.value = bigDecimal.toString();
            this.unnullify();
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this.isNull() || object == null || !(object instanceof IfxVarChar)) {
            return false;
        }
        IfxVarChar ifxVarChar = (IfxVarChar)object;
        if (ifxVarChar.isNull()) {
            return false;
        }
        return this.value.equals(ifxVarChar.value);
    }

    @Override
    public InputStream toAsciiStream() throws SQLException {
        byte[] byArray;
        block5: {
            if (this.isNull()) {
                return null;
            }
            try {
                String string = this.conn.getdbEncoding();
                if (string != null) {
                    byArray = this.value.getBytes(string);
                    if (IfxStatement.t == 0) break block5;
                }
                byArray = this.value.getBytes();
            }
            catch (IOException iOException) {
                throw IfxErrMsg.getSQLException(-79783, this.conn);
            }
        }
        return new ByteArrayInputStream(byArray);
    }

    @Override
    public void fromAsciiStream(InputStream inputStream, int n) throws SQLException {
        block5: {
            block7: {
                int n2;
                block6: {
                    n2 = IfxStatement.t;
                    this.a(3, "IfxVarChar: fromAsciiStream()");
                    if (inputStream == null) break block5;
                    this.a(3, "IfxVarChar: fromAsciiStream(): length = " + n);
                    if (n != 0) break block6;
                    this.value = "";
                    if (n2 == 0) break block7;
                }
                byte[] byArray = new byte[n];
                int n3 = 0;
                try {
                    block2: while (true) {
                        int n4 = inputStream.read(byArray, n3, n);
                        this.a(3, "IfxVarChar: fromAsciiStream(): readLen=" + n4);
                        this.a(3, "IfxVarChar: fromAsciiStream(): length = " + (n -= n4));
                        this.a(3, "IfxVarChar: fromAsciiStream(): offset =" + (n3 += n4));
                        do {
                            if (n > 0) continue block2;
                        } while (n2 != 0);
                        break;
                    }
                }
                catch (Exception exception) {
                    throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
                }
                this.value = new String(byArray);
                this.a(3, "IfxVarChar: value = " + this.value);
            }
            this.unnullify();
        }
    }

    @Override
    public void fromInputStream(InputStream inputStream, int n) throws SQLException {
        this.fromAsciiStream(inputStream, n);
    }

    @Override
    public InputStream toInputStream() throws SQLException {
        return this.toAsciiStream();
    }

    @Override
    public void fromCharacterStream(Reader reader, int n) throws SQLException {
        block5: {
            block7: {
                int n2;
                block6: {
                    n2 = IfxStatement.t;
                    this.a(3, "IfxVarChar: fromCharacterStream()");
                    if (reader == null) break block5;
                    this.a(3, "IfxVarChar: fromCharacterStream():length =" + n);
                    if (n != 0) break block6;
                    this.value = "";
                    if (n2 == 0) break block7;
                }
                char[] cArray = new char[n];
                int n3 = 0;
                BufferedReader bufferedReader = new BufferedReader(reader);
                try {
                    block2: while (true) {
                        int n4 = reader.read(cArray, n3, n);
                        this.a(3, "IfxVarChar: fromcharacterStream():readLen=" + n4);
                        this.a(3, "IfxVarChar: fromCharacterStream():length=" + (n -= n4));
                        this.a(3, "IfxVarChar: fromCharacterStream():offset=" + (n3 += n4));
                        do {
                            if (n > 0) continue block2;
                        } while (n2 != 0);
                        break;
                    }
                }
                catch (Exception exception) {
                    throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
                }
                this.value = new String(cArray);
                this.a(3, "IfxVarChar: value = " + this.value);
            }
            this.unnullify();
        }
    }

    @Override
    public Reader toCharacterStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        this.a(99, "IfxVarChar: toCharacterStream()");
        this.a(3, "IfxVarChar: toCharacterStream(): value = " + this.value);
        return new StringReader(this.value);
    }
}

