/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxLoStat;
import com.informix.jdbc.IfxLob;
import com.informix.jdbc.IfxLobDescriptor;
import com.informix.jdbc.IfxLocator;
import com.informix.jdbc.IfxSmartBlob;
import com.informix.jdbc.IfxSmartLobOutputStream;
import com.informix.jdbc.IfxTmpFile;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;

public class IfxBblob
extends IfxLob
implements Blob {
    private Trace a = null;

    public IfxBblob() {
        this.ifxType = (short)2;
        this.smartBlobMode = 2;
    }

    public IfxBblob(IfxLocator ifxLocator) {
        this.locatorPointer = ifxLocator;
        this.ifxType = (short)2;
        this.smartBlobMode = 2;
    }

    public IfxBblob(IfxConnection ifxConnection, IfxLocator ifxLocator) throws SQLException {
        this.conn = ifxConnection;
        this.ifxType = (short)2;
        this.smartBlobMode = 0;
        this.smb = new IfxSmartBlob(ifxConnection);
        this.smb.IfxLoOpen(ifxLocator, ifxConnection.isReadOnly() ? 4 : 8);
    }

    protected IfxBblob(byte[] byArray) {
        this.blobBuffer = byArray;
        this.ifxType = (short)2;
        this.smartBlobMode = 0;
    }

    public IfxBblob(InputStream inputStream) {
        this.blobStream = inputStream;
        this.ifxType = (short)2;
        this.smartBlobMode = 2;
    }

    protected IfxBblob(IfxTmpFile ifxTmpFile) {
        this.tempBlobFile = ifxTmpFile;
        this.tempBlobFile.incRefCount();
        this.ifxType = (short)2;
        this.smartBlobMode = 0;
    }

    public IfxBblob(Connection connection, InputStream inputStream, int n) throws SQLException {
        super(connection, inputStream, n);
        this.ifxType = (short)2;
        this.smartBlobMode = 1;
    }

    public IfxBblob(Connection connection, InputStream inputStream, int n, String string) throws SQLException {
        super(connection, inputStream, n, string);
        this.ifxType = (short)2;
        this.smartBlobMode = 1;
    }

    public IfxBblob(Connection connection, InputStream inputStream, int n, IfxLobDescriptor ifxLobDescriptor) throws SQLException {
        super(connection, inputStream, n, ifxLobDescriptor);
        this.ifxType = (short)2;
        this.smartBlobMode = 1;
    }

    public IfxBblob(Connection connection, byte[] byArray) throws SQLException {
        super(connection, byArray);
        this.ifxType = (short)2;
        this.smartBlobMode = 1;
    }

    public IfxBblob(Connection connection, byte[] byArray, String string) throws SQLException {
        super(connection, byArray, string);
        this.ifxType = (short)2;
        this.smartBlobMode = 1;
    }

    public IfxBblob(Connection connection, byte[] byArray, IfxLobDescriptor ifxLobDescriptor) throws SQLException {
        super(connection, byArray, ifxLobDescriptor);
        this.ifxType = (short)2;
        this.smartBlobMode = 1;
    }

    @Override
    public IfxLocator getLocator() throws SQLException {
        return super.getLocator();
    }

    @Override
    public long length() throws SQLException {
        return this.blobSize;
    }

    @Override
    public byte[] getBytes(long l2, int n) throws SQLException {
        return super.getPortion(l2, n);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return super.getStream();
    }

    @Override
    public long position(byte[] byArray, long l2) throws SQLException {
        long l3 = l2 - 1L;
        byte[] byArray2 = super.getPortion(1L, this.blobSize);
        if (byArray2 == null) {
            return -1L;
        }
        String string = new String(byArray2);
        long l4 = string.indexOf(new String(byArray), (int)l3);
        if (l4 >= 0L) {
            ++l4;
        }
        return l4;
    }

    @Override
    public long position(Blob blob, long l2) throws SQLException {
        return this.position(blob.getBytes(1L, (int)blob.length()), l2);
    }

    public void setBinaryStream(long l2, InputStream inputStream, int n) throws SQLException {
        this.a();
        this.smb.IfxLoSeek(this.smb.getHandle(), l2, 0);
        super.setStream(inputStream, n);
    }

    @Override
    public int setBytes(long l2, byte[] byArray) throws SQLException {
        return this.setBytes(l2, byArray, 0, byArray == null ? 0 : byArray.length);
    }

    @Override
    public void close() throws SQLException {
        super.close();
    }

    @Override
    public long seek(long l2, int n) throws SQLException {
        return super.seek(l2, n);
    }

    @Override
    public long where() throws SQLException {
        return super.where();
    }

    @Override
    public IfxLoStat getLoStat() throws SQLException {
        return super.getLoStat();
    }

    @Override
    public void truncate(long l2) throws SQLException {
        super.truncate(l2);
    }

    @Override
    public int setBytes(long l2, byte[] byArray, int n, int n2) throws SQLException {
        this.a();
        this.smb.IfxLoSeek(this.smb.getHandle(), l2, 0);
        return super.setBuffer(byArray, n, n2);
    }

    @Override
    public OutputStream setBinaryStream(long l2) throws SQLException {
        this.a();
        return new IfxSmartLobOutputStream(this, l2);
    }

    protected synchronized void finalize() {
        try {
            if (this.smb != null) {
                super.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void a() throws SQLException {
        if (this.ifxType != 2) {
            throw IfxErrMsg.getSQLException(-79787, this.conn);
        }
        this.verifySmbMode();
    }

    @Override
    public void free() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCblob:free()", this.conn);
    }

    @Override
    public InputStream getBinaryStream(long l2, long l3) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCblob.getCharacterStream(long , long)", this.conn);
    }
}

