/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.cassandra.model;

import com.dbeaver.ee.cassandra.CasUtils;
import com.dbeaver.ee.cassandra.model.CasDataSource;
import com.dbeaver.ee.cassandra.model.CasPrivilegeGrant;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.access.DBAUser;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class CasRole
implements DBAUser {
    private final CasDataSource dataSource;
    private final String name;
    private final boolean isSuperUser;
    private final boolean canLogin;
    private final Map<String, String> options;
    private List<CasPrivilegeGrant> privilegeGrants;

    public CasRole(CasDataSource dataSource, String name, boolean isSuperUser, boolean canLogin, Map<String, String> options) {
        this.dataSource = dataSource;
        this.name = name;
        this.isSuperUser = isSuperUser;
        this.canLogin = canLogin;
        this.options = options;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public DBSObject getParentObject() {
        return this.dataSource;
    }

    @NotNull
    public CasDataSource getDataSource() {
        return this.dataSource;
    }

    public boolean isPersisted() {
        return true;
    }

    public String getDescription() {
        return null;
    }

    @Property(viewable=true, order=2)
    public boolean isSuperUser() {
        return this.isSuperUser;
    }

    @Property(viewable=true, order=3)
    public boolean isCanLogin() {
        return this.canLogin;
    }

    @Property(viewable=true, order=10)
    public Map<String, String> getOptions() {
        return this.options;
    }

    @Association
    public List<CasPrivilegeGrant> getPrivilegeGrants(DBRProgressMonitor monitor) throws DBCException {
        if (this.privilegeGrants == null) {
            this.privilegeGrants = CasUtils.readPermissions(monitor, this.getDataSource(), "LIST ALL OF " + this.getName());
        }
        return this.privilegeGrants;
    }
}

