/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.edit;

import com.dbeaver.db.dynamodb.model.DynamoDataSource;
import com.dbeaver.db.dynamodb.model.DynamoTable;
import com.dbeaver.db.dynamodb.model.DynamoTableAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.DirectDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLStructEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableRequest;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;

public class DynamoTableManager
extends SQLTableManager<DynamoTable, DynamoDataSource> {
    private static final Class<?>[] CHILD_TYPES = new Class[]{DynamoTableAttribute.class};

    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    @NotNull
    public Class<?>[] getChildTypes() {
        return CHILD_TYPES;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, DynamoTable> getObjectsCache(DynamoTable object) {
        return object.getDataSource().getTableCache();
    }

    protected DynamoTable createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        DynamoTable newTable = new DynamoTable((DynamoDataSource)container, "NewTable", false);
        newTable.setReadCapacityUnits(10L);
        newTable.setWriteCapacityUnits(10L);
        return newTable;
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, final SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new DirectDatabasePersistAction("Drop table"){

            public void afterExecute(DBCSession session, Throwable error) throws DBCException {
                DynamoTable table = (DynamoTable)command.getObject();
                try {
                    table.getDataSource().getClient().deleteTable((DeleteTableRequest)DeleteTableRequest.builder().tableName(table.getName()).build());
                }
                catch (Exception e) {
                    throw new DBCException("Error deleting Dynamo table", (Throwable)e);
                }
            }
        });
    }

    protected void addStructObjectCreateActions(final DBRProgressMonitor monitor, List<DBEPersistAction> actions, final SQLStructEditor.StructCreateCommand command, Map<String, Object> options) throws DBException {
        actions.add((DBEPersistAction)new DirectDatabasePersistAction("Create table"){

            public void afterExecute(DBCSession session, Throwable error) throws DBCException {
                DynamoTable table = (DynamoTable)command.getObject();
                CreateTableRequest.Builder ctBuilder = CreateTableRequest.builder().tableName(table.getName());
                ArrayList<AttributeDefinition> attributes = new ArrayList<AttributeDefinition>();
                ArrayList<KeySchemaElement> ksItems = new ArrayList<KeySchemaElement>();
                for (DynamoTableAttribute attr : table.getAttributes(monitor)) {
                    attributes.add((AttributeDefinition)AttributeDefinition.builder().attributeName(attr.getName()).attributeType(attr.getType()).build());
                    if (!attr.isKey() || attr.getKeyType() == null) continue;
                    ksItems.add((KeySchemaElement)KeySchemaElement.builder().attributeName(attr.getName()).keyType(attr.getKeyType()).build());
                }
                ctBuilder.attributeDefinitions(attributes);
                ctBuilder.keySchema(ksItems);
                ctBuilder.provisionedThroughput(table.getProvisionedThroughput());
                try {
                    table.getDataSource().getClient().createTable((CreateTableRequest)ctBuilder.build());
                }
                catch (Exception e) {
                    throw new DBCException("Error creating Dynamo table", (Throwable)e);
                }
            }
        });
    }
}

