/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.IConstants;
import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.Param;
import com.sybase.jdbc4.jdbc.ParamManager;
import com.sybase.jdbc4.jdbc.Protocol;
import com.sybase.jdbc4.tds.DataFormat;
import com.sybase.jdbc4.tds.ParamDataFormat2;
import com.sybase.jdbc4.tds.ParamFormatToken;
import com.sybase.jdbc4.tds.TdsInputStream;
import com.sybase.jdbc4.tds.TdsOutputStream;
import com.sybase.jdbc4.tds.TdsParam;
import java.io.IOException;
import java.sql.SQLException;

public class ParamFormat2Token
extends ParamFormatToken {
    public static final long MAX_PARAMFMT2_LENGTH = 0xFFFFFFFFL;

    public ParamFormat2Token() {
    }

    public ParamFormat2Token(ParamManager paramManager, boolean bl) throws IOException, SQLException {
        super(paramManager, bl);
    }

    public ParamFormat2Token(TdsInputStream tdsInputStream) throws IOException {
        super(tdsInputStream);
    }

    public ParamFormat2Token(ParamManager paramManager, Param[] paramArray, Protocol protocol, IConstants.STATEMENT_EXECUTION_MODE sTATEMENT_EXECUTION_MODE, boolean bl) throws IOException, SQLException {
        super(paramManager, paramArray, protocol, sTATEMENT_EXECUTION_MODE, bl);
    }

    @Override
    protected DataFormat dataFormatFactory(TdsInputStream tdsInputStream) throws IOException {
        return new ParamDataFormat2(tdsInputStream);
    }

    @Override
    protected long readLength(TdsInputStream tdsInputStream) throws IOException {
        long l = tdsInputStream.readUnsignedIntAsLong();
        return l;
    }

    @Override
    public void send(TdsOutputStream tdsOutputStream) throws IOException {
        tdsOutputStream.writeByte(32);
        tdsOutputStream.writeLongAsUnsignedInt(this.getLength());
        tdsOutputStream.writeShort(this.getFormatCount());
        this.sendFormat(tdsOutputStream);
    }

    @Override
    public void sendAddBatch(Param[] paramArray, TdsOutputStream tdsOutputStream) throws IOException {
        long l = this.getLength();
        if (l > 0xFFFFFFFFL) {
            ErrorMessage.raiseIOException("JZ0PF");
        } else {
            tdsOutputStream.writeByte(32);
            tdsOutputStream.writeInt((int)l);
            tdsOutputStream.writeShort(this.getFormatCount());
            TdsParam tdsParam = null;
            for (int i = 0; i < paramArray.length; ++i) {
                tdsParam = (TdsParam)paramArray[i];
                tdsParam.sendFormat(tdsOutputStream);
            }
        }
    }
}

