/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.mutaterows;

import com.google.api.core.InternalApi;
import com.google.api.gax.batching.PartitionKey;
import com.google.api.gax.batching.RequestBuilder;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.BatchedRequestIssuer;
import com.google.api.gax.rpc.BatchingDescriptor;
import com.google.bigtable.v2.MutateRowsRequest;
import com.google.cloud.bigtable.data.v2.models.MutateRowsException;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

@InternalApi
public class MutateRowsBatchingDescriptor
implements BatchingDescriptor<MutateRowsRequest, Void> {
    public PartitionKey getBatchPartitionKey(MutateRowsRequest request) {
        return new PartitionKey(new Object[]{request.getTableName()});
    }

    public RequestBuilder<MutateRowsRequest> getRequestBuilder() {
        return new MyRequestBuilder();
    }

    public void splitResponse(Void batchResponse, Collection<? extends BatchedRequestIssuer<Void>> batch) {
        for (BatchedRequestIssuer<Void> batchedRequestIssuer : batch) {
            batchedRequestIssuer.setResponse(null);
        }
    }

    public void splitException(Throwable throwable, Collection<? extends BatchedRequestIssuer<Void>> batch) {
        if (!(throwable instanceof MutateRowsException)) {
            for (BatchedRequestIssuer<Void> batchedRequestIssuer : batch) {
                batchedRequestIssuer.setException(throwable);
            }
            return;
        }
        List<MutateRowsException.FailedMutation> failedMutations = ((MutateRowsException)((Object)throwable)).getFailedMutations();
        ImmutableMap immutableMap = Maps.uniqueIndex(failedMutations, (Function)new Function<MutateRowsException.FailedMutation, Integer>(){

            @Nullable
            public Integer apply(@Nullable MutateRowsException.FailedMutation input) {
                return input.getIndex();
            }
        });
        int i = 0;
        for (BatchedRequestIssuer<Void> batchedRequestIssuer : batch) {
            ApiException lastError = null;
            int j = 0;
            while ((long)j < batchedRequestIssuer.getMessageCount()) {
                MutateRowsException.FailedMutation failure;
                if ((failure = (MutateRowsException.FailedMutation)immutableMap.get(i++)) != null) {
                    lastError = failure.getError();
                }
                ++j;
            }
            if (lastError == null) {
                batchedRequestIssuer.setResponse(null);
                continue;
            }
            batchedRequestIssuer.setException(lastError);
        }
    }

    public long countElements(MutateRowsRequest request) {
        return request.getEntriesCount();
    }

    public long countBytes(MutateRowsRequest request) {
        return request.getSerializedSize();
    }

    static class MyRequestBuilder
    implements RequestBuilder<MutateRowsRequest> {
        private MutateRowsRequest.Builder builder;

        MyRequestBuilder() {
        }

        public void appendRequest(MutateRowsRequest request) {
            if (this.builder == null) {
                this.builder = request.toBuilder();
            } else {
                this.builder.addAllEntries((Iterable)request.getEntriesList());
            }
        }

        public MutateRowsRequest build() {
            return this.builder.build();
        }
    }
}

