/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.edit.SQLServerBaseTableManager;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDatabase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSchema;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerView;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLStructEditor;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.utils.CommonUtils;

public class SQLServerViewManager
extends SQLServerBaseTableManager<SQLServerView> {
    public Class<?>[] getChildTypes() {
        return new Class[0];
    }

    protected void validateObjectProperty(SQLServerView object, DBPPropertyDescriptor property, Object value) throws DBException {
        if (CommonUtils.isEmpty((String)object.getName())) {
            throw new DBException("View name cannot be empty");
        }
    }

    protected SQLServerView createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        SQLServerView newView = new SQLServerView((SQLServerSchema)container);
        try {
            newView.setName(this.getNewChildName(monitor, (DBSObjectContainer)((SQLServerSchema)container), "new_view"));
        }
        catch (DBException e) {
            log.error((Object)e);
        }
        return newView;
    }

    protected void addStructObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLStructEditor.StructCreateCommand command, Map<String, Object> options) throws DBException {
        this.createOrReplaceViewQuery(actions, (SQLServerView)command.getObject(), ViewAction.CREATE);
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        if (command.getProperties().size() > 1 || command.getProperty((Object)"description") == null) {
            this.createOrReplaceViewQuery(actionList, (SQLServerView)command.getObject(), ViewAction.ALTER);
        }
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        this.createOrReplaceViewQuery(actions, (SQLServerView)command.getObject(), ViewAction.DROP);
    }

    private void createOrReplaceViewQuery(List<DBEPersistAction> actions, SQLServerView view, ViewAction action) {
        SQLServerDatabase procDatabase = ((SQLServerSchema)view.getContainer()).getDatabase();
        SQLServerDatabase defaultDatabase = procDatabase.getDataSource().getDefaultObject();
        if (defaultDatabase != procDatabase) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Set current database", "USE " + DBUtils.getQuotedIdentifier((DBSObject)procDatabase), false));
        }
        switch (action) {
            case CREATE: {
                actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create view", view.getDDL()));
                break;
            }
            case ALTER: {
                actions.add((DBEPersistAction)new SQLDatabasePersistAction("Alter view", SQLServerUtils.changeCreateToAlterDDL(((SQLServerDataSource)view.getDataSource()).getSQLDialect(), view.getDDL())));
                break;
            }
            case DROP: {
                actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop view", "DROP VIEW " + view.getFullyQualifiedName(DBPEvaluationContext.DDL)));
            }
        }
        if (defaultDatabase != procDatabase) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Set current database ", "USE " + DBUtils.getQuotedIdentifier((DBSObject)defaultDatabase), false));
        }
    }

    public void renameObject(DBECommandContext commandContext, SQLServerView object, String newName) throws DBException {
        this.processObjectRename(commandContext, object, newName);
    }

    static enum ViewAction {
        CREATE,
        ALTER,
        DROP;

    }
}

