/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.maxdb.sqlgenerator;

import liquibase.database.Database;
import liquibase.ext.maxdb.database.MaxDBDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.SetNullableGenerator;
import liquibase.statement.core.SetNullableStatement;
import liquibase.structure.DatabaseObject;

public class SetNullableGeneratorMaxDB
extends SetNullableGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(SetNullableStatement statement, Database database) {
        return database instanceof MaxDBDatabase;
    }

    public Sql[] generateSql(SetNullableStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String sql = "ALTER TABLE " + database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName()) + " COLUMN  " + database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), statement.getColumnName()) + (statement.isNullable() ? " DEFAULT NULL" : " NOT NULL");
        return new Sql[]{new UnparsedSql(sql, new DatabaseObject[]{this.getAffectedColumn(statement)})};
    }
}

