/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.maxdb.sqlgenerator;

import java.util.List;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.core.DropIndexStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Index;
import liquibase.structure.core.Table;
import liquibase.util.StringUtils;

public class DropIndexGeneratorMaxDB
extends AbstractSqlGenerator<DropIndexStatement> {
    public ValidationErrors validate(DropIndexStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("indexName", (Object)statement.getIndexName());
        validationErrors.checkRequiredField("tableName", (Object)statement.getTableName());
        return validationErrors;
    }

    public Sql[] generateSql(DropIndexStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        List associatedWith = StringUtils.splitAndTrim((String)statement.getAssociatedWith(), (String)",");
        if (associatedWith != null) {
            if (associatedWith.contains("primaryKey") || associatedWith.contains("uniqueConstraint")) {
                return new Sql[0];
            }
            if (associatedWith.contains("foreignKey") && !(database instanceof OracleDatabase) && !(database instanceof MSSQLDatabase)) {
                return new Sql[0];
            }
        }
        String schemaName = statement.getTableSchemaName();
        return new Sql[]{new UnparsedSql("DROP INDEX " + database.escapeIndexName(null, null, statement.getIndexName()) + " ON " + database.escapeTableName(statement.getTableCatalogName(), schemaName, statement.getTableName()), new DatabaseObject[]{this.getAffectedIndex(statement)})};
    }

    protected Index getAffectedIndex(DropIndexStatement statement) {
        Table table = null;
        if (statement.getTableName() != null) {
            table = (Table)new Table().setName(statement.getTableName()).setSchema(statement.getTableCatalogName(), statement.getTableSchemaName());
        }
        return new Index().setName(statement.getIndexName()).setTable(table);
    }
}

