/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.vertica.diff.compare;

import java.util.Set;
import liquibase.database.Database;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.compare.DatabaseObjectComparator;
import liquibase.diff.compare.DatabaseObjectComparatorChain;
import liquibase.ext.vertica.database.VerticaDatabase;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;

public class SchemaComparator
implements DatabaseObjectComparator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (database instanceof VerticaDatabase && Schema.class.isAssignableFrom(objectType)) {
            return 10;
        }
        return -1;
    }

    public String[] hash(DatabaseObject databaseObject, Database accordingTo, DatabaseObjectComparatorChain chain) {
        return chain.hash(databaseObject, accordingTo);
    }

    public boolean isSameObject(DatabaseObject databaseObject1, DatabaseObject databaseObject2, Database accordingTo, DatabaseObjectComparatorChain chain) {
        if (!(databaseObject1 instanceof Schema) || !(databaseObject2 instanceof Schema)) {
            return false;
        }
        String schema1 = ((Schema)databaseObject1).getName();
        String schema2 = ((Schema)databaseObject2).getName();
        if (schema1 == null) {
            return schema2 == null;
        }
        return schema1.equalsIgnoreCase(schema2);
    }

    public ObjectDifferences findDifferences(DatabaseObject databaseObject1, DatabaseObject databaseObject2, Database accordingTo, CompareControl compareControl, DatabaseObjectComparatorChain chain, Set<String> exclude) {
        ObjectDifferences differences = new ObjectDifferences(compareControl);
        differences.compare("name", databaseObject1, databaseObject2, (ObjectDifferences.CompareFunction)new ObjectDifferences.DatabaseObjectNameCompareFunction(Schema.class, accordingTo));
        return differences;
    }
}

